/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import com.google.common.base.Splitter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.transaction.TransactionManager;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.JtaEntityManagerImpl;
import org.batoo.jpa.parser.PersistenceParser;

public class JtaEntityManagerFactoryImpl
extends EntityManagerFactoryImpl {
    private static final BLogger LOG = BLoggerFactory.getLogger(JtaEntityManagerFactoryImpl.class);
    private static final String[] TRANSACTION_MANAGERS = new String[]{"javax.transaction.TransactionManager", "java:/TransactionManager", "java:jboss/TransactionManager", "java:/DefaultDomain/TransactionManager", "java:comp/pm/TransactionManager", "java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager"};
    private static final String[] METHODS = new String[]{"com.arjuna.jta.JTA_TransactionManager#transactionManager", "com.bluestone.jta.SaTransactionManagerFactory#SaGetTransactionManager", "org.openejb.OpenEJB#getTransactionManager", "com.sun.jts.jta.TransactionManagerImpl#getTransactionManagerImpl", "com.inprise.visitransact.jta.TransactionManagerImpl#getTransactionManagerImpl"};
    private final TransactionManager transactionManager = this.lookupTransactionManager();

    public JtaEntityManagerFactoryImpl(String name, PersistenceParser parser) {
        super(name, parser);
    }

    @Override
    public EntityManagerImpl createEntityManager() {
        this.assertOpen();
        return new JtaEntityManagerImpl(this, this.getMetamodel(), this.getDatasource(), Collections.<String, Object>emptyMap(), this.getJdbcAdaptor());
    }

    @Override
    public EntityManager createEntityManager(Map<String, Object> map) {
        this.assertOpen();
        return new JtaEntityManagerImpl(this, this.getMetamodel(), this.getDatasource(), Collections.<String, Object>emptyMap(), this.getJdbcAdaptor());
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    private TransactionManager lookupTransactionManager() {
        for (String jndiName : TRANSACTION_MANAGERS) {
            TransactionManager manager = this.lookupTransactionManager(jndiName);
            if (manager == null) continue;
            LOG.info("Using JTA Transaction manager: {0}", jndiName);
            return manager;
        }
        for (String reflection : METHODS) {
            Iterator i = Splitter.on((String)"#").split((CharSequence)reflection).iterator();
            String className = (String)i.next();
            String methodName = (String)i.next();
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (Throwable e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(e, "TransactionManager lookup class cannot be found {0}", className);
                    continue;
                }
                LOG.debug("TransactionManager lookup class cannot be found {0}", className);
                continue;
            }
            try {
                Method method = clazz.getMethod(methodName, new Class[0]);
                Object instance = Modifier.isStatic(method.getModifiers()) ? null : clazz.newInstance();
                return (TransactionManager)method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("TransactionManager lookup class found but cannot get the transaction manager via reflection {0}", className);
            }
        }
        throw new PersistenceException("Unable to locate the transaction manager");
    }

    private TransactionManager lookupTransactionManager(String jndiName) {
        try {
            LOG.debug("Trying JTA Transaction Manager: {0}", jndiName);
            return (TransactionManager)new InitialContext().lookup(jndiName);
        }
        catch (NamingException namingException) {
            return null;
        }
    }
}

