/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.attribute;

import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToOneAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OptionalAssociationAttributeMetadata;

public class AssociatedSingularAttribute<X, T>
extends SingularAttributeImpl<X, T>
implements SingularAttribute<X, T> {
    private final Attribute.PersistentAttributeType attributeType;
    private final boolean optional;
    private final String mapsId;
    private final boolean id;
    private EntityTypeImpl<T> type;
    private final boolean owner;
    private final boolean joined;

    public AssociatedSingularAttribute(ManagedTypeImpl<X> declaringType, Attribute.PersistentAttributeType attributeType, AssociationAttributeMetadata metadata) {
        super(declaringType, metadata);
        this.attributeType = attributeType;
        OptionalAssociationAttributeMetadata optionalAssociationMetadata = (OptionalAssociationAttributeMetadata)((Object)metadata);
        this.optional = optionalAssociationMetadata.isOptional();
        this.id = optionalAssociationMetadata.isId();
        this.mapsId = optionalAssociationMetadata.getMapsId();
        this.owner = metadata instanceof OneToOneAttributeMetadata ? StringUtils.isBlank((String)((OneToOneAttributeMetadata)metadata).getMappedBy()) : true;
        this.joined = metadata.getJoinTable() == null;
    }

    @Override
    public <Z extends X> AttributeImpl<Z, T> clone(EntityTypeImpl<Z> type) {
        return new AssociatedSingularAttribute<Z, T>(type, this.attributeType, this.getMetadata());
    }

    public String getMapsId() {
        return this.mapsId;
    }

    @Override
    public AssociationAttributeMetadata getMetadata() {
        return (AssociationAttributeMetadata)super.getMetadata();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.attributeType;
    }

    public EntityTypeImpl<T> getType() {
        if (this.type == null) {
            this.type = this.getMetamodel().entity(this.getBindableJavaType());
        }
        return this.type;
    }

    public boolean isAssociation() {
        return true;
    }

    public boolean isId() {
        return this.id;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public boolean isVersion() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("association").append(super.toString());
        if (this.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE) {
            if (this.isOptional()) {
                builder.append(" <*..0>");
            } else {
                builder.append(" <*..1>");
            }
        } else if (this.isOptional()) {
            builder.append(" <0..1>");
        } else {
            builder.append(" <1..1>");
        }
        return builder.toString();
    }
}

