/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.attribute;

import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.collections.ManagedMap;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.attribute.AttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.PluralAttributeMetadata;

public class MapAttributeImpl<X, K, V>
extends PluralAttributeImpl<X, Map<K, V>, V>
implements MapAttribute<X, K, V> {
    private Type<K> keyType;
    private Class<K> keyJavaType;

    public MapAttributeImpl(ManagedTypeImpl<X> declaringType, AttributeMetadata metadata, Attribute.PersistentAttributeType attributeType) {
        super(declaringType, metadata, attributeType, 1);
        PluralAttributeMetadata pluralAttributeMetadata = (PluralAttributeMetadata)((Object)metadata);
        if (StringUtils.isNotBlank((String)pluralAttributeMetadata.getMapKeyClassName())) {
            try {
                ClassLoader classloader = declaringType.getMetamodel().getEntityManagerFactory().getClassloader();
                this.keyJavaType = classloader.loadClass(pluralAttributeMetadata.getMapKeyClassName());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Target entity class not found", metadata.getLocator());
            }
        } else {
            this.keyJavaType = ReflectHelper.getGenericType(this.getJavaMember(), 0);
        }
    }

    public <Z extends X> MapAttributeImpl<Z, K, V> clone(EntityTypeImpl<Z> type) {
        return new MapAttributeImpl<Z, K, V>(type, this.getMetadata(), this.getPersistentAttributeType());
    }

    public PluralAttribute.CollectionType getCollectionType() {
        return PluralAttribute.CollectionType.MAP;
    }

    public Class<K> getKeyJavaType() {
        return this.keyJavaType;
    }

    public Type<K> getKeyType() {
        if (this.keyType != null) {
            return this.keyType;
        }
        MetamodelImpl metamodel = this.getDeclaringType().getMetamodel();
        this.keyType = metamodel.embeddable(this.keyJavaType) != null ? metamodel.embeddable(this.keyJavaType) : metamodel.createBasicType(this.keyJavaType);
        return this.keyType;
    }

    @Override
    public Map<K, V> newCollection(PluralMappingEx<?, Map<K, V>, V> mapping, ManagedInstance<?> managedInstance, boolean lazy) {
        return new ManagedMap(mapping, managedInstance, lazy);
    }

    @Override
    public Map<K, V> newCollection(PluralMappingEx<?, Map<K, V>, V> mapping, ManagedInstance<?> managedInstance, Object values) {
        return new ManagedMap(mapping, managedInstance, (Map)values);
    }
}

