/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.attribute;

import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.model.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.AttributeMetadata;

public abstract class SingularAttributeImpl<X, T>
extends AttributeImpl<X, T>
implements SingularAttribute<X, T> {
    private final Class<T> bindableJavaType;

    public SingularAttributeImpl(ManagedTypeImpl<X> declaringType, AttributeMetadata metadata) {
        super(declaringType, metadata);
        if (metadata instanceof AssociationAttributeMetadata && StringUtils.isNotBlank((String)((AssociationAttributeMetadata)metadata).getTargetEntity())) {
            try {
                ClassLoader classloader = declaringType.getMetamodel().getEntityManagerFactory().getClassloader();
                this.bindableJavaType = classloader.loadClass(((AssociationAttributeMetadata)metadata).getTargetEntity());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Target entity class not found", metadata.getLocator());
            }
        } else {
            this.bindableJavaType = this.getJavaType();
        }
    }

    public final Class<T> getBindableJavaType() {
        return this.bindableJavaType;
    }

    public final Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    public final boolean isCollection() {
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isId()) {
            builder.append("id");
        } else if (this.isVersion()) {
            builder.append("version");
        } else if (this.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
            builder.append("embedded");
        } else {
            builder.append("basic");
        }
        String declaringType = this.getDeclaringType().getJavaType().getSimpleName();
        String type = this.getBindableJavaType().getSimpleName();
        builder.append(" ").append(declaringType).append(".").append(this.getName()).append("(").append(type).append(")");
        return builder.toString();
    }
}

