/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.common.reflect.AbstractAccessor;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.collections.ManagedList;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AbstractParentMapping;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.ListComparator;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.core.impl.model.mapping.SingularMappingEx;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.jdbc.ForeignKey;
import org.batoo.jpa.jdbc.JoinTable;
import org.batoo.jpa.jdbc.Joinable;
import org.batoo.jpa.jdbc.OrderColumn;
import org.batoo.jpa.jdbc.mapping.MappingType;
import org.batoo.jpa.jdbc.mapping.SingularMapping;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.PluralAttributeMetadata;

public class PluralAssociationMappingImpl<Z, C, E>
extends AssociationMappingImpl<Z, C, E>
implements PluralMappingEx<Z, C, E> {
    private final PluralAttributeImpl<? super Z, C, E> attribute;
    private final JoinTable joinTable;
    private final ForeignKey foreignKey;
    private final String mapKey;
    private EntityTypeImpl<E> type;
    private AssociationMappingImpl<?, ?, ?> inverse;
    private SingularMappingEx<? super E, ?> mapKeyMapping;
    private Pair<SingularMapping<?, ?>, AbstractAccessor>[] mapKeyMappings;
    private String orderBy;
    private FinalWrapper<Comparator<E>> comparator;
    private ColumnMetadata orderColumn;
    private ColumnMetadata mapKeyColumn;
    private TemporalType mapKeyTemporalType;
    private EnumType mapKeyEnumType;

    public PluralAssociationMappingImpl(AbstractParentMapping<?, Z> parent, PluralAttributeImpl<? super Z, C, E> attribute) {
        super(parent, (AssociationAttributeMetadata)attribute.getMetadata(), attribute);
        this.attribute = attribute;
        AssociationMetadata metadata = this.getAssociationMetadata();
        if (this.isOwner()) {
            if (this.attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY || metadata.getJoinColumns().size() == 0) {
                this.joinTable = new JoinTable(this.attribute.getMetamodel().getJdbcAdaptor(), (EntityTypeImpl)attribute.getDeclaringType(), this, metadata.getJoinTable());
                this.foreignKey = null;
            } else {
                this.foreignKey = new ForeignKey(this.getAttribute().getMetamodel().getJdbcAdaptor(), this, metadata.getJoinColumns(), true);
                this.joinTable = null;
            }
        } else {
            this.joinTable = null;
            this.foreignKey = null;
        }
        PluralAttributeMetadata pluralAttributeMetadata = (PluralAttributeMetadata)((Object)attribute.getMetadata());
        if (attribute.getCollectionType() == PluralAttribute.CollectionType.LIST) {
            this.orderBy = pluralAttributeMetadata.getOrderBy();
            this.orderColumn = pluralAttributeMetadata.getOrderColumn();
        } else {
            this.orderBy = null;
            this.orderColumn = null;
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            this.mapKeyColumn = pluralAttributeMetadata.getMapKeyColumn();
            this.mapKeyTemporalType = pluralAttributeMetadata.getMapKeyTemporalType();
            this.mapKeyEnumType = pluralAttributeMetadata.getMapKeyEnumType();
            this.mapKey = pluralAttributeMetadata.getMapKey();
        } else {
            this.mapKeyColumn = null;
            this.mapKeyTemporalType = null;
            this.mapKeyEnumType = null;
            this.mapKey = null;
        }
    }

    @Override
    public void attach(Connection connection, ManagedInstance<?> instance, Joinable[] batch, int batchSize) throws SQLException {
        if (this.joinTable != null) {
            this.joinTable.performInsert(connection, instance.getInstance(), batch, batchSize);
        } else if (this.foreignKey != null) {
            this.foreignKey.performAttachChild(connection, instance.getInstance(), batch, batchSize);
        }
    }

    @Override
    public void checkTransient(ManagedInstance<?> managedInstance) {
        block4: {
            SessionImpl session;
            Object values;
            block5: {
                block3: {
                    values = this.get(managedInstance.getInstance());
                    session = managedInstance.getSession();
                    if (!(values instanceof List)) break block3;
                    List list = (List)values;
                    for (int i = 0; i < list.size(); ++i) {
                        session.checkTransient(list.get(i));
                    }
                    break block4;
                }
                if (!(values instanceof Collection)) break block5;
                for (Object entity : ((Collection)values).toArray()) {
                    session.checkTransient(entity);
                }
                break block4;
            }
            if (!(values instanceof Map)) break block4;
            for (Object entity : ((Map)values).values()) {
                session.checkTransient(entity);
            }
        }
    }

    @Override
    public void detach(Connection connection, ManagedInstance<?> instance, Object key, Object child) throws SQLException {
        if (this.joinTable != null) {
            this.joinTable.performRemove(connection, instance.getInstance(), key, child);
        } else if (this.foreignKey != null) {
            this.foreignKey.performDetachChild(connection, key, child);
        }
    }

    @Override
    public void detachAll(Connection connection, ManagedInstance<?> instance) throws SQLException {
        if (this.joinTable != null) {
            this.joinTable.performRemoveAll(connection, instance.getInstance());
        } else if (this.foreignKey != null) {
            this.foreignKey.performDetachAll(connection, instance.getInstance());
        }
    }

    @Override
    public void enhance(ManagedInstance<?> instance) {
        Object c = this.get(instance.getInstance());
        if (c == null) {
            this.set(instance.getInstance(), this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, false));
        } else {
            this.set(instance.getInstance(), this.attribute.newCollection(this, instance, c));
        }
    }

    @Override
    public Object extractKey(Object value) {
        if (this.mapKeyMapping != null) {
            return this.mapKeyMapping.get(value);
        }
        try {
            Object key = this.type.newCompositeId();
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.mapKeyMappings) {
                pair.getSecond().set(key, pair.getFirst().get(value));
            }
            return key;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void flush(Connection connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
        Object collection = this.get(managedInstance.getInstance());
        if (collection != null) {
            ((ManagedCollection)collection).flush(connection, removals, force);
        }
    }

    public PluralAttributeImpl<? super Z, C, E> getAttribute() {
        return this.attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator<E> getComparator() {
        FinalWrapper<Comparator<E>> wrapper = this.comparator;
        if (wrapper == null) {
            PluralAssociationMappingImpl pluralAssociationMappingImpl = this;
            synchronized (pluralAssociationMappingImpl) {
                if (this.comparator == null) {
                    this.comparator = new FinalWrapper(new ListComparator(this));
                }
                wrapper = this.comparator;
            }
        }
        return (Comparator)wrapper.value;
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public AssociationMappingImpl<?, ?, ?> getInverse() {
        return this.inverse;
    }

    @Override
    public JoinTable getJoinTable() {
        return this.joinTable;
    }

    public SingularMappingEx<? super E, ?> getMapKeyIdMapping() {
        return this.mapKeyMapping;
    }

    public Pair<SingularMapping<?, ?>, AbstractAccessor>[] getMapKeyIdMappings() {
        return this.mapKeyMappings;
    }

    @Override
    public AbstractMapping<?, ?, ?> getMapping(String path) {
        return this.type.getRootMapping().getMapping(path);
    }

    @Override
    public MappingType getMappingType() {
        return MappingType.PLURAL_ASSOCIATION;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public OrderColumn getOrderColumn() {
        if (this.joinTable != null) {
            return this.joinTable.getOrderColumn();
        }
        if (this.foreignKey != null) {
            return this.foreignKey.getOrderColumn();
        }
        return null;
    }

    @Override
    public EntityTypeImpl<E> getType() {
        return this.type;
    }

    @Override
    public void initialize(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, false));
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    @Override
    public boolean isJoined() {
        return this.joinTable != null || this.foreignKey != null;
    }

    @Override
    public boolean isMap() {
        return this.getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP;
    }

    @Override
    public void link() throws MappingException {
        EntityTypeImpl entity = (EntityTypeImpl)this.getRoot().getType();
        this.type = (EntityTypeImpl)this.attribute.getElementType();
        if (!this.isOwner()) {
            this.inverse = (AssociationMappingImpl)this.type.getRootMapping().getMapping(this.getMappedBy());
            if (this.inverse == null) {
                throw new MappingException("Cannot find the mappedBy attribute " + this.getMappedBy() + " specified on " + this.attribute.getJavaMember(), new AbstractLocator[0]);
            }
            this.inverse.setInverse(this);
        } else {
            if (this.joinTable != null) {
                this.joinTable.link(entity, this.type);
                if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.LIST) {
                    String name = this.orderColumn != null && StringUtils.isNotBlank((String)this.orderColumn.getName()) ? this.orderColumn.getName() : this.attribute.getName() + "_ORDER";
                    this.joinTable.setOrderColumn(this.orderColumn, name, this.attribute.getLocator());
                }
            }
            if (this.foreignKey != null) {
                this.foreignKey.link(null, (EntityTypeImpl)this.getRoot().getType());
                this.foreignKey.setTable(this.type.getPrimaryTable());
                if (this.orderColumn != null) {
                    throw new MappingException("Order column is only allowed for join tables", this.orderColumn.getLocator());
                }
            }
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            if (this.mapKeyColumn != null) {
                MapAttributeImpl mapAttribute = (MapAttributeImpl)this.attribute;
                String name = StringUtils.isNotBlank((String)this.mapKeyColumn.getName()) ? this.mapKeyColumn.getName() : this.attribute.getName() + "_KEY";
                this.joinTable.setKeyColumn(this.mapKeyColumn, name, this.mapKeyTemporalType, this.mapKeyEnumType, mapAttribute.getKeyJavaType());
            } else if (StringUtils.isBlank((String)this.mapKey)) {
                if (this.type.hasSingleIdAttribute()) {
                    this.mapKeyMapping = this.type.getIdMapping();
                } else {
                    this.mapKeyMappings = this.type.getIdMappings();
                }
            } else {
                this.mapKeyMapping = (SingularMappingEx)this.type.getRootMapping().getMapping(this.mapKey);
                if (this.mapKeyMapping == null) {
                    throw new MappingException("Cannot locate the MapKey: " + this.mapKey, this.attribute.getLocator());
                }
            }
        }
    }

    @Override
    public void load(ManagedInstance<?> instance) {
        ManagedCollection collection = (ManagedCollection)this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, true);
        collection.initialize();
        this.set(instance.getInstance(), collection);
    }

    @Override
    public Collection<? extends E> loadCollection(ManagedInstance<?> managedInstance) {
        EntityManagerImpl em = managedInstance.getSession().getEntityManager();
        List children = null;
        Object instance = managedInstance.getInstance();
        if (children == null) {
            TypedQuery q = em.createQuery(this.getSelectCriteria());
            q.setParameter(1, instance);
            children = q.getResultList();
        }
        if (this.getInverse() != null && ((PluralAttributeImpl)this.getAttribute()).getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY) {
            Object[] childrenToProcess;
            for (Object child : childrenToProcess = children.toArray(new Object[children.size()])) {
                Object newParent = this.getInverse().get(child);
                if (newParent != null && newParent != managedInstance.getInstance()) {
                    children.remove(child);
                    continue;
                }
                this.getInverse().set(child, instance);
            }
        }
        return children;
    }

    @Override
    public <K> Map<? extends K, ? extends E> loadMap(ManagedInstance<?> managedInstance) {
        Collection<E> children = this.loadCollection(managedInstance);
        HashMap childrenMap = Maps.newHashMap();
        for (E child : children) {
            childrenMap.put(this.extractKey(child), child);
        }
        return childrenMap;
    }

    @Override
    public void mergeWith(EntityManagerImpl entityManager, ManagedInstance<?> instance, Object entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed, LinkedList<ManagedInstance<?>> instances) {
        ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
        Object newCollection = this.get(entity);
        if (newCollection instanceof ManagedCollection && !((ManagedCollection)newCollection).isInitialized()) {
            return;
        }
        if (collection != null && !collection.isInitialized()) {
            collection.initialize();
        }
        collection.mergeWith(entityManager, entity, requiresFlush, processed, instances);
    }

    public void persistAdditions(EntityManagerImpl entityManager, ManagedInstance<?> instance) {
        if (this.cascadesPersist()) {
            ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
            collection.persistAdditions(entityManager);
        }
    }

    @Override
    public boolean references(Object instance, Object reference) {
        Object values = this.get(instance);
        if (values == null) {
            return false;
        }
        if (values instanceof Collection) {
            return ((Collection)values).contains(reference);
        }
        return ((Map)values).containsValue(reference);
    }

    @Override
    public void refresh(ManagedInstance<?> instance, Set<Object> processed) {
        if (this.isEager()) {
            this.initialize(instance);
            ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
            collection.refreshChildren();
            if (this.cascadesRefresh()) {
                EntityManagerImpl entityManager = instance.getSession().getEntityManager();
                if (collection.getDelegate() instanceof List) {
                    List list = (List)collection.getDelegate();
                    for (int i = 0; i < list.size(); ++i) {
                        entityManager.refreshImpl(list.get(i), null, processed);
                    }
                } else {
                    for (Object child : collection.getDelegate()) {
                        entityManager.refreshImpl(child, null, processed);
                    }
                }
            }
            if (this.orderBy != null) {
                this.sortList(instance);
            }
        } else {
            this.setLazy(instance);
        }
    }

    public void removeOrphans(EntityManagerImpl entityManager, ManagedInstance<?> instance) {
        if (this.removesOrphans()) {
            ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
            collection.removeOrphans(entityManager);
        }
    }

    @Override
    public void setInverse(AssociationMappingImpl<?, ?, ?> inverse) {
        this.inverse = inverse;
    }

    @Override
    public void setLazy(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMappingEx<?, C, E>)this, instance, true));
    }

    @Override
    public void sortList(Object instance) {
        ManagedList list = (ManagedList)this.get(instance);
        if (list.isInitialized()) {
            Collections.sort(list.getDelegate(), this.getComparator());
        }
    }
}

