/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.nativequery;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.NotImplementedException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMappingImpl;
import org.batoo.jpa.core.impl.nativequery.NativeParameter;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.parser.metadata.ColumnResultMetadata;
import org.batoo.jpa.parser.metadata.EntityResultMetadata;
import org.batoo.jpa.parser.metadata.FieldResultMetadata;
import org.batoo.jpa.parser.metadata.SqlResultSetMappingMetadata;

public class NativeQuery
implements Query,
ResultSetHandler<List<Object>> {
    private static final BLogger LOG = BLoggerFactory.getLogger(NativeQuery.class);
    private final EntityManagerImpl em;
    private final String query;
    private final Class<?> resultClass;
    private FlushModeType flushMode;
    private int maxResults;
    private int firstResult;
    private final HashMap<Integer, NativeParameter<?>> parameters = Maps.newHashMap();
    private final HashMap<NativeParameter<?>, Object> parameterValues = Maps.newHashMap();
    private final Map<String, Object> hints = Maps.newHashMap();
    private List<?> results;
    final SqlResultSetMappingMetadata sqlResultSetMapping;
    final ArrayList<String> entityList = Lists.newArrayList();
    private final HashMap<Integer, HashMap<String, Object>> fieldMap = Maps.newHashMap();

    public NativeQuery(EntityManagerImpl entityManager, String sqlString) {
        this.em = entityManager;
        this.query = sqlString;
        this.resultClass = null;
        this.sqlResultSetMapping = null;
    }

    public NativeQuery(EntityManagerImpl entityManager, String sqlString, Class<?> resultClass) {
        this.em = entityManager;
        this.query = sqlString;
        this.resultClass = resultClass;
        this.sqlResultSetMapping = null;
    }

    public NativeQuery(EntityManagerImpl entityManager, String sqlString, String resultSetMapping) {
        this.em = entityManager;
        this.query = sqlString;
        this.resultClass = null;
        this.sqlResultSetMapping = this.em.getMetamodel().getSqlResultSetMapping(resultSetMapping);
        if (this.sqlResultSetMapping == null) {
            throw new PersistenceException("SqlResultSetMapping does not exist! : " + resultSetMapping);
        }
        for (EntityResultMetadata entityResultMetadata : this.sqlResultSetMapping.getEntities()) {
            HashMap _fieldModelMap = Maps.newHashMap();
            for (FieldResultMetadata field : entityResultMetadata.getFields()) {
                String[] split = field.getName().contains(".") ? field.getName().split("\\.") : new String[]{field.getName(), "__pk__", "__id__"};
                String attr = split[0];
                String embId = split.length > 2 ? split[split.length - 2] : "__pk__";
                String id = split.length > 1 ? split[split.length - 1] : "__id__";
                _fieldModelMap.put(attr, IdModel.merge((IdModel)_fieldModelMap.get(attr), embId, id, field.getColumn()));
            }
            this.entityList.add(entityResultMetadata.getEntityClass());
            this.fieldMap.put(this.entityList.size() - 1, _fieldModelMap);
        }
    }

    private Object convertTemporal(TemporalType temporalType, Calendar value) {
        switch (temporalType) {
            case DATE: {
                return new Date(value.getTimeInMillis());
            }
            case TIME: {
                return new Time(value.getTimeInMillis());
            }
        }
        return new Timestamp(value.getTimeInMillis());
    }

    private Object convertTemporal(TemporalType temporalType, java.util.Date value) {
        switch (temporalType) {
            case DATE: {
                return new Date(value.getTime());
            }
            case TIME: {
                return new Time(value.getTime());
            }
        }
        return new Timestamp(value.getTime());
    }

    public int executeUpdate() {
        this.em.assertTransaction();
        if (this.flushMode == FlushModeType.AUTO || this.em.getFlushMode() == FlushModeType.AUTO) {
            this.em.flush();
        }
        try {
            if (!this.parameters.isEmpty()) {
                Object[] parameters = new Object[this.parameters.size()];
                for (int i = 0; i < this.parameters.size(); ++i) {
                    parameters[i] = this.getParameterValue(i);
                }
                return new QueryRunner(this.em.getJdbcAdaptor(), false).update(this.query, parameters);
            }
            return new QueryRunner(this.em.getJdbcAdaptor(), false).update(this.query);
        }
        catch (SQLException e) {
            throw new PersistenceException("Native query execution has failed!", (Throwable)e);
        }
    }

    private HashMap<AbstractColumn, String> getAssociatedId(SingularAssociationMappingImpl<?, ?> mapping, HashMap<String, Object> _parentFieldMap) throws SQLException {
        HashMap translatedIdFields = Maps.newHashMap();
        for (JoinColumn joinColumn : mapping.getForeignKey().getJoinColumns()) {
            String name = joinColumn.getReferencedColumn().getMapping().getName();
            Object colnameTemp = _parentFieldMap != null ? _parentFieldMap.get(name) : null;
            String colname = colnameTemp == null ? joinColumn.getName() : colnameTemp.toString();
            translatedIdFields.put(joinColumn.getReferencedColumn(), colname);
        }
        return translatedIdFields;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public Map<String, Object> getHints() {
        return Collections.unmodifiableMap(this.hints);
    }

    private HashMap<AbstractColumn, String> getIdFieldTransformed(HashMap<AbstractColumn, String> idFields, HashMap<String, Object> fieldIdMap) {
        if (fieldIdMap == null) {
            return idFields;
        }
        HashMap idFieldsMod = Maps.newHashMap();
        BiMap inverse = HashBiMap.create(idFields).inverse();
        for (String field : idFields.values()) {
            AbstractColumn column = (AbstractColumn)inverse.get((Object)field);
            String _field = column.getMapping().getName();
            Object colmVal = fieldIdMap.get(_field);
            if (colmVal != null && colmVal.toString() != null) {
                idFieldsMod.put(column, colmVal.toString());
                continue;
            }
            idFieldsMod.put(column, _field);
        }
        return idFieldsMod;
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException("Locking is not supported in native queries");
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public NativeParameter<?> getParameter(int position) {
        return this.parameters.get(position);
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new NotImplementedException("Native queries do not define parameter types. Use getParameter(int)");
    }

    public NativeParameter<?> getParameter(String name) {
        throw new NotImplementedException("Native queries do not support named parameters.");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        throw new NotImplementedException("Native queries do not support named parameters.");
    }

    private NativeParameter<?> getParameter0(int position) {
        if (this.getParameter(position) == null) {
            this.parameters.put(position, new NativeParameter(position));
        }
        return this.parameters.get(position);
    }

    public Set<Parameter<?>> getParameters() {
        HashSet parameters = Sets.newHashSet();
        for (NativeParameter<?> parameter : this.parameters.values()) {
            parameters.add(parameter);
        }
        return parameters;
    }

    public Object getParameterValue(int position) {
        return this.parameterValues.get(this.getParameter(position));
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.parameterValues.get(param);
    }

    public Object getParameterValue(String name) {
        throw new NotImplementedException("Native queries do not support named parameters.");
    }

    public List<?> getResultList() {
        if (this.results != null) {
            return this.results;
        }
        return this.getResultListImpl();
    }

    private List<?> getResultListImpl() {
        this.em.getSession().setLoadTracker();
        try {
            int i2;
            int max = 1;
            for (int i2 : this.parameters.keySet()) {
                max = i2 > max ? i2 : max;
            }
            Object[] paramValues = new Object[max];
            for (i2 = 0; i2 < paramValues.length; ++i2) {
                paramValues[i2] = Void.TYPE;
            }
            for (i2 = 0; i2 < paramValues.length; ++i2) {
                if (this.getParameter(i2 + 1) == null) continue;
                paramValues[i2] = this.getParameterValue(i2 + 1);
            }
            try {
                this.results = new QueryRunner(this.em.getJdbcAdaptor(), false).query(this.em.getConnection(), this.query, this, paramValues);
                List<Object> i3 = this.results;
                return i3;
            }
            catch (SQLException e) {
                throw new PersistenceException("Native query execution failed!", (Throwable)e);
            }
        }
        finally {
            this.em.getSession().releaseLoadTracker();
        }
    }

    public Object getSingleResult() {
        List<?> resultList = this.getResultList();
        if (resultList.size() > 1) {
            throw new NonUniqueResultException();
        }
        if (resultList.size() == 0) {
            throw new NoResultException();
        }
        return resultList.get(0);
    }

    public List<Object> handle(ResultSet resultSet) throws SQLException {
        if (this.sqlResultSetMapping != null) {
            return this.handleWithSqlResultSetMapping(resultSet);
        }
        if (this.resultClass != null) {
            return this.handleWithResultClass(resultSet);
        }
        return this.handleAsScalar(resultSet);
    }

    private List<Object> handleAsScalar(ResultSet resultSet) throws SQLException {
        ArrayList results = Lists.newArrayList();
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            if (columnCount == 1) {
                results.add(resultSet.getObject(1));
                continue;
            }
            Object[] result = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                result[i] = resultSet.getObject(i + 1);
            }
            results.add(result);
        }
        return results;
    }

    private ManagedInstance<?> handleInstance(ResultSet row, EntityTypeImpl<?> entityType, String discriminatorColumn, HashMap<String, Object> fieldMap) throws SQLException {
        SessionImpl session = this.em.getSession();
        ManagedId<?> managedId = entityType.getId(session, row, this.getIdFieldTransformed(entityType.getPrimaryTable().getIdFields(), fieldMap));
        if (managedId == null) {
            return null;
        }
        ManagedInstance<ManagedId<?>> instance = session.get(managedId);
        if (instance != null) {
            if (!(instance.getInstance() instanceof EnhancedInstance)) {
                return instance;
            }
            EnhancedInstance enhancedInstance = (EnhancedInstance)((Object)instance.getInstance());
            if (!enhancedInstance.__enhanced__$$__isInitialized()) {
                this.initializeInstance(session, row, instance, entityType, fieldMap);
                session.lazyInstanceLoading(instance);
                enhancedInstance.__enhanced__$$__setInitialized();
            }
            return instance;
        }
        if (entityType.getInheritanceType() == null) {
            instance = entityType.getManagedInstanceById(session, managedId, false);
        } else {
            String discriminatorValue = row.getObject(discriminatorColumn = discriminatorColumn == null ? entityType.getDiscriminatorColumn().getName() : discriminatorColumn).toString();
            EntityTypeImpl<?> effectiveType = entityType.getChildType(discriminatorValue);
            if (effectiveType == null) {
                throw new IllegalArgumentException("Discriminator " + discriminatorValue + " not found in the type " + entityType.getName());
            }
            instance = effectiveType.getManagedInstanceById(session, managedId, false);
        }
        this.initializeInstance(session, row, instance, entityType, fieldMap);
        session.put(instance);
        return instance;
    }

    private List<Object> handleWithResultClass(ResultSet resultSet) throws SQLException {
        ArrayList result = Lists.newArrayList();
        EntityType entityType = this.em.getMetamodel().entity(this.resultClass);
        if (entityType == null) {
            throw new PersistenceException("Entity Class is not managed :" + this.resultClass);
        }
        while (resultSet.next()) {
            ManagedInstance<?> managedInstance = this.handleInstance(resultSet, (EntityTypeImpl<?>)entityType, null, null);
            if (managedInstance != null) {
                result.add(managedInstance.getInstance());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private List<Object> handleWithSqlResultSetMapping(ResultSet resultSet) throws SQLException {
        ArrayList result = Lists.newArrayList();
        List<EntityResultMetadata> entities = this.sqlResultSetMapping.getEntities();
        while (resultSet.next()) {
            ArrayList resultRow = Lists.newArrayList();
            for (int i = 0; i < entities.size(); ++i) {
                EntityResultMetadata entityResultMetadata = entities.get(i);
                EntityTypeImpl entityType = this.em.getMetamodel().entity(entityResultMetadata.getEntityClass());
                if (entityType == null) {
                    throw new PersistenceException("Entity Class is not managed :" + entityResultMetadata.getEntityClass());
                }
                HashMap<String, Object> _fieldMap = this.fieldMap.get(i);
                ManagedInstance<?> managedInstance = this.handleInstance(resultSet, entityType, entityResultMetadata.getDiscriminatorColumn(), _fieldMap);
                if (managedInstance != null) {
                    resultRow.add(managedInstance.getInstance());
                    continue;
                }
                resultRow.add(null);
            }
            for (ColumnResultMetadata columnResultMetadata : this.sqlResultSetMapping.getColumns()) {
                resultRow.add(resultSet.getObject(columnResultMetadata.getName()));
            }
            if (resultRow.size() > 1) {
                result.add(resultRow.toArray());
                continue;
            }
            result.add(resultRow.get(0));
        }
        return result;
    }

    private void initializeInstance(SessionImpl session, ResultSet row, ManagedInstance<?> managedInstance, EntityTypeImpl<?> entityType, HashMap<String, Object> fieldMap) throws SQLException {
        managedInstance.setLoading(true);
        Object instance = managedInstance.getInstance();
        for (AbstractMapping<?, ?, ?> mapping : entityType.getMappingsSingular()) {
            Object reference;
            IdModel idModel;
            if (mapping instanceof BasicMappingImpl) {
                BasicMappingImpl basicMapping = (BasicMappingImpl)mapping;
                BasicColumn column = basicMapping.getColumn();
                String colName = fieldMap != null && fieldMap.get(basicMapping.getName()) != null ? fieldMap.get(basicMapping.getName()).toString() : column.getName();
                column.setValue(instance, row.getObject(colName));
            }
            if (!(mapping instanceof SingularAssociationMappingImpl)) continue;
            SingularAssociationMappingImpl saMapping = (SingularAssociationMappingImpl)mapping;
            HashMap<String, Object> _parentFieldMap = fieldMap;
            if (fieldMap != null && fieldMap.get(saMapping.getName()) instanceof IdModel && (idModel = (IdModel)fieldMap.get(saMapping.getName())).getIdMap().size() > 1) {
                _parentFieldMap = idModel.getIdMap();
            }
            for (JoinColumn joinColumn : saMapping.getForeignKey().getJoinColumns()) {
                String name = joinColumn.getReferencedColumn().getMapping().getName();
                Object colnameTemp = _parentFieldMap != null ? _parentFieldMap.get(name) : null;
                String colname = colnameTemp == null ? joinColumn.getName() : colnameTemp.toString();
                try {
                    Object _id = row.getObject(colname);
                    if (_id == null) continue;
                    joinColumn.setValue(instance, _id);
                }
                catch (SQLException e) {
                    LOG.debug("column not found with name: {0}", colname);
                }
            }
            TypeImpl _childType = saMapping.getType();
            HashMap<AbstractColumn, String> translatedIdFields = this.getAssociatedId(saMapping, _parentFieldMap);
            ManagedId managedId = ((EntityTypeImpl)saMapping.getType()).getId(session, row, translatedIdFields);
            if (managedId == null || managedId.getId() == null || (reference = session.getEntityManager().getReference(_childType.getJavaType(), managedId.getId())) == null) continue;
            saMapping.set(instance, reference);
            managedInstance.setJoinLoaded(saMapping);
        }
    }

    public boolean isBound(Parameter<?> param) {
        return this.getParameterValue(param) != null;
    }

    public NativeQuery setFirstResult(int startPosition) {
        this.firstResult = startPosition;
        return this;
    }

    public NativeQuery setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public NativeQuery setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        return this;
    }

    public NativeQuery setLockMode(LockModeType lockMode) {
        throw new UnsupportedOperationException("Locking is not supported in native queries");
    }

    public NativeQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public NativeQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.parameterValues.put(this.getParameter0(position), this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(int position, java.util.Date value, TemporalType temporalType) {
        this.parameterValues.put(this.getParameter0(position), this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(int position, Object value) {
        NativeParameter<?> parameter0 = this.getParameter0(position);
        this.parameterValues.put(parameter0, value);
        return this;
    }

    public NativeQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.parameterValues.put(this.getParameter0(param.getPosition()), this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(Parameter<java.util.Date> param, java.util.Date value, TemporalType temporalType) {
        this.parameterValues.put(this.getParameter0(param.getPosition()), this.convertTemporal(temporalType, value));
        return this;
    }

    public <T> NativeQuery setParameter(Parameter<T> param, T value) {
        this.parameterValues.put(this.getParameter0(param.getPosition()), value);
        return this;
    }

    public NativeQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        throw new NotImplementedException("Native queries do not support named parameters.");
    }

    public NativeQuery setParameter(String name, java.util.Date value, TemporalType temporalType) {
        throw new NotImplementedException("Native queries do not support named parameters.");
    }

    public NativeQuery setParameter(String name, Object value) {
        throw new NotImplementedException("Native queries do not support named parameters.");
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }

    private static class IdModel {
        public static final String DEFAULT_EMBEDDED_ID = "__pk__";
        public static final String DEFAULT_ID = "__id__";
        HashMap<String, Object> idMap = Maps.newHashMap();
        String embeddedId;

        public static IdModel merge(IdModel idModel, String embeddedId, String id, String column) {
            idModel = idModel != null ? idModel : new IdModel();
            idModel.merge(embeddedId, id, column);
            return idModel;
        }

        private IdModel() {
        }

        public String getEmbeddedId() {
            return this.embeddedId;
        }

        public HashMap<String, Object> getIdMap() {
            return this.idMap;
        }

        private void merge(String embeddedId, String id, String column) {
            this.embeddedId = embeddedId;
            this.idMap.put(id, column);
        }

        public String toString() {
            if (this.idMap.size() == 1) {
                return this.idMap.values().iterator().next().toString();
            }
            return null;
        }
    }
}

