/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.Column;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.ValueConverter;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;

public abstract class AbstractColumn
implements Column {
    private final Class<?> javaType;
    private IdType idType;
    private final TemporalType temporalType;
    private final EnumType enumType;
    private final boolean lob;
    private final AbstractLocator locator;
    private final Enum<?>[] values;
    private final Method method;

    public AbstractColumn(AbstractLocator locator, boolean id) {
        this.javaType = null;
        this.idType = id ? IdType.MANUAL : null;
        this.locator = locator;
        this.temporalType = null;
        this.enumType = null;
        this.lob = false;
        this.values = null;
        this.method = null;
    }

    public AbstractColumn(Class<?> javaType, IdType idType, TemporalType temporalType, EnumType enumType, boolean lob, AbstractLocator locator) {
        this.javaType = javaType;
        this.idType = idType;
        this.temporalType = temporalType;
        this.enumType = enumType;
        this.lob = lob;
        this.locator = locator;
        if (this.enumType != null) {
            Class<?> enumJavaType = javaType;
            try {
                if (this.enumType == EnumType.ORDINAL) {
                    this.values = (Enum[])enumJavaType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    this.method = null;
                }
                this.values = null;
                this.method = enumJavaType.getMethod("valueOf", String.class);
            }
            catch (Exception e) {
                throw new MappingException("Unable to map enum type", this.locator);
            }
        } else {
            this.values = null;
            this.method = null;
        }
    }

    @Override
    public Object convertValue(Connection connection, Object value) {
        return ValueConverter.toJdbc(value, this.javaType, this.temporalType, this.enumType, this.lob);
    }

    public Object convertValueForSet(Object value) {
        return ValueConverter.fromJdbc(value, this.javaType, this.temporalType, this.enumType, this.values, this.method, this.lob);
    }

    @Override
    public abstract String getColumnDefinition();

    @Override
    public IdType getIdType() {
        return this.idType;
    }

    @Override
    public abstract int getLength();

    @Override
    public final AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public abstract Mapping<?, ?, ?> getMapping();

    @Override
    public abstract String getName();

    @Override
    public abstract int getPrecision();

    @Override
    public abstract int getScale();

    @Override
    public abstract int getSqlType();

    @Override
    public abstract AbstractTable getTable();

    @Override
    public abstract String getTableName();

    @Override
    public abstract Object getValue(Connection var1, Object var2);

    @Override
    public abstract boolean isInsertable();

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public abstract boolean isNullable();

    @Override
    public boolean isPrimaryKey() {
        return this.idType != null;
    }

    @Override
    public abstract boolean isUnique();

    @Override
    public abstract boolean isUpdatable();

    public boolean isVersion() {
        return false;
    }

    @Override
    public void setId() {
        this.idType = IdType.MANUAL;
    }

    @Override
    public abstract void setTable(AbstractTable var1);

    @Override
    public abstract void setValue(Object var1, Object var2);

    public String toString() {
        String tableName = this.getTable() != null ? this.getTable().getName() : "N/A";
        String mapping = this.getMapping() != null ? " " + this.getMapping().toString() + " " : "";
        return this.getClass().getSimpleName() + mapping + " [name=" + this.getName() + ", type=" + this.getSqlType() + ", length=" + this.getLength() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", table=" + tableName + "]";
    }
}

