/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.jdbc.AbstractDataSource;
import org.batoo.jpa.jdbc.ConnectionProxy;
import org.batoo.jpa.jdbc.PreparedStatementProxy;

public class DataSourceProxy
implements DataSource {
    private static final BLogger LOG = BLoggerFactory.getLogger(DataSourceProxy.class);
    private final DataSource datasource;
    private final boolean external;
    private final PreparedStatementProxy.SqlLoggingType sqlLogging;
    private final long slowSqlThreshold;
    private final int jdbcFetchSize;
    private final boolean externalPoolDS;

    public DataSourceProxy(AbstractDataSource datasource, boolean external, PreparedStatementProxy.SqlLoggingType sqlLogging, long slowSqlThreshold, int jdbcFetchSize) {
        this.datasource = datasource;
        this.external = external;
        this.sqlLogging = sqlLogging;
        this.slowSqlThreshold = slowSqlThreshold;
        this.jdbcFetchSize = jdbcFetchSize;
        this.externalPoolDS = true;
    }

    public DataSourceProxy(DataSource datasource, boolean external, PreparedStatementProxy.SqlLoggingType sqlLogging, long slowSqlThreshold, int jdbcFetchSize) {
        this.datasource = datasource;
        this.external = external;
        this.sqlLogging = sqlLogging;
        this.slowSqlThreshold = slowSqlThreshold;
        this.jdbcFetchSize = jdbcFetchSize;
        this.externalPoolDS = false;
    }

    public void close() {
        if (!this.external && !this.externalPoolDS) {
            try {
                Method closeMethod = this.datasource.getClass().getMethod("close", new Class[0]);
                if (closeMethod != null) {
                    closeMethod.invoke((Object)this.datasource, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.error(e, "Cannot close() the internal datasource");
            }
        } else if (this.externalPoolDS) {
            ((AbstractDataSource)this.datasource).close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new ConnectionProxy(this.datasource.getConnection(), this.slowSqlThreshold, this.sqlLogging, this.jdbcFetchSize);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("not supported");
    }

    public DataSource getDelegate() {
        return this.datasource;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.datasource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.datasource.getLogWriter();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.datasource.getParentLogger();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.datasource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.datasource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.datasource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.datasource.unwrap(iface);
    }
}

