/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.EnumType;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.apache.commons.io.IOUtils;
import org.batoo.common.reflect.ReflectHelper;

public class ValueConverter {
    public static Object fromJdbc(Object value, Class<?> javaType, TemporalType temporalType, EnumType enumType, Enum<?>[] values, Method method, boolean lob) {
        if (value == null) {
            return null;
        }
        if (temporalType != null && javaType == Calendar.class) {
            Calendar calendarValue = Calendar.getInstance();
            switch (temporalType) {
                case DATE: {
                    if (value instanceof Date) {
                        calendarValue.setTime((Date)value);
                        return calendarValue;
                    }
                }
                case TIME: {
                    if (value instanceof Time) {
                        calendarValue.setTime((Time)value);
                        return calendarValue;
                    }
                }
                case TIMESTAMP: {
                    if (!(value instanceof Timestamp)) break;
                    calendarValue.setTime((Timestamp)value);
                    return calendarValue;
                }
            }
        }
        if (enumType != null) {
            try {
                Class<?> enumJavaType = javaType;
                if (enumType == EnumType.ORDINAL && values == null) {
                    values = (Enum[])enumJavaType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                } else if (enumType == EnumType.STRING && method == null) {
                    method = enumJavaType.getMethod("valueOf", String.class);
                }
                value = enumType == EnumType.ORDINAL ? values[((Number)value).shortValue()] : method.invoke(null, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (lob) {
            value = ValueConverter.readLob(value, javaType);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object readLob(Object value, Class<?> javaType) {
        try {
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                if (javaType == String.class) {
                    StringWriter w = new StringWriter();
                    IOUtils.copy((InputStream)clob.getAsciiStream(), (Writer)w);
                    return w.toString();
                }
                CharArrayWriter w = new CharArrayWriter((int)clob.length());
                IOUtils.copy((Reader)clob.getCharacterStream(), (Writer)w);
                return w.toCharArray();
            }
            if (value instanceof byte[]) {
                if (javaType == String.class) {
                    StringWriter w = new StringWriter();
                    IOUtils.copy((InputStream)new ByteArrayInputStream((byte[])value), (Writer)w);
                    return w.toString();
                }
                if (javaType == char[].class) {
                    byte[] byteArray = (byte[])value;
                    char[] charArray = new char[byteArray.length];
                    int i = 0;
                    while (true) {
                        if (i >= charArray.length) {
                            return charArray;
                        }
                        charArray[i] = (char)byteArray[i];
                        ++i;
                    }
                }
                if (javaType == byte[].class) return value;
                ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream((byte[])value));
                try {
                    Object charArray = is.readObject();
                    return charArray;
                }
                finally {
                    is.close();
                }
            }
            if (value instanceof String) {
                return value;
            }
            Blob blob = (Blob)value;
            if (javaType == byte[].class) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)blob.getBinaryStream(), (OutputStream)os);
                return os.toByteArray();
            }
            ObjectInputStream is = new ObjectInputStream(blob.getBinaryStream());
            try {
                value = is.readObject();
                return value;
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot read sql data", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toJdbc(Object value, Class<?> javaType, TemporalType temporalType, EnumType enumType, boolean lob) {
        if (value == null) {
            return null;
        }
        if (temporalType != null) {
            switch (temporalType) {
                case DATE: {
                    if (value instanceof Date) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Date(((java.util.Date)value).getTime());
                    }
                    return new Date(((Calendar)value).getTimeInMillis());
                }
                case TIME: {
                    if (value instanceof Time) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Time(((java.util.Date)value).getTime());
                    }
                    return new Time(((Calendar)value).getTimeInMillis());
                }
                case TIMESTAMP: {
                    if (value instanceof Timestamp) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Timestamp(((java.util.Date)value).getTime());
                    }
                    return new Timestamp(((Calendar)value).getTimeInMillis());
                }
            }
        }
        if (Number.class.isAssignableFrom(javaType)) {
            return ReflectHelper.convertNumber((Number)value, javaType);
        }
        if (enumType != null) {
            Enum enumValue = (Enum)value;
            if (enumType == EnumType.ORDINAL) {
                return enumValue.ordinal();
            }
            return enumValue.name();
        }
        if (lob) {
            try {
                if (javaType == String.class) {
                    return new SerialClob(((String)value).toCharArray());
                }
                if (javaType == char[].class) {
                    return new SerialClob((char[])value);
                }
                if (javaType == byte[].class) {
                    return new SerialBlob((byte[])value);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                try {
                    oos.writeObject(value);
                }
                finally {
                    oos.close();
                }
                return new SerialBlob(os.toByteArray());
            }
            catch (Exception e) {
                throw new PersistenceException("Cannot set parameter", (Throwable)e);
            }
        }
        return value;
    }
}

