/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.acl;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.parser.impl.acl.ClassloaderAnnotatedClassLocator;
import org.batoo.jpa.parser.impl.acl.JBoss7AnnotatedClassLocator;
import org.batoo.jpa.parser.impl.acl.JarAnnotatedClassLocator;
import org.batoo.jpa.spi.AnnotatedClassLocator;

public abstract class BaseAnnotatedClassLocator
implements AnnotatedClassLocator {
    private static final BLogger LOG = BLoggerFactory.getLogger(BaseAnnotatedClassLocator.class);

    private static void locateClasses(PersistenceUnitInfo puInfo, Set<Class<?>> classes, URL jarUrl) {
        AnnotatedClassLocator locator = null;
        if (jarUrl.getProtocol().equals("file")) {
            String path = jarUrl.getPath();
            File file = new File(path);
            locator = file.isDirectory() ? ClassloaderAnnotatedClassLocator.getInstance() : JarAnnotatedClassLocator.getInstance();
        } else if (jarUrl.getProtocol().equals("vfs")) {
            locator = JBoss7AnnotatedClassLocator.getInstance();
        } else {
            throw new IllegalArgumentException("Unknown jar url protocol: " + jarUrl);
        }
        classes.addAll(locator.locateClasses(puInfo, jarUrl));
    }

    public static Set<Class<?>> locatePersistentClasses(PersistenceUnitInfo puInfo) {
        ClassLoader classLoader = puInfo.getClassLoader();
        List jarFiles = puInfo.getJarFileUrls();
        List managedClassNames = puInfo.getManagedClassNames();
        boolean excludeUnlistedClasses = puInfo.excludeUnlistedClasses();
        HashSet classes = Sets.newHashSet();
        if (jarFiles != null && !jarFiles.isEmpty()) {
            for (URL jarUrl : jarFiles) {
                BaseAnnotatedClassLocator.locateClasses(puInfo, classes, jarUrl);
            }
        }
        for (String className : managedClassNames) {
            try {
                classes.add(classLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException("Unable to load listed persistent class " + className, (Throwable)e);
            }
        }
        if (!excludeUnlistedClasses) {
            BaseAnnotatedClassLocator.locateClasses(puInfo, classes, puInfo.getPersistenceUnitRootUrl());
        }
        return classes;
    }

    protected BaseAnnotatedClassLocator() {
    }

    protected Class<?> isPersistentClass(ClassLoader classloader, String className) {
        block3: {
            try {
                Class<?> clazz = classloader.loadClass(className);
                if (clazz.getAnnotation(Embeddable.class) != null || clazz.getAnnotation(MappedSuperclass.class) != null || clazz.getAnnotation(Entity.class) != null) {
                    return clazz;
                }
            }
            catch (Throwable e) {
                if (className.startsWith("org.eclipse.jdt")) break block3;
                LOG.debug(e, "Unable to read class: {0}" + className);
            }
        }
        return null;
    }
}

