/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.common.reflect;

import java.lang.reflect.Method;
import org.batoo.common.BatooException;
import org.batoo.common.reflect.AbstractAccessor;
import org.batoo.common.reflect.InternalInstance;
import org.batoo.common.reflect.PropertyDescriptor;

public class PropertyAccessor
extends AbstractAccessor {
    private final String name;
    private final Method reader;
    private final Method writer;

    public PropertyAccessor(PropertyDescriptor descriptor) {
        this.name = descriptor.getName();
        this.reader = descriptor.getReader();
        this.writer = descriptor.getWriter();
        this.reader.setAccessible(true);
        this.writer.setAccessible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object get(Object instance) {
        if (!(instance instanceof InternalInstance)) return this.reader.invoke(instance, new Object[0]);
        InternalInstance enhancedInstance = (InternalInstance)instance;
        enhancedInstance.__enhanced__$$__setInternalCall(true);
        try {
            Object object = this.reader.invoke(instance, new Object[0]);
            enhancedInstance.__enhanced__$$__setInternalCall(true);
            return object;
        }
        catch (Throwable throwable) {
            try {
                enhancedInstance.__enhanced__$$__setInternalCall(true);
                throw throwable;
            }
            catch (Exception e) {
                throw new BatooException("Cannot get field value: " + this.name, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Object instance, Object value) {
        block6: {
            try {
                if (instance instanceof InternalInstance) {
                    InternalInstance enhancedInstance = (InternalInstance)instance;
                    enhancedInstance.__enhanced__$$__setInternalCall(true);
                    try {
                        this.writer.invoke(instance, value);
                        break block6;
                    }
                    finally {
                        enhancedInstance.__enhanced__$$__setInternalCall(true);
                    }
                }
                this.writer.invoke(instance, value);
            }
            catch (Exception e) {
                throw new BatooException("Cannot set field value: " + this.name, e);
            }
        }
    }
}

