/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.criteria.BaseQuery;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractParameterExpressionImpl;
import org.batoo.jpa.core.impl.criteria.expression.EntityConstantExpression;
import org.batoo.jpa.core.impl.criteria.expression.ParameterExpressionImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.jdbc.PreparedStatementProxy;
import org.batoo.jpa.jdbc.ValueConverter;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;

public class QueryImpl<X>
implements TypedQuery<X>,
Query {
    private static final int MAX_COL_LENGTH = 30;
    private static final BLogger LOG = BLoggerFactory.getLogger(QueryImpl.class);
    private final EntityManagerImpl em;
    private final BaseQuery<X> q;
    private String sql;
    private final Map<String, Object> hints = Maps.newHashMap();
    private int startPosition = 0;
    private int maxResult = Integer.MAX_VALUE;
    private final Map<ParameterExpressionImpl<?>, Object> parameters = Maps.newHashMap();
    private List<X> results;
    private LockModeType lockMode;
    private final List<Object[]> data = Lists.newArrayList();
    private ResultSetMetaData md;
    private String[] labels;
    private FlushModeType flushMode = FlushModeType.AUTO;
    private boolean pmdBroken;

    public QueryImpl(BaseQuery<X> q, EntityManagerImpl entityManager) {
        this.em = entityManager;
        this.q = q;
        this.sql = this.q.getSql();
        for (ParameterExpression<?> p : this.q.getParameters()) {
            this.parameters.put((ParameterExpressionImpl)p, Void.TYPE);
        }
        this.pmdBroken = entityManager.getJdbcAdaptor().isPmdBroken();
    }

    private Object[] applyParameters(Connection connection) {
        for (ParameterExpressionImpl<?> param : this.parameters.keySet()) {
            if (this.parameters.get(param) != Void.TYPE) continue;
            throw new IllegalArgumentException("Parameter not set: " + param.getPosition());
        }
        if (this.startPosition != 0 || this.maxResult != Integer.MAX_VALUE) {
            LOG.debug("Rows restricted to {0} / {1}", this.startPosition, this.maxResult);
            this.sql = this.q.getMetamodel().getJdbcAdaptor().applyPagination(this.sql, this.startPosition, this.maxResult);
        }
        MetamodelImpl metamodel = this.em.getMetamodel();
        List<AbstractParameterExpressionImpl<?>> sqlParameters = this.q.getSqlParameters();
        int paramCount = 0;
        for (int i = 0; i < sqlParameters.size(); ++i) {
            paramCount += sqlParameters.get(i).getExpandedCount(metamodel);
        }
        if (this.q.getMetamodel().getJdbcAdaptor().parameterizedPagination() && (this.maxResult != Integer.MAX_VALUE || this.startPosition != 0)) {
            JdbcAdaptor.PaginationParamsOrder paginationParamsOrder = this.q.getJdbcAdaptor().getPaginationParamsOrder();
            boolean paginationHasStart = this.startPosition != 0 || this.q.getJdbcAdaptor().paginationNeedsStartAlways();
            boolean paginationHasMaxResults = this.maxResult != Integer.MAX_VALUE || this.q.getJdbcAdaptor().paginationNeedsMaxResultsAlways();
            int n = paginationHasMaxResults && paginationHasStart ? 2 : 1;
            MutableInt sqlIndex = new MutableInt(0);
            Object[] parameters = new Object[paramCount += n];
            if (!paginationParamsOrder.isAfterMainSql()) {
                if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.MAX_START_SQL) {
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                } else {
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                }
            }
            for (int i = 0; i < sqlParameters.size(); ++i) {
                AbstractParameterExpressionImpl<?> parameter = sqlParameters.get(i);
                if (parameter instanceof EntityConstantExpression) {
                    ((EntityConstantExpression)parameter).setParameter(metamodel, connection, parameters, sqlIndex);
                    continue;
                }
                ((ParameterExpressionImpl)parameter).setParameter(metamodel, connection, parameters, sqlIndex, this.parameters.get(parameter));
            }
            if (paginationParamsOrder.isAfterMainSql()) {
                if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.SQL_START_MAX) {
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                } else if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.SQL_START_END) {
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = (long)this.startPosition + (long)this.maxResult;
                        sqlIndex.increment();
                    }
                } else if (paginationParamsOrder == JdbcAdaptor.PaginationParamsOrder.SQL_END_START) {
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = (long)this.startPosition + (long)this.maxResult;
                        sqlIndex.increment();
                    }
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                } else {
                    if (paginationHasMaxResults) {
                        parameters[sqlIndex.intValue()] = this.maxResult;
                        sqlIndex.increment();
                    }
                    if (paginationHasStart) {
                        parameters[sqlIndex.intValue()] = this.startPosition;
                        sqlIndex.increment();
                    }
                }
            }
            return parameters;
        }
        MutableInt sqlIndex = new MutableInt(0);
        Object[] parameters = new Object[paramCount];
        for (int i = 0; i < sqlParameters.size(); ++i) {
            AbstractParameterExpressionImpl<?> parameter = sqlParameters.get(i);
            if (parameter instanceof EntityConstantExpression) {
                ((EntityConstantExpression)parameter).setParameter(metamodel, connection, parameters, sqlIndex);
                continue;
            }
            ((ParameterExpressionImpl)parameter).setParameter(metamodel, connection, parameters, sqlIndex, this.parameters.get(parameter));
        }
        return parameters;
    }

    private List<X> buildResultSet(Connection connection, Object[] parameters) {
        try {
            this.buildResultSetImpl(connection, parameters);
            return this.results;
        }
        catch (SQLException e) {
            LOG.error(e, "Query failed{0}{1}", LOG.lazyBoxed(this.getJpql(), this.parameters.entrySet().toArray()), LOG.lazyBoxed(this.sql, parameters));
            this.em.setRollbackOnly();
            throw new PersistenceException("Query failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResultSetImpl(Connection connection, Object[] parameters) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            String _sql = this.sql;
            HashMap repeat = Maps.newHashMap();
            int sqlParamNo = 0;
            for (Object parameter : parameters) {
                if (parameter != null) {
                    if (parameter instanceof Collection) {
                        repeat.put(sqlParamNo, ((Collection)parameter).size());
                    } else if (parameter.getClass().isArray()) {
                        repeat.put(sqlParamNo, ((Object[])parameter).length);
                    }
                }
                ++sqlParamNo;
            }
            statement = repeat.size() > 0 ? connection.prepareStatement(this.expandParams(_sql, repeat)) : connection.prepareStatement(_sql);
            this.fillStatement(statement, parameters, repeat);
            resultSet = statement.executeQuery();
            this.handle(resultSet);
        }
        catch (Throwable throwable) {
            try {
                DbUtils.close(resultSet);
            }
            finally {
                DbUtils.close(statement);
            }
            throw throwable;
        }
        try {
            DbUtils.close((ResultSet)resultSet);
        }
        finally {
            DbUtils.close((Statement)statement);
        }
    }

    private void dumpResultSet() throws SQLException {
        int i;
        int[] lengths = new int[this.labels.length];
        for (int i2 = 0; i2 < lengths.length; ++i2) {
            lengths[i2] = this.max(lengths[i2], StringUtils.length((String)this.labels[i2]));
        }
        for (Object[] data : this.data) {
            for (i = 0; i < this.labels.length; ++i) {
                Object value = data[i];
                if (value == null) continue;
                lengths[i] = this.max(lengths[i], StringUtils.length((String)value.toString()));
            }
        }
        int length = 1;
        for (int l : lengths) {
            length += l + 3;
        }
        StringBuffer dump = new StringBuffer("Query returned {0} row(s):\n");
        dump.append(StringUtils.repeat((String)"-", (int)length));
        dump.append("\n| ");
        for (i = 0; i < this.labels.length; ++i) {
            String strValue = StringUtils.abbreviate((String)this.labels[i], (int)lengths[i]);
            strValue = StringUtils.rightPad((String)strValue, (int)lengths[i]);
            dump.append(strValue);
            dump.append(" | ");
        }
        dump.append("\n");
        dump.append(StringUtils.repeat((String)"-", (int)length));
        for (Object[] data : this.data) {
            dump.append("\n| ");
            for (int i3 = 0; i3 < this.labels.length; ++i3) {
                Object value = data[i3];
                String strValue = value != null ? value.toString() : "!NULL!";
                strValue = StringUtils.abbreviate((String)strValue, (int)lengths[i3]);
                strValue = value instanceof Number ? StringUtils.leftPad((String)strValue, (int)lengths[i3]) : StringUtils.rightPad((String)strValue, (int)lengths[i3]);
                dump.append(strValue);
                dump.append(" | ");
            }
        }
        dump.append("\n");
        dump.append(StringUtils.repeat((String)"-", (int)length));
        LOG.debug(dump.toString(), this.data.size());
    }

    public int executeUpdate() {
        if (!this.q.isInternal() && this.em.hasActiveTransaction() && (this.flushMode == FlushModeType.AUTO || this.em.getFlushMode() == FlushModeType.AUTO)) {
            this.em.flush();
        }
        Connection connection = this.em.getConnection();
        Object[] parameters = this.applyParameters(connection);
        try {
            this.em.assertTransaction();
            return new QueryRunner(this.em.getJdbcAdaptor(), false).update(connection, this.sql, parameters);
        }
        catch (SQLException e) {
            LOG.error(e, "Query failed" + LOG.lazyBoxed(this.sql, parameters));
            this.em.setRollbackOnly();
            throw new PersistenceException("Query failed", (Throwable)e);
        }
    }

    private String expandParams(String _sql, Map<Integer, Integer> repeat) {
        StringBuffer outSql = new StringBuffer();
        int sqlIndex = 0;
        boolean inQuot = false;
        for (int i = 0; i < _sql.length(); ++i) {
            char current = _sql.charAt(i);
            if (current == '\'') {
                if (inQuot) {
                    inQuot = !inQuot;
                }
                outSql.append('\'');
                continue;
            }
            if (!inQuot && current == '?') {
                Integer repeatCount = repeat.get(sqlIndex);
                if (repeatCount != null) {
                    int left = repeatCount;
                    outSql.append('?');
                    --left;
                    while (left > 0) {
                        outSql.append(", ?");
                        --left;
                    }
                    sqlIndex += repeatCount.intValue();
                    continue;
                }
                ++sqlIndex;
                outSql.append('?');
                continue;
            }
            outSql.append(current);
        }
        return outSql.toString();
    }

    private void fillStatement(PreparedStatement statement, Object[] parameters, Map<Integer, Integer> repeat) throws SQLException {
        ParameterMetaData pmd;
        if (parameters == null || parameters.length == 0) {
            return;
        }
        ParameterMetaData parameterMetaData = pmd = this.pmdBroken ? null : statement.getParameterMetaData();
        if (this.pmdBroken) {
            int total = parameters.length - repeat.size();
            if (repeat.size() > 0) {
                for (Integer repeatSize : repeat.values()) {
                    if (repeatSize == null) continue;
                    total += repeatSize.intValue();
                }
            }
            ((PreparedStatementProxy)statement).setParamCount(total);
        }
        int index = 1;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != null) {
                if (repeat.containsKey(i)) {
                    Object[] array;
                    Object paramValue = parameters[i];
                    if (paramValue instanceof Collection) {
                        Collection collection = (Collection)paramValue;
                        for (Object subParamValue : collection) {
                            statement.setObject(index++, subParamValue);
                        }
                        continue;
                    }
                    for (Object subParamValue : array = (Object[])paramValue) {
                        statement.setObject(index++, subParamValue);
                    }
                    continue;
                }
                statement.setObject(index++, parameters[i]);
                continue;
            }
            int sqlType = 12;
            if (!this.pmdBroken) {
                try {
                    sqlType = pmd.getParameterType(index + 1);
                }
                catch (SQLException e) {
                    this.pmdBroken = true;
                }
            }
            statement.setNull(index++, sqlType);
        }
    }

    public BaseQuery<X> getCriteriaQuery() {
        return this.q;
    }

    public int getFirstResult() {
        return this.startPosition;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public Map<String, Object> getHints() {
        return Maps.newHashMap(this.hints);
    }

    public String getJpql() {
        return this.q.getJpql();
    }

    public LockModeType getLockMode() {
        return this.lockMode;
    }

    public int getMaxResults() {
        return this.maxResult;
    }

    public ParameterExpressionImpl<?> getParameter(int position) {
        for (Map.Entry<ParameterExpressionImpl<?>, Object> entry : this.parameters.entrySet()) {
            if (!Integer.valueOf(position).equals(entry.getKey().getPosition())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Query does not have parameter number " + position);
    }

    public <T> ParameterExpressionImpl<T> getParameter(int position, Class<T> type) {
        return this.getParameter(position);
    }

    public ParameterExpressionImpl<?> getParameter(String name) {
        for (Map.Entry<ParameterExpressionImpl<?>, Object> entry : this.parameters.entrySet()) {
            if (!name.equals(entry.getKey().getAlias())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Parameter with the name " + name + " does not exist");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this.getParameter(name);
    }

    public Set<Parameter<?>> getParameters() {
        HashSet parameters = Sets.newHashSet();
        parameters.addAll(this.q.getParameters());
        return parameters;
    }

    public Object getParameterValue(int position) {
        return this.parameters.get(this.getParameter(position));
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.parameters.get(param);
    }

    public Object getParameterValue(String name) {
        return this.parameters.get(this.getParameter(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<X> getResultList() {
        if (!this.q.isInternal() && this.em.hasActiveTransaction() && (this.flushMode == FlushModeType.AUTO || this.em.getFlushMode() == FlushModeType.AUTO)) {
            this.em.flush();
        }
        ManagedInstance.LOCK_CONTEXT.set(this.getLockMode());
        try {
            List<X> list = this.getResultListImpl();
            return list;
        }
        finally {
            ManagedInstance.LOCK_CONTEXT.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<X> getResultListImpl() {
        this.em.getSession().setLoadTracker();
        Connection connection = this.em.getConnection();
        try {
            boolean hasLock;
            LockModeType lockMode = this.getLockMode();
            boolean bl = hasLock = lockMode == LockModeType.PESSIMISTIC_READ || lockMode == LockModeType.PESSIMISTIC_WRITE || lockMode == LockModeType.PESSIMISTIC_FORCE_INCREMENT;
            if (hasLock) {
                this.sql = this.em.getJdbcAdaptor().applyLock(this.sql, lockMode);
            }
            Object[] parameters = this.applyParameters(connection);
            List<X> list = this.buildResultSet(connection, parameters);
            return list;
        }
        finally {
            this.em.getSession().releaseLoadTracker();
            this.em.closeConnectionIfNecessary();
        }
    }

    public X getSingleResult() {
        List<X> resultList = this.getResultList();
        if (resultList.size() > 1) {
            throw new NonUniqueResultException();
        }
        if (resultList.size() == 0) {
            throw new NoResultException();
        }
        return resultList.get(0);
    }

    private List<X> handle(ResultSet rs) throws SQLException {
        this.md = rs.getMetaData();
        CriteriaQueryImpl cq = (CriteriaQueryImpl)this.q;
        Selection selection = cq.getSelection();
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            this.prepareLabels(this.md);
        }
        this.results = Lists.newArrayList();
        SessionImpl session = this.em.getSession();
        while (rs.next()) {
            Object instance = selection.handle(this, session, rs);
            if (!cq.isDistinct() || !this.results.contains(instance)) {
                this.results.add(instance);
            }
            if (!debug) continue;
            this.storeData(rs);
        }
        LockModeType lockMode = this.getLockMode();
        if (lockMode != null) {
            for (int i = 0; i < this.results.size(); ++i) {
                this.em.lock(session.get(this.results.get(i)), lockMode, null);
            }
        }
        if (debug) {
            this.dumpResultSet();
        }
        return this.results;
    }

    public boolean isBound(Parameter<?> param) {
        return this.parameters.containsKey(param);
    }

    private int max(int length1, int length2) {
        return Math.min(30, Math.max(length1, length2));
    }

    private void prepareLabels(ResultSetMetaData md) throws SQLException {
        this.labels = new String[md.getColumnCount()];
        for (int i = 0; i < this.labels.length; ++i) {
            String label = md.getColumnName(i + 1) + " (" + md.getColumnTypeName(i + 1) + ")";
            this.labels[i] = label = StringUtils.abbreviate((String)label, (int)30);
        }
    }

    private QueryImpl<X> putParam(Parameter<?> param, Object value) {
        this.parameters.put((ParameterExpressionImpl)param, value);
        return this;
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    public QueryImpl<X> setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        return this;
    }

    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public TypedQuery<X> setMaxResults(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter((Parameter<Calendar>)this.getParameter(position, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        return this.setParameter((Parameter<Date>)this.getParameter(position, Date.class), value, temporalType);
    }

    public QueryImpl<X> setParameter(int position, Object value) {
        return this.putParam((Parameter<?>)this.getParameter(position), value);
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        return this.putParam(param, ValueConverter.toJdbc(value, Calendar.class, temporalType, null, false));
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        return this.putParam(param, ValueConverter.toJdbc(value, Date.class, temporalType, null, false));
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        this.parameters.put((ParameterExpressionImpl)param, value);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, Calendar.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        return this.setParameter(this.getParameter(name, Date.class), value, temporalType);
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        if (value instanceof Date) {
            return this.setParameter(name, (Date)value, TemporalType.TIMESTAMP);
        }
        if (value instanceof Calendar) {
            return this.setParameter(name, (Calendar)value, TemporalType.TIMESTAMP);
        }
        return this.putParam((Parameter<?>)this.getParameter(name), value);
    }

    public void storeData(ResultSet rs) throws SQLException {
        Object[] data = new Object[this.md.getColumnCount()];
        int columnCount = this.md.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            try {
                data[i] = rs.getObject(i + 1);
                continue;
            }
            catch (Exception e) {
                data[i] = "[N/A]";
            }
        }
        this.data.add(data);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this;
    }
}

