/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.Expression;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.ExpressionConverter;
import org.batoo.jpa.core.impl.criteria.expression.InExpression;
import org.batoo.jpa.core.impl.criteria.expression.IsNullExpression;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;

public abstract class AbstractExpression<T>
extends AbstractSelection<T>
implements Expression<T> {
    private ExpressionConverter<?> converter;

    public AbstractExpression(Class<T> javaType) {
        super(javaType);
    }

    public <X> Expression<X> as(Class<X> type) {
        if (this.getJavaType() == type) {
            return this;
        }
        if (type == BigDecimal.class) {
            this.setConverter(ExpressionConverter.BIG_DECIMAL);
        } else if (type == BigInteger.class) {
            this.setConverter(ExpressionConverter.BIG_INTEGER);
        } else if (type == Double.class) {
            this.setConverter(ExpressionConverter.DOUBLE);
        } else if (type == Float.class) {
            this.setConverter(ExpressionConverter.FLOAT);
        } else if (type == Integer.class) {
            this.setConverter(ExpressionConverter.INTEGER);
        } else if (type == Long.class) {
            this.setConverter(ExpressionConverter.LONG);
        } else if (type == String.class) {
            this.setConverter(ExpressionConverter.STRING);
        }
        throw new PersistenceException("Cannot cast to :" + type);
    }

    public abstract String generateJpqlRestriction(BaseQueryImpl<?> var1);

    public ExpressionConverter<?> getConverter() {
        return this.converter;
    }

    public PredicateImpl in(Collection<?> values) {
        return new PredicateImpl((AbstractExpression<Boolean>)new InExpression(this, values, false));
    }

    public PredicateImpl in(Expression<?> ... values) {
        return new PredicateImpl((AbstractExpression<Boolean>)new InExpression(this, values, false));
    }

    public PredicateImpl in(Expression<Collection<?>> values) {
        return null;
    }

    public PredicateImpl in(Object ... values) {
        return new PredicateImpl((AbstractExpression<Boolean>)new InExpression(this, Lists.newArrayList((Object[])values), false));
    }

    public PredicateImpl isNotNull() {
        return new PredicateImpl((AbstractExpression<Boolean>)new IsNullExpression(true, this));
    }

    public PredicateImpl isNull() {
        return new PredicateImpl((AbstractExpression<Boolean>)new IsNullExpression(false, this));
    }

    public PredicateImpl notIn(Collection<?> values) {
        return new PredicateImpl((AbstractExpression<Boolean>)new InExpression(this, values, true));
    }

    public PredicateImpl notIn(Expression<?> ... values) {
        return new PredicateImpl((AbstractExpression<Boolean>)new InExpression(this, values, true));
    }

    public PredicateImpl notIn(Expression<Collection<?>> values) {
        return null;
    }

    public PredicateImpl notIn(Object ... values) {
        return new PredicateImpl((AbstractExpression<Boolean>)new InExpression(this, Lists.newArrayList((Object[])values), true));
    }

    public <N> Expression<N> setConverter(ExpressionConverter<N> converter) {
        this.converter = converter;
        return this;
    }
}

