/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.Connection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.jdbc.AbstractColumn;

public abstract class AbstractParameterExpressionImpl<T>
extends AbstractExpression<T> {
    private TypeImpl<?> type;

    public AbstractParameterExpressionImpl(TypeImpl<T> type, Class<T> paramClass) {
        super(paramClass);
        this.type = type;
    }

    protected abstract void ensureAlias(BaseQueryImpl<?> var1);

    protected void ensureTypeResolved(MetamodelImpl metamodel) {
        if (this.type == null) {
            this.type = metamodel.createBasicType(this.getJavaType());
        }
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.ensureAlias(query);
        return null;
    }

    public int getExpandedCount(MetamodelImpl metamodelImpl) {
        if (this.getJavaType() == Class.class) {
            return 1;
        }
        this.ensureTypeResolved(metamodelImpl);
        if (this.type == null || this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
            return 1;
        }
        if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            return ((EmbeddableTypeImpl)this.type).getAttributeCount();
        }
        return ((EntityTypeImpl)this.type).getPrimaryTable().getPkColumns().size();
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        this.ensureAlias(query);
        query.setNextSqlParam(this);
        String[] restrictions = new String[this.getExpandedCount(query.getMetamodel())];
        for (int i = 0; i < restrictions.length; ++i) {
            restrictions[i] = "?";
        }
        return restrictions;
    }

    private void setParameter(Connection connection, Object[] parameters, MutableInt sqlIndex, Object value, EmbeddableTypeImpl<?> type) {
        SingularAttributeImpl<?, ?>[] attributes;
        block5: for (SingularAttributeImpl<?, ?> attribute : attributes = type.getSingularMappings()) {
            switch (attribute.getPersistentAttributeType()) {
                case BASIC: {
                    parameters[sqlIndex.intValue()] = attribute.get(value);
                    sqlIndex.increment();
                    continue block5;
                }
                case MANY_TO_ONE: 
                case ONE_TO_ONE: {
                    this.setParameter(connection, parameters, sqlIndex, attribute.get(value), (EntityTypeImpl)attribute.getType());
                    continue block5;
                }
                case EMBEDDED: {
                    this.setParameter(connection, parameters, sqlIndex, attribute.get(value), (EmbeddableTypeImpl)this.type);
                }
            }
        }
    }

    private void setParameter(Connection connection, Object[] parameters, MutableInt sqlIndex, Object value, EntityTypeImpl<?> type) {
        for (AbstractColumn column : type.getPrimaryTable().getPkColumns()) {
            parameters[sqlIndex.intValue()] = value != null ? column.getValue(connection, value) : null;
            sqlIndex.increment();
        }
    }

    protected void setParameter(MetamodelImpl metamodel, Connection connection, Object[] parameters, MutableInt sqlIndex, Object value) {
        if (this.getJavaType() == Class.class) {
            EntityType entity = metamodel.entity((Class)value);
            if (entity == null) {
                throw new IllegalArgumentException("Type is not managed: " + value);
            }
            if (entity.getRootType().getInheritanceType() == null) {
                throw new IllegalArgumentException("Entity does not have inheritence: " + entity.getName());
            }
            parameters[sqlIndex.intValue()] = entity.getDiscriminatorValue();
            sqlIndex.increment();
        } else {
            this.ensureTypeResolved(metamodel);
            if (this.type == null || this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
                parameters[sqlIndex.intValue()] = value;
                sqlIndex.increment();
            } else {
                TypeImpl<?> valueType;
                TypeImpl<?> typeImpl = valueType = value == null ? this.type : metamodel.type(value.getClass());
                if (valueType != null && valueType.getPersistenceType() == Type.PersistenceType.BASIC) {
                    parameters[sqlIndex.intValue()] = value;
                    sqlIndex.increment();
                } else if (this.type.getPersistenceType() == Type.PersistenceType.ENTITY) {
                    EntityTypeImpl type = (EntityTypeImpl)this.type;
                    this.setParameter(connection, parameters, sqlIndex, value, type);
                } else {
                    EmbeddableTypeImpl type = (EmbeddableTypeImpl)this.type;
                    this.setParameter(connection, parameters, sqlIndex, value, type);
                }
            }
        }
    }
}

