/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class ArithmeticExression<N extends Number>
extends AbstractExpression<N> {
    private final ArithmeticOperation operation;
    private final AbstractExpression<N> x;
    private final AbstractExpression<N> y;
    private String alias;

    public ArithmeticExression(ArithmeticOperation operation, Expression<? extends N> x, Expression<? extends N> y) {
        super(x.getJavaType());
        this.operation = operation;
        this.x = (AbstractExpression)x;
        this.y = (AbstractExpression)y;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return this.x.generateJpqlRestriction(query) + this.operation.getFragment() + this.y.generateJpqlRestriction(query);
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.x.generateJpqlRestriction(query));
        builder.append(this.operation.getFragment());
        builder.append(this.y.generateJpqlRestriction(query));
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            builder.append(" as ").append(this.getAlias());
        }
        return builder.toString();
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return new String[]{this.x.getSqlRestrictionFragments(query)[0] + this.operation.getFragment() + this.y.getSqlRestrictionFragments(query)[0]};
    }

    @Override
    public N handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Number value = (Number)row.getObject(this.alias);
        return (N)(this.getConverter() != null ? this.getConverter().convert(value) : value);
    }

    public static enum ArithmeticOperation {
        ADD(" + "),
        SUBTRACT(" - "),
        MULTIPLY(" * "),
        DIVIDE(" / ");

        private final String fragment;

        private ArithmeticOperation(String fragment) {
            this.fragment = fragment;
        }

        public String getFragment() {
            return this.fragment;
        }
    }
}

