/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.util.Pair;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.EntityConstantExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class CaseImpl<T>
extends AbstractExpression<T>
implements CriteriaBuilder.Case<T> {
    private final List<Pair<Expression<Boolean>, Expression<? extends T>>> conditions = Lists.newArrayList();
    private Expression<? extends T> otherwise;
    private String alias;

    public CaseImpl() {
        super(Object.class);
    }

    @Override
    public String generateJpqlRestriction(final BaseQueryImpl<?> query) {
        String whens = Joiner.on((String)"\n\t").join((Iterable)Lists.transform(this.conditions, (Function)new Function<Pair<Expression<Boolean>, Expression<? extends T>>, String>(){

            public String apply(Pair<Expression<Boolean>, Expression<? extends T>> input) {
                AbstractExpression when = (AbstractExpression)input.getFirst();
                AbstractExpression then = (AbstractExpression)input.getSecond();
                return "when " + when.generateJpqlRestriction(query) + " then " + then.generateJpqlRestriction(query);
            }
        }));
        String otherwise = "\n\telse " + ((AbstractExpression)this.otherwise).generateJpqlRestriction(query);
        return "case\n\t" + whens + otherwise + "\nend";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(final BaseQueryImpl<?> query) {
        String whens = Joiner.on((String)"\n\t").join((Iterable)Lists.transform(this.conditions, (Function)new Function<Pair<Expression<Boolean>, Expression<? extends T>>, String>(){

            public String apply(Pair<Expression<Boolean>, Expression<? extends T>> input) {
                AbstractExpression when = (AbstractExpression)input.getFirst();
                AbstractExpression then = (AbstractExpression)input.getSecond();
                return "WHEN " + when.getSqlRestrictionFragments(query)[0] + " THEN " + then.getSqlRestrictionFragments(query)[0];
            }
        }));
        String otherwise = "\n\tELSE " + ((AbstractExpression)this.otherwise).getSqlRestrictionFragments(query)[0];
        return new String[]{"CASE\n\t" + whens + otherwise + "\nEND"};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (T)row.getObject(this.alias);
    }

    public Expression<T> otherwise(Expression<? extends T> result) {
        this.otherwise = result;
        return this;
    }

    public Expression<T> otherwise(T result) {
        return this.otherwise((T)new EntityConstantExpression<T>(null, result));
    }

    public CriteriaBuilder.Case<T> when(Expression<Boolean> condition, Expression<? extends T> result) {
        this.conditions.add(new Pair<Expression<Boolean>, Expression<? extends T>>(condition, result));
        return this;
    }

    public CriteriaBuilder.Case<T> when(Expression<Boolean> condition, T result) {
        return this.when(condition, (T)new EntityConstantExpression<T>(null, result));
    }
}

