/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class CountExpression
extends AbstractExpression<Long> {
    private final AbstractExpression<?> inner;
    private final boolean distinct;
    private String alias;

    public CountExpression(Expression<?> inner, boolean distinct) {
        super(Long.class);
        this.inner = (AbstractExpression)inner;
        this.distinct = distinct;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder("count(");
        if (this.distinct) {
            builder.append("distinct ");
        }
        builder.append(this.inner.generateJpqlRestriction(query));
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder("COUNT(");
        if (this.distinct) {
            builder.append("DISTINCT ");
        }
        builder.append(this.inner.getSqlRestrictionFragments(query)[0]);
        builder.append(")");
        return new String[]{builder.toString()};
    }

    @Override
    public Long handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return row.getLong(this.alias);
    }
}

