/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.CollectionExpression;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class IsEmptyExpression
extends AbstractExpression<Boolean> {
    private final CollectionExpression<?, ?> inner;
    private final boolean not;

    public IsEmptyExpression(Expression<?> inner, boolean not) {
        super(Boolean.class);
        this.inner = (CollectionExpression)inner;
        this.not = not;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return this.inner.generateJpqlRestriction(query) + (this.not ? " is not empty" : " is empty");
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection expressions cannot be selected");
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection expressions cannot be selected");
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        CriteriaBuilderImpl cb = query.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
        Joinable rp = this.inner.getParentPath().getRootPath();
        SubqueryImpl<Integer> s = query.subquery(Integer.class);
        Root r = s.from(rp.getEntity());
        r.join(this.inner.getMapping().getAttribute().getName());
        Predicate p = this.not ? cb.exists(s) : cb.exists(s).not();
        s.where((Expression<Boolean>)cb.equal((Expression)r, (AbstractExpression)((Object)rp)));
        s.select((Expression<Integer>)cb.literal((Object)1));
        return p.getSqlRestrictionFragments(query);
    }

    @Override
    public Boolean handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return null;
    }
}

