/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.join;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import org.batoo.common.util.Pair;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.MapEntryExpression;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.criteria.join.AbstractPluralJoin;
import org.batoo.jpa.core.impl.criteria.path.MapKeyPath;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;

public class MapJoinImpl<Z, K, V>
extends AbstractPluralJoin<Z, Map<K, V>, V>
implements MapJoin<Z, K, V> {
    public MapJoinImpl(AbstractFrom<?, Z> parent, PluralMappingEx<? super Z, Map<K, V>, V> mapping, JoinType jointType) {
        super(parent, mapping, jointType);
    }

    public Expression<Map.Entry<K, V>> entry() {
        return new MapEntryExpression(this, Map.Entry.class);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateSqlSelect(query, selected, MapSelectType.VALUE);
    }

    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected, MapSelectType selectType) {
        this.select(selected);
        return this.getFetchRoot().generateSqlSelect(query, selected, this.getParentPath() == null, selectType);
    }

    public MapAttributeImpl<? super Z, K, V> getModel() {
        return (MapAttributeImpl)this.getAttribute();
    }

    @Override
    public V handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (V)this.handle(session, row, MapSelectType.VALUE);
    }

    public Object handle(SessionImpl session, ResultSet row, MapSelectType selectType) throws SQLException {
        if (this.getEntity() != null) {
            EntryImpl<Object, ManagedInstance<?>> result = this.getFetchRoot().handle(session, row, selectType);
            switch (selectType) {
                case KEY: {
                    return result.getKey();
                }
                case VALUE: {
                    return result.getValue().getInstance();
                }
            }
            return new Pair(result.getKey(), result.getValue().getInstance());
        }
        EntryImpl result = this.getFetchRoot().handleElementFetch(row, selectType);
        switch (selectType) {
            case KEY: {
                return result.getKey();
            }
            case VALUE: {
                return result.getValue();
            }
        }
        return result;
    }

    public Path<K> key() {
        return new MapKeyPath(this, this.getModel().getKeyJavaType());
    }

    public Expression<Class<?>> type(MapSelectType selectType) {
        return null;
    }

    public Path<V> value() {
        return this;
    }

    public static enum MapSelectType {
        VALUE,
        KEY,
        ENTRY;

    }
}

