/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jolbox.bonecp.BoneCP;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.sql.DataSource;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.BatooException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.BJPASettings;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.jpql.JpqlQuery;
import org.batoo.jpa.core.impl.deployment.DdlManager;
import org.batoo.jpa.core.impl.deployment.LinkManager;
import org.batoo.jpa.core.impl.deployment.NamedQueriesManager;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.PersistenceUnitUtilImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.jdbc.AbstractDataSource;
import org.batoo.jpa.jdbc.BoneCPDataSource;
import org.batoo.jpa.jdbc.DDLMode;
import org.batoo.jpa.jdbc.DataSourceProxy;
import org.batoo.jpa.jdbc.PreparedStatementProxy;
import org.batoo.jpa.jdbc.adapter.AbstractJdbcAdaptor;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.PersistenceParser;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public class EntityManagerFactoryImpl
implements EntityManagerFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final BLogger LOG = BLoggerFactory.getLogger(EntityManagerFactoryImpl.class);
    private static final int NO_QUERIES_MAX = 1000;
    private static final int NO_QUERIES_TRIM = 100;
    private final MetamodelImpl metamodel;
    private final DDLMode ddlMode;
    private final DataSourceProxy dataSource;
    private final JdbcAdaptor jdbcAdaptor;
    private final Map<String, Object> properties = Maps.newHashMap();
    private final Map<String, JpqlQuery> namedQueries = Maps.newHashMap();
    private final CriteriaBuilderImpl criteriaBuilder;
    private final PersistenceUnitUtilImpl persistenceUtil;
    private final HashMap<String, JpqlQuery> jpqlCache = Maps.newHashMap();
    private final ClassLoader classloader;
    private final ValidatorFactory validationFactory;
    private final Class<?>[] persistValidators;
    private final Class<?>[] updateValidators;
    private final Class<?>[] removeValidators;
    private final int maxFetchJoinDepth;
    private boolean open;
    private AbstractDataSource dataSourcePool;

    public EntityManagerFactoryImpl(String name, PersistenceParser parser) {
        this.classloader = parser.getClassloader();
        this.prepareProperties(parser);
        boolean hasValidators = parser.hasValidators();
        if (hasValidators) {
            this.validationFactory = this.createValidationFactory();
            this.persistValidators = this.getValidatorsFor(parser, "javax.persistence.validation.group.pre-persist");
            this.updateValidators = this.getValidatorsFor(parser, "javax.persistence.validation.group.pre-update");
            this.removeValidators = this.getValidatorsFor(parser, "javax.persistence.validation.group.pre-remove");
        } else {
            this.validationFactory = null;
            this.persistValidators = null;
            this.updateValidators = null;
            this.removeValidators = null;
        }
        try {
            this.maxFetchJoinDepth = this.getProperty("org.batoo.jdbc.max_fetch_join_depth") != null ? Integer.valueOf((String)this.getProperty("org.batoo.jdbc.max_fetch_join_depth")) : BJPASettings.DEFAULT_MAX_FETCH_JOIN_DEPTH;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal value " + this.getProperty("org.batoo.jpa.sql_logging") + " for " + "org.batoo.jpa.sql_logging");
        }
        this.dataSource = this.createDatasource(name, parser);
        this.ddlMode = this.readDdlMode();
        this.jdbcAdaptor = this.createJdbcAdaptor();
        this.metamodel = new MetamodelImpl(this, this.jdbcAdaptor, parser.getMetadata());
        LinkManager.perform(this.metamodel);
        this.metamodel.checkTables();
        if (this.ddlMode == DDLMode.DROP) {
            this.metamodel.dropAllTables(this.dataSource);
        }
        DdlManager.perform(this.dataSource, this.metamodel, this.ddlMode);
        this.metamodel.performSequencesDdl(this.dataSource, this.ddlMode);
        this.metamodel.performTableGeneratorsDdl(this.dataSource, this.ddlMode);
        this.metamodel.preFillGenerators(this.dataSource);
        this.criteriaBuilder = new CriteriaBuilderImpl(this.metamodel);
        NamedQueriesManager.perform(this.metamodel, this.criteriaBuilder);
        this.metamodel.initStaticMetamodels();
        this.persistenceUtil = new PersistenceUnitUtilImpl(this);
        this.jdbcAdaptor.importSql(this.classloader, this.dataSource, (String)this.getProperties().get("org.batoo.jdbc.import_sql"));
        BatooUtils.gaBoot(this.properties);
        this.open = true;
    }

    public void addNamedQuery(String name, JpqlQuery jpqlQuery) {
        if (this.namedQueries.containsKey(name)) {
            throw new IllegalArgumentException("A named query with the same name already exists: " + name);
        }
        this.namedQueries.put(name, jpqlQuery);
    }

    public void addNamedQuery(final String name, Query query) {
        final QueryImpl typedQuery = (QueryImpl)query;
        final String jpql = typedQuery.getCriteriaQuery().getJpql();
        new JpqlQuery(this, this.criteriaBuilder, new NamedQueryMetadata(){

            @Override
            public Map<String, Object> getHints() {
                return typedQuery.getHints();
            }

            @Override
            public AbstractLocator getLocator() {
                return null;
            }

            @Override
            public LockModeType getLockMode() {
                return typedQuery.getLockMode();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getQuery() {
                return jpql;
            }
        });
    }

    protected void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("EntityManagerFactory has been previously closed");
        }
    }

    public void close() {
        this.assertOpen();
        this.metamodel.stopIdGenerators();
        String dropOnClose = (String)this.getProperty("org.batoo.jpa.dropOnClose");
        if ("true".equalsIgnoreCase(dropOnClose)) {
            this.metamodel.dropAllTables(this.dataSource);
        }
        this.dataSource.close();
        this.open = false;
    }

    private DataSourceProxy createDatasource(String persistanceUnitName, PersistenceParser parser) {
        int jdbcFetchSize;
        long slowSqlThreshold;
        PreparedStatementProxy.SqlLoggingType sqlLogging;
        block13: {
            try {
                sqlLogging = this.getProperty("org.batoo.jpa.sql_logging") != null ? PreparedStatementProxy.SqlLoggingType.valueOf(((String)this.getProperty("org.batoo.jpa.sql_logging")).toUpperCase(Locale.ENGLISH)) : PreparedStatementProxy.SqlLoggingType.NONE;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value " + this.getProperty("org.batoo.jpa.sql_logging") + " for " + "org.batoo.jpa.sql_logging");
            }
            try {
                slowSqlThreshold = this.getProperty("org.batoo.jpa.slow_sql_threshold") != null ? Long.valueOf((String)this.getProperty("org.batoo.jpa.slow_sql_threshold")) : BJPASettings.DEFAULT_SLOW_SQL_THRESHOLD;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value " + this.getProperty("org.batoo.jpa.slow_sql_threshold") + " for " + "org.batoo.jpa.slow_sql_threshold");
            }
            try {
                jdbcFetchSize = this.getProperty("org.batoo.jdbc.fetch_size") != null ? Integer.valueOf((String)this.getProperty("org.batoo.jdbc.fetch_size")) : BJPASettings.DEFAULT_FETCH_SIZE;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value " + this.getProperty("org.batoo.jdbc.fetch_size") + " for " + "org.batoo.jdbc.fetch_size");
            }
            if (this.getProperty("org.batoo.jdbc.datasource.pool") != null) {
                String poolClassName = (String)this.getProperty("org.batoo.jdbc.datasource.pool");
                String hintName = (String)this.getProperty("org.batoo.jdbc.datasource.name");
                try {
                    Object newInstance = this.classloader.loadClass(poolClassName).newInstance();
                    if (newInstance instanceof AbstractDataSource) {
                        this.dataSourcePool = (AbstractDataSource)newInstance;
                        break block13;
                    }
                    throw new IllegalArgumentException("Illegal value " + this.getProperty("org.batoo.jdbc.datasource.pool") + " for " + "org.batoo.jdbc.datasource.pool" + " Please provide a datasource pool implementation extending org.batoo.jpa.jdbc.AbstractDataSourcePool");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Class not found: " + this.getProperty("org.batoo.jdbc.datasource.pool"));
                }
                finally {
                    this.dataSourcePool.open(persistanceUnitName, hintName);
                }
            }
        }
        return this.createDatasourceProxy(parser, sqlLogging, slowSqlThreshold, jdbcFetchSize);
    }

    private DataSource createDatasource0(PersistenceParser parser) {
        try {
            String jdbcDriver = (String)this.getProperty("javax.persistence.jdbc.driver");
            String jdbcUrl = (String)this.getProperty("javax.persistence.jdbc.url");
            String jdbcUser = (String)this.getProperty("javax.persistence.jdbc.user");
            String jdbcPassword = (String)this.getProperty("javax.persistence.jdbc.password");
            Integer statementsCacheSize = this.getProperty("org.batoo.jdbc.statement_cache_size") != null ? Integer.valueOf((String)this.getProperty("org.batoo.jdbc.statement_cache_size")) : BJPASettings.DEFAULT_STATEMENT_CACHE_SIZE;
            Integer minConnections = this.getProperty("org.batoo.jdbc.min_connections") != null ? Integer.valueOf((String)this.getProperty("org.batoo.jdbc.min_connections")) : BJPASettings.DEFAULT_MIN_CONNECTIONS;
            BoneCPDataSource dataSource = new BoneCPDataSource();
            dataSource.setDriverClass(jdbcDriver);
            dataSource.setJdbcUrl(jdbcUrl);
            dataSource.setUsername(jdbcUser);
            dataSource.setPassword(jdbcPassword);
            dataSource.setStatementsCacheSize(statementsCacheSize);
            dataSource.setMinConnectionsPerPartition(minConnections);
            dataSource.setMaxConnectionsPerPartition(5);
            dataSource.setDisableConnectionTracking(true);
            dataSource.setReleaseHelperThreads(0);
            return dataSource;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal values for datasource settings!");
        }
    }

    private DataSourceProxy createDatasourceProxy(PersistenceParser parser, PreparedStatementProxy.SqlLoggingType sqlLogging, long slowSqlThreshold, int jdbcFetchSize) {
        boolean external;
        boolean bl = external = parser.getJtaDataSource() != null || parser.getNonJtaDataSource() != null;
        if (parser.getJtaDataSource() != null) {
            return new DataSourceProxy(parser.getJtaDataSource(), external, sqlLogging, slowSqlThreshold, jdbcFetchSize);
        }
        if (parser.getNonJtaDataSource() != null) {
            return new DataSourceProxy(parser.getNonJtaDataSource(), external, sqlLogging, slowSqlThreshold, jdbcFetchSize);
        }
        if (this.dataSourcePool != null) {
            return new DataSourceProxy(this.dataSourcePool, external, sqlLogging, slowSqlThreshold, jdbcFetchSize);
        }
        return new DataSourceProxy(this.createDatasource0(parser), external, sqlLogging, slowSqlThreshold, jdbcFetchSize);
    }

    public EntityManagerImpl createEntityManager() {
        this.assertOpen();
        return new EntityManagerImpl(this, this.metamodel, this.dataSource, Collections.<String, Object>emptyMap(), this.jdbcAdaptor);
    }

    public EntityManager createEntityManager(Map<String, Object> map) {
        this.assertOpen();
        return new EntityManagerImpl(this, this.metamodel, this.dataSource, map, this.jdbcAdaptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcAdaptor createJdbcAdaptor() {
        JdbcAdaptor jdbcAdaptor;
        int removeBatchSize;
        int insertBatchSize;
        try {
            insertBatchSize = this.getProperty("org.batoo.jdbc.insert_batch_size") != null ? Integer.valueOf((String)this.getProperty("org.batoo.jdbc.insert_batch_size")) : BJPASettings.DEFAULT_INSERT_BATCH_SIZE;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal value " + this.getProperty("org.batoo.jdbc.insert_batch_size") + " for " + "org.batoo.jdbc.insert_batch_size");
        }
        try {
            removeBatchSize = this.getProperty("org.batoo.jdbc.remove_batch_size") != null ? Integer.valueOf((String)this.getProperty("org.batoo.jdbc.remove_batch_size")) : BJPASettings.DEFAULT_REMOVE_BATCH_SIZE;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal value " + this.getProperty("org.batoo.jdbc.remove_batch_size") + " for " + "org.batoo.jdbc.remove_batch_size");
        }
        Connection connection = this.dataSource.getConnection();
        try {
            JdbcAdaptor adapter = AbstractJdbcAdaptor.getAdapter(this.classloader, connection.getMetaData().getDatabaseProductName());
            adapter.setInsertBatchSize(insertBatchSize);
            adapter.setRemoveBatchSize(removeBatchSize);
            jdbcAdaptor = adapter;
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BatooException("Unable to get connection from the datasource", e);
            }
        }
        connection.close();
        return jdbcAdaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory createValidationFactory() {
        try {
            return Validation.buildDefaultValidatorFactory();
        }
        catch (ValidationException e) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
                return validatorFactory;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public Cache getCache() {
        return null;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public CriteriaBuilderImpl getCriteriaBuilder() {
        this.assertOpen();
        return this.criteriaBuilder;
    }

    protected DataSource getDatasource() {
        return this.dataSource;
    }

    protected JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpqlQuery getJpqlQuery(String qlString) {
        try {
            LOG.debug("JPQL: {0}", qlString);
            JpqlQuery jpqlQuery = this.jpqlCache.get(qlString);
            if (jpqlQuery == null) {
                jpqlQuery = new JpqlQuery(this, qlString);
                if (this.jpqlCache.size() == 1000) {
                    EntityManagerFactoryImpl entityManagerFactoryImpl = this;
                    synchronized (entityManagerFactoryImpl) {
                        if (this.jpqlCache.size() == 1000) {
                            JpqlQuery[] queries = Lists.newArrayList(this.jpqlCache.values()).toArray(new JpqlQuery[this.jpqlCache.size()]);
                            Arrays.sort(queries, new Comparator<JpqlQuery>(){

                                @Override
                                public int compare(JpqlQuery o1, JpqlQuery o2) {
                                    if (o1.getLastUsed() > o2.getLastUsed()) {
                                        return 1;
                                    }
                                    return -1;
                                }
                            });
                            for (int i = 0; i < 100; ++i) {
                                this.jpqlCache.remove(queries[i].getQueryString());
                            }
                        }
                    }
                }
                this.jpqlCache.put(qlString, jpqlQuery);
            }
            return jpqlQuery;
        }
        catch (Exception e) {
            if (e.getCause() instanceof PersistenceException) {
                throw (PersistenceException)e.getCause();
            }
            if (e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw new PersistenceException("Cannot parse query: " + qlString, (Throwable)e);
        }
    }

    public int getMaxFetchJoinDepth() {
        return this.maxFetchJoinDepth;
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public JpqlQuery getNamedQuery(String name) {
        return this.namedQueries.get(name);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.persistenceUtil;
    }

    public Class<?>[] getPersistValidators() {
        return this.persistValidators;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Class<?>[] getRemoveValidators() {
        return this.removeValidators;
    }

    public Class<?>[] getUpdateValidators() {
        return this.updateValidators;
    }

    public ValidatorFactory getValidationFactory() {
        return this.validationFactory;
    }

    private Class<?>[] getValidatorsFor(PersistenceParser parser, String group) {
        String groups = (String)parser.getProperties().get(group);
        if (StringUtils.isBlank((String)groups)) {
            return new Class[]{Default.class};
        }
        HashSet validationGroups = Sets.newHashSet();
        for (String className : Splitter.on((String)",").trimResults().split((CharSequence)groups)) {
            try {
                validationGroups.add(this.classloader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException("Cannot load class for validation group: " + className);
            }
        }
        return validationGroups.toArray(new Class[validationGroups.size()]);
    }

    public boolean hasValidators() {
        return this.validationFactory != null;
    }

    public boolean isOpen() {
        return this.open;
    }

    private void prepareProperties(PersistenceParser parser) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (!(key instanceof String)) continue;
            this.properties.put((String)key, System.getProperties().get(key));
        }
        this.properties.putAll(parser.getProperties());
        this.properties.putAll(BatooUtils.loadRuntimeProperties());
    }

    private DDLMode readDdlMode() {
        String ddlMode = (String)this.getProperty("org.batoo.jpa.ddl");
        if (ddlMode == null) {
            return DDLMode.NONE;
        }
        return DDLMode.valueOf(ddlMode.toUpperCase());
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == EntityManagerFactoryImpl.class) {
            return (T)this;
        }
        if (clazz == BoneCPDataSource.class && this.dataSource.getDelegate() instanceof BoneCPDataSource) {
            return (T)this.dataSource.getDelegate();
        }
        if (clazz == BoneCP.class && this.dataSource.getDelegate() instanceof BoneCP) {
            return (T)this.dataSource.getDelegate();
        }
        return null;
    }
}

