/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.StaticMetamodel;
import javax.sql.DataSource;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.manager.CallbackAvailability;
import org.batoo.jpa.core.impl.manager.CallbackManager;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.model.BasicTypeImpl;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.CollectionTable;
import org.batoo.jpa.jdbc.DDLMode;
import org.batoo.jpa.jdbc.EntityTable;
import org.batoo.jpa.jdbc.ForeignKey;
import org.batoo.jpa.jdbc.JoinTable;
import org.batoo.jpa.jdbc.SecondaryTable;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.generator.SequenceGenerator;
import org.batoo.jpa.jdbc.generator.SequenceQueue;
import org.batoo.jpa.jdbc.generator.TableGenerator;
import org.batoo.jpa.jdbc.generator.TableIdQueue;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.metadata.MetadataImpl;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.NamedNativeQueryMetadata;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;
import org.batoo.jpa.parser.metadata.SequenceGeneratorMetadata;
import org.batoo.jpa.parser.metadata.SqlResultSetMappingMetadata;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.type.EmbeddableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;
import org.batoo.jpa.parser.metadata.type.MappedSuperclassMetadata;

public class MetamodelImpl
implements Metamodel {
    private static final BLogger LOG = BLoggerFactory.getLogger(MetamodelImpl.class);
    private static final long POLL_TIMEOUT = 60L;
    private EntityManagerFactoryImpl emf;
    private final JdbcAdaptor jdbcAdaptor;
    private final Map<Class<?>, BasicTypeImpl<?>> basics = Maps.newHashMap();
    private final Map<Class<?>, MappedSuperclassTypeImpl<?>> mappedSuperclasses = Maps.newHashMap();
    private final Map<Class<?>, EmbeddableTypeImpl<?>> embeddables = Maps.newHashMap();
    private final Map<Class<?>, EntityTypeImpl<?>> entities = Maps.newHashMap();
    private final Map<String, EntityTypeImpl<?>> entitiesByName = Maps.newHashMap();
    private final Map<String, NamedQueryMetadata> namedQueries = Maps.newHashMap();
    private final Map<String, NamedNativeQueryMetadata> namedNativeQueries = Maps.newHashMap();
    private final Map<String, SqlResultSetMappingMetadata> sqlResultSetMappings = Maps.newHashMap();
    private final CallbackManager callbackManager;
    private final Map<String, SequenceGenerator> sequenceGenerators = Maps.newHashMap();
    private final Map<String, TableGenerator> tableGenerators = Maps.newHashMap();
    private final Map<String, SequenceQueue> sequenceQueues = Maps.newHashMap();
    private final Map<String, TableIdQueue> tableIdQueues = Maps.newHashMap();
    private ThreadPoolExecutor idGeneratorExecuter;

    public MetamodelImpl(EntityManagerFactoryImpl entityManagerFactory, JdbcAdaptor jdbcAdaptor, MetadataImpl metadata) {
        this.emf = entityManagerFactory;
        this.jdbcAdaptor = jdbcAdaptor;
        ArrayList entities = Lists.newArrayList(metadata.getEntityMappings());
        ArrayList sortedEntities = Lists.newArrayList();
        Collections.sort(entities, new Comparator<ManagedTypeMetadata>(){

            @Override
            public int compare(ManagedTypeMetadata o1, ManagedTypeMetadata o2) {
                if (o1 instanceof EmbeddableMetadata) {
                    return -1;
                }
                if (o2 instanceof EmbeddableMetadata) {
                    return 1;
                }
                return 0;
            }
        });
        try {
            while (entities.size() > 0) {
                Iterator i = entities.iterator();
                while (i.hasNext()) {
                    ManagedTypeMetadata entity = (ManagedTypeMetadata)i.next();
                    Class<?> c1 = this.emf.getClassloader().loadClass(entity.getClassName());
                    boolean independent = true;
                    for (ManagedTypeMetadata entity2 : entities) {
                        Class<?> c2;
                        if (entity == entity2 || !(c2 = this.emf.getClassloader().loadClass(entity2.getClassName())).isAssignableFrom(c1)) continue;
                        independent = false;
                        break;
                    }
                    if (!independent) continue;
                    i.remove();
                    sortedEntities.add(entity);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (ManagedTypeMetadata type : sortedEntities) {
            try {
                Class<?> clazz = this.emf.getClassloader().loadClass(type.getClassName());
                ManagedType parent = null;
                for (Class<?> currentClass = clazz.getSuperclass(); currentClass != Object.class && parent == null; currentClass = currentClass.getSuperclass()) {
                    parent = this.managedType(currentClass);
                }
                if (type instanceof EntityMetadata) {
                    if (parent != null && !(parent instanceof IdentifiableTypeImpl)) {
                        throw new MappingException("Entities can only extend MappedSuperclasses or other Entities.", type.getLocator(), parent.getLocator());
                    }
                    EntityTypeImpl entity = new EntityTypeImpl(this, (IdentifiableTypeImpl)parent, clazz, (EntityMetadata)type);
                    this.entities.put(entity.getJavaType(), entity);
                    this.entitiesByName.put(entity.getName(), entity);
                    this.entitiesByName.put(entity.getJavaType().getName(), entity);
                } else if (type instanceof MappedSuperclassMetadata) {
                    if (parent != null && !(parent instanceof MappedSuperclassTypeImpl)) {
                        throw new MappingException("MappedSuperclasses can only extend other MappedSuperclasses.", type.getLocator(), parent.getLocator());
                    }
                    MappedSuperclassTypeImpl mappedSuperclass = new MappedSuperclassTypeImpl(this, (MappedSuperclassTypeImpl)parent, clazz, (MappedSuperclassMetadata)type);
                    this.mappedSuperclasses.put(mappedSuperclass.getJavaType(), mappedSuperclass);
                }
                if (!(type instanceof EmbeddableMetadata)) continue;
                if (parent != null && !(parent instanceof EmbeddableTypeImpl)) {
                    throw new MappingException("Embeddables can only extend other Embeddables.", type.getLocator(), parent.getLocator());
                }
                EmbeddableTypeImpl embeddable = new EmbeddableTypeImpl(this, clazz, (EmbeddableMetadata)type);
                this.embeddables.put(embeddable.getJavaType(), embeddable);
            }
            catch (ClassNotFoundException e) {}
        }
        this.callbackManager = new CallbackManager(metadata.getEntityListeners());
        this.addSequenceGenerators(metadata.getSequenceGenerators());
        this.addTableGenerators(metadata.getTableGenerators());
        this.addNamedQueries(metadata.getNamedQueries());
        this.addNamedNativeQueries(metadata.getNamedNativeQueries());
        this.addSqlResultSetMappings(metadata.getSqlResultSetMapping());
    }

    private void addNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries) {
        for (NamedNativeQueryMetadata namedNativeQuery : namedNativeQueries) {
            if (this.namedQueries.containsKey(namedNativeQuery.getName()) || this.namedNativeQueries.containsKey(namedNativeQuery.getName())) {
                throw new MappingException("Duplicate named native query with the name: " + namedNativeQuery.getName(), namedNativeQuery.getLocator());
            }
            this.namedNativeQueries.put(namedNativeQuery.getName(), namedNativeQuery);
        }
    }

    private void addNamedQueries(List<NamedQueryMetadata> namedQueries) {
        for (NamedQueryMetadata namedQuery : namedQueries) {
            if (this.namedQueries.containsKey(namedQuery.getName()) || this.namedNativeQueries.containsKey(namedQuery.getName())) {
                throw new MappingException("Duplicate named query with the name: " + namedQuery.getName(), namedQuery.getLocator());
            }
            this.namedQueries.put(namedQuery.getName(), namedQuery);
        }
    }

    public synchronized void addSequenceGenerator(SequenceGeneratorMetadata metadata) {
        SequenceGenerator sequenceGenerator = new SequenceGenerator(metadata);
        this.sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
    }

    private void addSequenceGenerators(List<SequenceGeneratorMetadata> sequenceGeneratorMetadatas) {
        for (SequenceGeneratorMetadata sequenceGeneratorMetadata : sequenceGeneratorMetadatas) {
            this.addSequenceGenerator(sequenceGeneratorMetadata);
        }
    }

    private void addSqlResultSetMappings(List<SqlResultSetMappingMetadata> sqlResultSetMappings) {
        for (SqlResultSetMappingMetadata sqlResultSetMappingMetadata : sqlResultSetMappings) {
            SqlResultSetMappingMetadata existing = this.sqlResultSetMappings.put(sqlResultSetMappingMetadata.getName(), sqlResultSetMappingMetadata);
            if (existing == null) continue;
            throw new MappingException("Duplicate sqlResultSetMapping with the name: " + sqlResultSetMappingMetadata.getName(), existing.getLocator(), sqlResultSetMappingMetadata.getLocator());
        }
    }

    public synchronized void addTableGenerator(TableGeneratorMetadata metadata) {
        TableGenerator tableGenerator = new TableGenerator(metadata);
        this.tableGenerators.put(tableGenerator.getName(), tableGenerator);
    }

    private void addTableGenerators(List<TableGeneratorMetadata> metadatas) {
        for (TableGeneratorMetadata tableGeneratorMetadata : metadatas) {
            this.addTableGenerator(tableGeneratorMetadata);
        }
    }

    public void checkTables() {
        HashMap tableNames = Maps.newHashMap();
        for (AbstractTable table : this.getAllTables()) {
            AbstractTable existing = tableNames.put(table.getName(), table);
            if (existing == null) continue;
            throw new MappingException("Duplicate table names " + this.getTableDesc(existing) + ", " + this.getTableDesc(table), new AbstractLocator[0]);
        }
    }

    public <T> BasicTypeImpl<T> createBasicType(Class<T> clazz) {
        BasicTypeImpl<?> basicType = this.basics.get(clazz);
        if (basicType != null) {
            return basicType;
        }
        return this.lazyCreateBasicType(clazz);
    }

    public void dropAllTables(DataSource datasource) {
        Set<AbstractTable> tableSet = this.getAllTables();
        try {
            this.jdbcAdaptor.dropAllForeignKeys(datasource, tableSet);
            this.jdbcAdaptor.dropAllTables(datasource, tableSet);
            this.jdbcAdaptor.dropAllSequences(datasource, this.sequenceGenerators.values());
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot drop tables", (Throwable)e);
        }
    }

    public <X> EmbeddableTypeImpl<X> embeddable(Class<X> clazz) {
        return this.embeddables.get(clazz);
    }

    public <X> EntityTypeImpl<X> entity(Class<X> clazz) {
        return this.entities.get(clazz);
    }

    public <X> EntityTypeImpl<X> entity(String name) {
        return this.entitiesByName.get(name);
    }

    public void fireCallbacks(Object instance, EntityListenerMetadata.EntityListenerType type) {
        this.callbackManager.fireCallbacks(instance, type);
    }

    private Set<AbstractTable> getAllTables() {
        HashSet tableSet = Sets.newHashSet();
        for (EntityTypeImpl<?> entity : this.entities.values()) {
            AbstractTable table;
            for (EntityTable entityTable : entity.getTables()) {
                if (entityTable.getEntity() != entity) continue;
                tableSet.add(entityTable);
            }
            for (AssociationMappingImpl<?, ?, ?> associationMappingImpl : entity.getAssociations()) {
                table = associationMappingImpl.getJoinTable();
                if (table == null || table.getEntity() != entity) continue;
                tableSet.add(table);
            }
            for (PluralMappingEx<?, ?, ?> pluralMappingEx : entity.getMappingsPlural()) {
                if (pluralMappingEx.isAssociation() || (table = (AbstractTable)((Object)pluralMappingEx.getJoinTable())) == null) continue;
                tableSet.add(table);
            }
        }
        return tableSet;
    }

    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        HashSet set = Sets.newHashSet();
        set.addAll(this.embeddables.values());
        return set;
    }

    public Set<EntityType<?>> getEntities() {
        HashSet entities = Sets.newHashSet();
        for (EntityType entityType : this.entities.values()) {
            entities.add(entityType);
        }
        return entities;
    }

    public EntityTypeImpl<?> getEntity(Class<?> clazz) {
        EntityType entity = null;
        while (entity == null && clazz != Object.class && (entity = this.entity(clazz)) == null) {
            clazz = clazz.getSuperclass();
        }
        return entity;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.emf;
    }

    public Set<IdentifiableType<?>> getIdentifiables() {
        HashSet identifiables = Sets.newHashSet();
        identifiables.addAll(this.mappedSuperclasses.values());
        identifiables.addAll(this.entities.values());
        return identifiables;
    }

    public JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        HashSet managedTypes = Sets.newHashSet();
        managedTypes.addAll(this.embeddables.values());
        managedTypes.addAll(this.mappedSuperclasses.values());
        managedTypes.addAll(this.entities.values());
        return managedTypes;
    }

    public Map<String, NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.namedNativeQueries;
    }

    public Collection<NamedQueryMetadata> getNamedQueries() {
        return this.namedQueries.values();
    }

    public Long getNextSequence(String generator) {
        try {
            return this.sequenceQueues.get(generator).poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Unable to retrieve next sequence " + generator + " in allowed " + 60L + " seconds");
        }
    }

    public Long getNextTableValue(String generator) {
        try {
            return this.tableIdQueues.get(generator).poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Unable to retrieve next sequence " + generator + " in allowed " + 60L + " seconds");
        }
    }

    public SqlResultSetMappingMetadata getSqlResultSetMapping(String resultSetMapping) {
        return this.sqlResultSetMappings.get(resultSetMapping);
    }

    private String getTableDesc(AbstractTable table) {
        if (table instanceof JoinTable) {
            JoinTable joinTable = (JoinTable)table;
            Member member = joinTable.getSourceKey().getMapping().getJavaMember();
            String memberDesc = member.getDeclaringClass() + "." + member.getName();
            return "JoinTable[" + joinTable.getName() + " " + memberDesc + "]";
        }
        if (table instanceof CollectionTable) {
            CollectionTable collectionTable = (CollectionTable)table;
            Member member = collectionTable.getMapping().getJavaMember();
            String memberDesc = member.getDeclaringClass() + "." + member.getName();
            return "CollectionTable[" + collectionTable.getName() + " " + memberDesc + "]";
        }
        if (table instanceof SecondaryTable) {
            SecondaryTable secondaryTable = (SecondaryTable)table;
            return "SecondaryTable[" + secondaryTable.getName() + " " + secondaryTable.getEntity().getJavaType().getName() + "]";
        }
        SecondaryTable entityTable = (SecondaryTable)table;
        return "EntityTable[" + entityTable.getName() + " " + entityTable.getEntity().getJavaType().getName() + "]";
    }

    private void initStaticMetamodel(ManagedTypeImpl<?> type, Class<?> clazz) {
        for (Attribute<?, ?> attribute : type.getAttributes()) {
            try {
                Field declaredField = clazz.getDeclaredField(attribute.getName());
                declaredField.set(null, attribute);
            }
            catch (NoSuchFieldException e) {
                LOG.debug("StaticMetamodel class has a missing field : {0}", attribute.getName());
            }
            catch (SecurityException e) {
                LOG.debug(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                LOG.debug(e.getMessage());
            }
            catch (IllegalAccessException e) {
                LOG.debug(e.getMessage());
            }
        }
    }

    public void initStaticMetamodels() {
        for (ManagedType<?> type : this.getManagedTypes()) {
            Class entityClass = type.getJavaType();
            String staticMetamodelClassName = entityClass.getName() + "_";
            try {
                Class<?> clazz = this.emf.getClassloader().loadClass(staticMetamodelClassName);
                if (!clazz.isAnnotationPresent(StaticMetamodel.class)) continue;
                this.initStaticMetamodel((ManagedTypeImpl)type, clazz);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("StaticMetamodel not present for {0}", staticMetamodelClassName);
            }
        }
    }

    private synchronized <X> BasicTypeImpl<X> lazyCreateBasicType(Class<X> clazz) {
        if (clazz.getAnnotation(Entity.class) != null || clazz.getAnnotation(MappedSuperclass.class) != null || clazz.getAnnotation(Embeddable.class) != null) {
            return null;
        }
        if (Serializable.class.isAssignableFrom(clazz) || clazz.isPrimitive() || Number.class == clazz) {
            BasicTypeImpl<X> basicType = new BasicTypeImpl<X>(this, clazz);
            this.basics.put(clazz, basicType);
            return basicType;
        }
        return null;
    }

    public <X> ManagedTypeImpl<X> managedType(Class<X> clazz) {
        ManagedTypeImpl managedType = this.embeddables.get(clazz);
        if (managedType != null) {
            return managedType;
        }
        managedType = this.mappedSuperclasses.get(clazz);
        if (managedType != null) {
            return managedType;
        }
        return this.entities.get(clazz);
    }

    public void performForeignKeysDdl(DataSource datasource, DDLMode ddlMode, EntityTypeImpl<?> entity) {
        AbstractTable table;
        if (ddlMode == DDLMode.NONE) {
            return;
        }
        LOG.info("Performing foreign key DDL operations for entiy {0}, mode {1}", new Object[]{entity.getName(), ddlMode});
        for (EntityTable entityTable : entity.getTables()) {
            if (entityTable.getEntity() != entity) continue;
            LOG.info("Performing foreign key DDL operations for table {0}, mode {1}", new Object[]{entityTable.getQName(), ddlMode});
            for (ForeignKey foreignKey : entityTable.getForeignKeys()) {
                this.jdbcAdaptor.createForeignKey(datasource, foreignKey);
            }
        }
        for (AssociationMappingImpl<?, ?, ?> associationMappingImpl : entity.getAssociations()) {
            table = associationMappingImpl.getJoinTable();
            if (table == null || ((JoinTable)table).getEntity() != entity) continue;
            LOG.info("Performing foreign key DDL operations for join table {0}, mode {1}", new Object[]{table.getQName(), ddlMode});
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                this.jdbcAdaptor.createForeignKey(datasource, foreignKey);
            }
        }
        for (PluralMappingEx<?, ?, ?> pluralMappingEx : entity.getMappingsPlural()) {
            if (pluralMappingEx.isAssociation()) continue;
            table = (AbstractTable)((Object)pluralMappingEx.getJoinTable());
            LOG.info("Performing foreign key DDL operations for join table {0}, mode {1}", new Object[]{table.getQName(), ddlMode});
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                this.jdbcAdaptor.createForeignKey(datasource, foreignKey);
            }
        }
    }

    public void performSequencesDdl(DataSource datasource, DDLMode ddlMode) {
        if (ddlMode == DDLMode.NONE) {
            return;
        }
        for (SequenceGenerator sequenceGenerator : this.sequenceGenerators.values()) {
            LOG.info("Performing DDL operations for sequence generators for {0}, mode {1}", new Object[]{sequenceGenerator.getName(), ddlMode});
            this.jdbcAdaptor.createSequenceIfNecessary(datasource, sequenceGenerator);
        }
    }

    public void performTableGeneratorsDdl(DataSource datasource, DDLMode ddlMode) {
        if (ddlMode == DDLMode.NONE) {
            return;
        }
        for (TableGenerator tableGenerator : this.tableGenerators.values()) {
            LOG.info("Performing DDL operations for sequence generators for mode table {1}, mode {0}", new Object[]{tableGenerator.getName(), ddlMode});
            this.jdbcAdaptor.createTableGeneratorIfNecessary(datasource, tableGenerator);
        }
    }

    public void performTablesDdl(DataSource datasource, DDLMode ddlMode, EntityTypeImpl<?> entity) {
        AbstractTable table;
        LOG.info("Performing DDL operations for entity {0}, mode {1}", new Object[]{entity.getName(), ddlMode});
        for (EntityTable entityTable : entity.getTables()) {
            if (entityTable.getEntity() != entity) continue;
            LOG.info("Performing DDL operations for {0}, mode {1}", new Object[]{entityTable.getQName(), ddlMode});
            this.jdbcAdaptor.createOrUpdateTable(entityTable, datasource, ddlMode);
        }
        for (AssociationMappingImpl<?, ?, ?> associationMappingImpl : entity.getAssociations()) {
            table = associationMappingImpl.getJoinTable();
            if (table == null || table.getEntity() != entity) continue;
            this.jdbcAdaptor.createOrUpdateTable(associationMappingImpl.getJoinTable(), datasource, ddlMode);
        }
        for (PluralMappingEx<?, ?, ?> pluralMappingEx : entity.getMappingsPlural()) {
            if (pluralMappingEx.isAssociation()) continue;
            table = (AbstractTable)((Object)pluralMappingEx.getJoinTable());
            this.jdbcAdaptor.createOrUpdateTable(table, datasource, ddlMode);
        }
    }

    public void preFillGenerators(DataSource datasource) {
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.idGeneratorExecuter = new ThreadPoolExecutor(1, nThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new GeneratorThreadFactory());
        for (SequenceGenerator sequenceGenerator : this.sequenceGenerators.values()) {
            this.sequenceQueues.put(sequenceGenerator.getName(), new SequenceQueue(this.jdbcAdaptor, datasource, this.idGeneratorExecuter, sequenceGenerator.getSequenceName(), sequenceGenerator.getAllocationSize()));
        }
        for (TableGenerator tableGenerator : this.tableGenerators.values()) {
            this.tableIdQueues.put(tableGenerator.getName(), new TableIdQueue(this.jdbcAdaptor, datasource, this.idGeneratorExecuter, tableGenerator));
        }
    }

    public void stopIdGenerators() {
        this.idGeneratorExecuter.shutdownNow();
        try {
            this.idGeneratorExecuter.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <X> TypeImpl<X> type(Class<X> clazz) {
        BasicTypeImpl<?> basic = this.basics.get(clazz);
        if (basic != null) {
            return basic;
        }
        return this.managedType((Class)clazz);
    }

    public CallbackAvailability updateAvailability(CallbackAvailability availability) {
        return availability.updateAvailability(this.callbackManager);
    }

    private static class GeneratorThreadFactory
    implements ThreadFactory {
        private static volatile int nextThreadNo = 1;

        private GeneratorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Id Generator - " + nextThreadNo++);
            thread.setPriority(10);
            return thread;
        }
    }
}

