/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.attribute;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.model.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.CollectionAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.ListAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.SetAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.metadata.attribute.AttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.AttributeMetadata;

public abstract class PluralAttributeImpl<X, C, E>
extends AttributeImpl<X, C>
implements PluralAttribute<X, C, E> {
    private final Class<E> bindableJavaType;
    private final Attribute.PersistentAttributeType attributeType;
    private final boolean association;
    private TypeImpl<E> type;

    public static <X> PluralAttributeImpl<X, ?, ?> create(ManagedTypeImpl<X> declaringType, AttributeMetadata metadata, Attribute.PersistentAttributeType attributeType) {
        Member member = ((AttributeMetadataImpl)metadata).getMember();
        Class<?> type = member instanceof Field ? ((Field)member).getType() : ((Method)member).getReturnType();
        if (List.class == type) {
            return new ListAttributeImpl(declaringType, metadata, attributeType);
        }
        if (Set.class == type) {
            return new SetAttributeImpl(declaringType, metadata, attributeType);
        }
        if (Collection.class == type) {
            return new CollectionAttributeImpl(declaringType, metadata, attributeType);
        }
        if (Map.class == type) {
            return new MapAttributeImpl(declaringType, metadata, attributeType);
        }
        throw new MappingException("Cannot determine collection type for " + type, metadata.getLocator());
    }

    public PluralAttributeImpl(ManagedTypeImpl<X> declaringType, AttributeMetadata metadata, Attribute.PersistentAttributeType attributeType, int valueIndexNo) {
        super(declaringType, metadata);
        this.attributeType = attributeType;
        if (metadata instanceof AssociationAttributeMetadata && StringUtils.isNotBlank((String)((AssociationAttributeMetadata)metadata).getTargetEntity())) {
            try {
                ClassLoader classloader = declaringType.getMetamodel().getEntityManagerFactory().getClassloader();
                this.bindableJavaType = classloader.loadClass(((AssociationAttributeMetadata)metadata).getTargetEntity());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Target entity class not found", metadata.getLocator());
            }
        } else {
            this.bindableJavaType = ReflectHelper.getGenericType(this.getJavaMember(), valueIndexNo);
        }
        this.association = attributeType != Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    public Attribute.PersistentAttributeType getAttributeType() {
        return this.attributeType;
    }

    public final Class<E> getBindableJavaType() {
        return this.bindableJavaType;
    }

    public final Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    public TypeImpl<E> getElementType() {
        if (this.type != null) {
            return this.type;
        }
        MetamodelImpl metamodel = this.getDeclaringType().getMetamodel();
        switch (this.attributeType) {
            case ONE_TO_MANY: 
            case MANY_TO_MANY: {
                this.type = metamodel.entity(this.bindableJavaType);
                return this.type;
            }
        }
        this.type = metamodel.embeddable(this.bindableJavaType) != null ? metamodel.embeddable(this.bindableJavaType) : metamodel.createBasicType(this.bindableJavaType);
        return this.type;
    }

    public final Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.attributeType;
    }

    public final boolean isAssociation() {
        return this.association;
    }

    public final boolean isCollection() {
        return true;
    }

    public abstract C newCollection(PluralMappingEx<?, C, E> var1, ManagedInstance<?> var2, boolean var3);

    public abstract C newCollection(PluralMappingEx<?, C, E> var1, ManagedInstance<?> var2, Object var3);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
            builder.append("element-collection");
        } else {
            builder.append("association ");
            switch (this.getCollectionType()) {
                case COLLECTION: {
                    builder.append("collection");
                    break;
                }
                case LIST: {
                    builder.append("list");
                    break;
                }
                case MAP: {
                    builder.append("map");
                    break;
                }
                case SET: {
                    builder.append("set");
                }
            }
        }
        String declaringType = this.getDeclaringType().getJavaType().getSimpleName();
        String type = this.getBindableJavaType().getSimpleName();
        builder.append(" ").append(declaringType).append(".").append(this.getName()).append("(").append(type).append(")");
        return builder.toString();
    }
}

