/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import java.sql.Connection;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.SecondaryTable;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.mapping.AssociationMapping;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.jdbc.model.EntityTypeDescriptor;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;

public class JoinColumn
extends AbstractColumn {
    private final JdbcAdaptor jdbcAdaptor;
    private AbstractTable table;
    private String name;
    private String referencedColumnName;
    private final String tableName;
    private final boolean insertable;
    private final boolean nullable;
    private final boolean unique;
    private final boolean updatable;
    private String columnDefinition;
    private int length;
    private int precision;
    private int sqlType;
    private int scale;
    private AssociationMapping<?, ?, ?> mapping;
    private AbstractColumn referencedColumn;
    private AbstractColumn masterColumn;

    public JoinColumn(JdbcAdaptor jdbcAdaptor, AssociationMapping<?, ?, ?> mapping, AbstractColumn referencedColumn, BasicColumn masterColumn) {
        super(null, false);
        this.jdbcAdaptor = jdbcAdaptor;
        this.mapping = mapping;
        this.columnDefinition = "";
        this.tableName = "";
        this.insertable = true;
        this.nullable = true;
        this.unique = false;
        this.updatable = true;
        this.name = masterColumn.getName();
        this.masterColumn = masterColumn;
        this.setColumnProperties(mapping, referencedColumn, false);
    }

    public JoinColumn(JdbcAdaptor jdbcAdaptor, AssociationMapping<?, ?, ?> mapping, AbstractColumn referencedColumn, boolean id) {
        super(null, id);
        this.jdbcAdaptor = jdbcAdaptor;
        this.mapping = mapping;
        this.columnDefinition = "";
        this.tableName = "";
        this.insertable = true;
        this.nullable = true;
        this.unique = false;
        this.updatable = true;
        this.setColumnProperties(mapping, referencedColumn, id);
    }

    public JoinColumn(JdbcAdaptor jdbcAdaptor, JoinColumnMetadata metadata, boolean readOnly) {
        super(metadata.getLocator(), false);
        this.jdbcAdaptor = jdbcAdaptor;
        this.referencedColumnName = metadata.getReferencedColumnName();
        this.columnDefinition = metadata.getColumnDefinition();
        this.tableName = metadata.getTable();
        this.name = metadata.getName();
        this.insertable = !readOnly && metadata.isInsertable();
        this.nullable = metadata.isNullable();
        this.unique = metadata.isUnique();
        this.updatable = !readOnly && metadata.isUpdatable();
    }

    public JoinColumn(JdbcAdaptor jdbcAdaptor, PrimaryKeyJoinColumnMetadata metadata, SecondaryTable table, AbstractColumn referencedColumn) {
        super(metadata != null ? metadata.getLocator() : null, true);
        this.jdbcAdaptor = jdbcAdaptor;
        this.tableName = table.getName();
        this.referencedColumnName = referencedColumn.getName();
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : referencedColumn.getColumnDefinition();
        this.name = metadata != null ? jdbcAdaptor.escape(metadata.getName()) : referencedColumn.getName();
        this.insertable = true;
        this.nullable = false;
        this.unique = false;
        this.updatable = false;
        this.setColumnProperties(referencedColumn);
        this.setTable(table);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Mapping<?, ?, ?> getMapping() {
        return this.mapping;
    }

    public AbstractColumn getMasterColumn() {
        return this.masterColumn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    public AbstractColumn getReferencedColumn() {
        return this.referencedColumn;
    }

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public AbstractTable getReferencedTable() {
        return this.referencedColumn.getTable();
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Object getValue(Connection connection, Object instance) {
        Object value = this.mapping != null ? this.mapping.get(instance) : instance;
        return value != null ? this.referencedColumn.getValue(connection, value) : null;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean isVirtual() {
        return this.masterColumn != null;
    }

    private void setColumnProperties(AbstractColumn referencedColumn) {
        this.referencedColumn = referencedColumn;
        this.referencedColumnName = referencedColumn.getName();
        this.columnDefinition = referencedColumn.getColumnDefinition();
        this.sqlType = referencedColumn.getSqlType();
        this.length = referencedColumn.getLength();
        this.precision = referencedColumn.getPrecision();
        this.scale = referencedColumn.getScale();
    }

    public void setColumnProperties(AssociationMapping<?, ?, ?> mapping, AbstractColumn referencedColumn, AbstractColumn masterColumn) {
        this.masterColumn = masterColumn;
        if (mapping != null) {
            this.mapping = mapping;
            if (StringUtils.isBlank((String)this.name)) {
                this.name = this.jdbcAdaptor.escape(mapping.getName() + "_" + referencedColumn.getName());
            }
        } else {
            EntityTypeDescriptor type = (EntityTypeDescriptor)referencedColumn.getMapping().getRoot().getTypeDescriptor();
            if (StringUtils.isBlank((String)this.name)) {
                this.name = this.jdbcAdaptor.escape(type.getName() + "_" + referencedColumn.getName());
            }
        }
        this.setColumnProperties(referencedColumn);
    }

    public void setColumnProperties(AssociationMapping<?, ?, ?> mapping, AbstractColumn referencedColumn, boolean id) {
        if (mapping != null) {
            this.mapping = mapping;
            if (StringUtils.isBlank((String)this.name)) {
                this.name = this.jdbcAdaptor.escape(mapping.getName() + "_" + referencedColumn.getName());
            }
        } else {
            EntityTypeDescriptor type = (EntityTypeDescriptor)referencedColumn.getMapping().getRoot().getTypeDescriptor();
            if (StringUtils.isBlank((String)this.name)) {
                this.name = this.jdbcAdaptor.escape(type.getName() + "_" + referencedColumn.getName());
            }
        }
        if (id) {
            super.setId();
        }
        this.setColumnProperties(referencedColumn);
    }

    @Override
    public void setTable(AbstractTable table) {
        this.table = table;
        if (!this.isVirtual()) {
            this.table.addColumn(this);
        }
    }

    @Override
    public void setValue(Object instance, Object value) {
        if (this.mapping != null) {
            this.mapping.set(instance, value);
        }
    }

    public void setVirtual(AbstractColumn masterColumn) {
        this.masterColumn = masterColumn;
    }

    @Override
    public String toString() {
        String tableName = this.getTable() != null ? this.getTable().getName() : "N/A";
        String mapping = this.getMapping() != null ? " " + this.getMapping().toString() + " " : "";
        return this.getClass().getSimpleName() + mapping + " [name=" + this.getName() + ", type=" + this.getSqlType() + ", length=" + this.getLength() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", table=" + tableName + ", refrencedColumn=" + this.referencedColumn + "]";
    }
}

