/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc.adapter;

import com.google.common.base.Joiner;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.GenerationType;
import javax.persistence.LockModeType;
import javax.sql.DataSource;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.jdbc.generator.SequenceGenerator;

public class DerbyAdaptor
extends JdbcAdaptor {
    private static final String[] PRODUCT_NAMES = new String[]{"Apache Derby"};

    @Override
    public String applyConcat(List<String> arguments) {
        return Joiner.on((String)" || ").join(arguments);
    }

    @Override
    public String applyLikeEscape(String escapePattern) {
        return " {ESCAPE " + escapePattern + "}";
    }

    @Override
    public String applyLock(String sql, LockModeType lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: 
            case PESSIMISTIC_READ: {
                return sql + "\nFOR READ ONLY";
            }
            case PESSIMISTIC_WRITE: {
                return sql + "\nFOR UPDATE";
            }
        }
        return sql;
    }

    @Override
    public String applyPagination(String sql, int startPosition, int maxResult) {
        if (startPosition != 0) {
            sql = sql + "\nOFFSET ? ROWS";
        }
        if (maxResult != Integer.MAX_VALUE) {
            sql = sql + "\nFETCH FIRST ? ROWS ONLY";
        }
        return sql;
    }

    @Override
    public String createColumnDDL(AbstractColumn column) {
        boolean identity = column.getIdType() == IdType.IDENTITY;
        return column.getName() + " " + this.getColumnType(column, column.getSqlType()) + (!column.isNullable() ? " NOT NULL" : "") + (column.isUnique() ? " UNIQUE" : "") + (identity ? " GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)" : "");
    }

    @Override
    public void createSequenceIfNecessary(DataSource datasource, SequenceGenerator sequence) {
        try {
            String sql = "CREATE SEQUENCE " + sequence.getQName() + " START WITH " + sequence.getInitialValue() + " INCREMENT BY " + sequence.getAllocationSize();
            new QueryRunner(datasource).update(sql);
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create sequence" + sequence.getSequenceName());
        }
    }

    @Override
    protected void dropSequence(QueryRunner runner, SequenceGenerator sequence) throws SQLException {
        runner.update("DROP SEQUENCE " + sequence.getQName() + " RESTRICT");
    }

    @Override
    protected String getDatabaseName() {
        return "Derby";
    }

    @Override
    public long getNextSequence(DataSource datasource, String sequenceName) throws SQLException {
        return ((Number)new QueryRunner(datasource).query("VALUES (NEXT VALUE FOR " + sequenceName + ")", new SingleValueHandler())).longValue();
    }

    @Override
    public JdbcAdaptor.PaginationParamsOrder getPaginationParamsOrder() {
        return JdbcAdaptor.PaginationParamsOrder.SQL_START_MAX;
    }

    @Override
    protected String[] getProductNames() {
        return PRODUCT_NAMES;
    }

    @Override
    public String getSelectLastIdentitySql(BasicColumn identityColumn) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    @Override
    protected boolean isForeignKeyHasDefaultIndex() {
        return true;
    }

    @Override
    public boolean modifiesParameters() {
        return true;
    }

    @Override
    public void modifyParameters(ParameterMetaData metadata, Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null || !(param instanceof Character)) continue;
            params[i] = ((Character)param).toString();
        }
    }

    @Override
    public boolean paginationNeedsMaxResultsAlways() {
        return false;
    }

    @Override
    public boolean paginationNeedsStartAlways() {
        return false;
    }

    @Override
    public IdType supports(GenerationType type) {
        if (type == null) {
            return IdType.SEQUENCE;
        }
        switch (type) {
            case IDENTITY: {
                return IdType.IDENTITY;
            }
            case SEQUENCE: {
                return IdType.SEQUENCE;
            }
            case TABLE: {
                return IdType.TABLE;
            }
        }
        return IdType.SEQUENCE;
    }
}

