/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.batoo.common.BatooException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.parser.persistence.Persistence;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private static final BLogger LOG = BLoggerFactory.getLogger(PersistenceUnitInfoImpl.class);
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private final boolean excludeUnlistedClasses;
    private final List<URL> jarFiles;
    private final DataSource jtaDataSource;
    private final List<String> managedClassNames;
    private final List<String> mappingFileNames;
    private final DataSource nonJtaDataSource;
    private final String persistenceProviderClassName;
    private final String persistenceUnitName;
    private final URL persistenceUnitRootUrl;
    private final Properties properties;
    private final SharedCacheMode sharedCacheMode;
    private final PersistenceUnitTransactionType transactionType;
    private final ValidationMode validationMode;

    public PersistenceUnitInfoImpl(String puName) {
        Object[] pair = this.createPersistenceUnit(puName);
        this.persistenceUnitRootUrl = (URL)pair[0];
        Persistence.PersistenceUnit pu = (Persistence.PersistenceUnit)pair[1];
        this.jarFiles = this.createJarFiles(pu);
        this.jtaDataSource = this.createDatasource(pu.getJtaDataSource());
        this.managedClassNames = pu.getClazzs();
        this.excludeUnlistedClasses = this.createExcludeUnlistedProperties(pu);
        this.mappingFileNames = pu.getMappingFiles();
        this.nonJtaDataSource = this.createDatasource(pu.getNonJtaDataSource());
        this.persistenceProviderClassName = pu.getProvider();
        this.persistenceUnitName = puName;
        this.sharedCacheMode = this.createSharedCacheMode(pu);
        this.transactionType = this.createTransactionType(pu);
        this.validationMode = this.createValidationMode(pu);
        this.properties = this.createProperties(pu);
    }

    public void addTransformer(ClassTransformer transformer) {
    }

    private DataSource createDatasource(String jndiName) {
        if (jndiName == null) {
            return null;
        }
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new PersistenceException("Cannot lookup datasource: " + jndiName);
        }
    }

    private boolean createExcludeUnlistedProperties(Persistence.PersistenceUnit pu) {
        return pu.isExcludeUnlistedClasses() != null ? pu.isExcludeUnlistedClasses() : !this.managedClassNames.isEmpty();
    }

    private List<URL> createJarFiles(Persistence.PersistenceUnit pu) {
        return Lists.transform(pu.getJarFiles(), (Function)new Function<String, URL>(){

            public URL apply(String input) {
                try {
                    return new URL(input);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object[] createPersistenceUnit(String puName) {
        try {
            LOG.info("Loading persistence.xml");
            Enumeration<URL> resources = this.classLoader.getResources("META-INF/persistence.xml");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Persistence.PersistenceUnit unit = this.findPersistence(puName, url);
                if (unit == null) continue;
                return new Object[]{new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile().substring(0, url.getFile().length() - "META-INF/persistence.xml".length() - 1)), unit};
            }
        }
        catch (Exception e) {
            throw new BatooException("Unable to parse persistence.xml", e);
        }
        throw new BatooException("Persistence unit " + puName + " not found.");
    }

    private Properties createProperties(Persistence.PersistenceUnit pu) {
        Properties properties = new Properties();
        if (pu.getProperties() != null) {
            for (Persistence.PersistenceUnit.Properties.Property property : pu.getProperties().getProperties()) {
                properties.put(property.getName(), property.getValue());
            }
        }
        return properties;
    }

    private SharedCacheMode createSharedCacheMode(Persistence.PersistenceUnit pu) {
        if (pu.getSharedCacheMode() == null) {
            return SharedCacheMode.NONE;
        }
        switch (pu.getSharedCacheMode()) {
            case ALL: {
                return SharedCacheMode.ALL;
            }
            case DISABLE_SELECTIVE: {
                return SharedCacheMode.DISABLE_SELECTIVE;
            }
            case ENABLE_SELECTIVE: {
                return SharedCacheMode.ENABLE_SELECTIVE;
            }
            case UNSPECIFIED: {
                return SharedCacheMode.UNSPECIFIED;
            }
        }
        return SharedCacheMode.NONE;
    }

    private PersistenceUnitTransactionType createTransactionType(Persistence.PersistenceUnit pu) {
        if (pu.getTransactionType() == null) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        switch (pu.getTransactionType()) {
            case JTA: {
                return PersistenceUnitTransactionType.JTA;
            }
        }
        return PersistenceUnitTransactionType.RESOURCE_LOCAL;
    }

    private ValidationMode createValidationMode(Persistence.PersistenceUnit pu) {
        if (pu.getValidationMode() == null) {
            return ValidationMode.NONE;
        }
        switch (pu.getValidationMode()) {
            case AUTO: {
                return ValidationMode.AUTO;
            }
            case CALLBACK: {
                return ValidationMode.CALLBACK;
            }
        }
        return ValidationMode.NONE;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    private Persistence.PersistenceUnit findPersistence(String puName, URL url) {
        try {
            InputStream is = url.openStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Persistence.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Persistence persistence = (Persistence)unmarshaller.unmarshal(is);
            for (Persistence.PersistenceUnit persistenceUnit : persistence.getPersistenceUnits()) {
                if (!puName.equals(persistenceUnit.getName())) continue;
                return persistenceUnit;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error(e, "Cannot read persistence.xml at location {0}", url);
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<URL> getJarFileUrls() {
        return Collections.unmodifiableList(this.jarFiles);
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public List<String> getManagedClassNames() {
        return Collections.unmodifiableList(this.managedClassNames);
    }

    public List<String> getMappingFileNames() {
        return Collections.unmodifiableList(this.mappingFileNames);
    }

    public ClassLoader getNewTempClassLoader() {
        return this.classLoader;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public String getPersistenceXMLSchemaVersion() {
        return "2.0";
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        return properties;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }
}

