/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.persistence.NamedNativeQuery;
import javax.persistence.QueryHint;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.metadata.NamedNativeQueryMetadata;

public class NamedNativeQueryMetadataImpl
implements NamedNativeQueryMetadata {
    private final AbstractLocator locator;
    private final String query;
    private final String name;
    private final Map<String, Object> hints = Maps.newHashMap();
    private final String resultClass;
    private final String resultSetMapping;

    public NamedNativeQueryMetadataImpl(AbstractLocator locator, NamedNativeQuery annotation) {
        this.locator = locator;
        this.name = annotation.name();
        this.query = annotation.query();
        this.resultClass = annotation.resultClass().getName();
        this.resultSetMapping = annotation.resultSetMapping();
        for (QueryHint hint : annotation.hints()) {
            this.hints.put(hint.name(), hint.value());
        }
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }
}

