/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.UniqueConstraint;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.PrimaryKeyJoinColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.UniqueConstraintMetadataImpl;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;
import org.batoo.jpa.parser.metadata.SecondaryTableMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public class SecondaryTableMetadataImpl
implements SecondaryTableMetadata {
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private final String name;
    private final List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns = Lists.newArrayList();
    private final List<UniqueConstraintMetadata> uniqueConstraints = Lists.newArrayList();

    public SecondaryTableMetadataImpl(AbstractLocator locator, SecondaryTable annotation) {
        this.locator = locator;
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.name = annotation.name();
        for (UniqueConstraint uniqueConstraint : annotation.uniqueConstraints()) {
            this.uniqueConstraints.add(new UniqueConstraintMetadataImpl(locator, uniqueConstraint));
        }
        for (UniqueConstraint uniqueConstraint : annotation.pkJoinColumns()) {
            this.primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadataImpl(this.locator, (PrimaryKeyJoinColumn)uniqueConstraint));
        }
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumnMetadata() {
        return this.primaryKeyJoinColumns;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.uniqueConstraints;
    }
}

