/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.UniqueConstraintMetadataImpl;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public class TableGeneratorMetadataImpl
implements TableGeneratorMetadata {
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private final String name;
    private final String pkColumnName;
    private final String pkColumnValue;
    private final String valueColumnName;
    private final int initialValue;
    private final int allocationSize;
    private final String table;
    private final List<UniqueConstraintMetadata> uniqueConstraints = Lists.newArrayList();

    public TableGeneratorMetadataImpl(AbstractLocator locator, TableGenerator annotation) {
        this.locator = locator;
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.table = annotation.table();
        this.name = annotation.name();
        this.pkColumnName = annotation.pkColumnName();
        this.pkColumnValue = annotation.pkColumnValue();
        this.valueColumnName = annotation.valueColumnName();
        this.initialValue = annotation.initialValue();
        this.allocationSize = annotation.allocationSize();
        for (UniqueConstraint constraint : annotation.uniqueConstraints()) {
            this.uniqueConstraints.add(new UniqueConstraintMetadataImpl(locator, constraint));
        }
    }

    @Override
    public int getAllocationSize() {
        return this.allocationSize;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPkColumnName() {
        return this.pkColumnName;
    }

    @Override
    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }
}

