/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import org.batoo.jpa.parser.impl.orm.AccessElement;
import org.batoo.jpa.parser.impl.orm.CatalogElement;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.EntityListenersElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.PersistenceUnitDefaults;
import org.batoo.jpa.parser.impl.orm.PersistenceUnitMetadataElement;
import org.batoo.jpa.parser.impl.orm.SchemaElement;
import org.batoo.jpa.parser.impl.orm.SequenceGeneratorElement;
import org.batoo.jpa.parser.impl.orm.TableGeneratorElement;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.Metadata;
import org.batoo.jpa.parser.metadata.NamedNativeQueryMetadata;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;
import org.batoo.jpa.parser.metadata.SequenceGeneratorMetadata;
import org.batoo.jpa.parser.metadata.SqlResultSetMappingMetadata;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.type.EmbeddableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;
import org.batoo.jpa.parser.metadata.type.MappedSuperclassMetadata;

public class EntityMappings
extends ParentElement
implements Metadata {
    private AccessType accessType = AccessType.FIELD;
    private boolean xmlMappingMetadataComplete;
    private String catalog;
    private String schema;
    private final List<SequenceGeneratorMetadata> sequenceGenerators = Lists.newArrayList();
    private final List<TableGeneratorMetadata> tableGenerators = Lists.newArrayList();
    private final List<NamedQueryMetadata> namedQueries = Lists.newArrayList();
    private final List<NamedNativeQueryMetadata> namedNativeQueries = Lists.newArrayList();
    private final List<SqlResultSetMappingMetadata> sqlResultSetMappings = Lists.newArrayList();
    private final List<EntityListenerMetadata> entityListeners = Lists.newArrayList();
    private final List<ManagedTypeMetadata> entities = Lists.newArrayList();
    private boolean cascadePersist;

    public EntityMappings(Map<String, String> attributes) {
        super(null, attributes, "access", "catalog", "schema", "persistence-unit-metadata", "sequence-generator", "table-generator", "entity", "mapped-superclass", "embeddable", "named-query", "named-native-query", "sql-result-set-mapping");
    }

    @Override
    public boolean cascadePersists() {
        return this.cascadePersist;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public List<EntityListenerMetadata> getEntityListeners() {
        return this.entityListeners;
    }

    @Override
    public List<ManagedTypeMetadata> getEntityMappings() {
        return this.entities;
    }

    @Override
    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.namedNativeQueries;
    }

    @Override
    public List<NamedQueryMetadata> getNamedQueries() {
        return this.namedQueries;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public List<SequenceGeneratorMetadata> getSequenceGenerators() {
        return this.sequenceGenerators;
    }

    @Override
    public List<SqlResultSetMappingMetadata> getSqlResultSetMapping() {
        return this.sqlResultSetMappings;
    }

    @Override
    public List<TableGeneratorMetadata> getTableGenerators() {
        return this.tableGenerators;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof AccessElement) {
            this.accessType = ((AccessElement)child).getAccessType();
        }
        if (child instanceof PersistenceUnitMetadataElement) {
            PersistenceUnitMetadataElement element = (PersistenceUnitMetadataElement)child;
            PersistenceUnitDefaults persistenceUnitDefaults = element.getPersistenceUnitDefaults();
            if (persistenceUnitDefaults != null) {
                this.accessType = persistenceUnitDefaults.getAccessType();
                this.catalog = persistenceUnitDefaults.getCatalog();
                this.schema = persistenceUnitDefaults.getSchema();
                this.cascadePersist = persistenceUnitDefaults.isCascadePersist();
                this.entityListeners.addAll(persistenceUnitDefaults.getListeners());
            }
            this.xmlMappingMetadataComplete = element.isXmlMappingMetadataComplete();
        }
        if (child instanceof CatalogElement) {
            this.catalog = ((CatalogElement)child).getCatalog();
        }
        if (child instanceof SchemaElement) {
            this.schema = ((SchemaElement)child).getSchema();
        }
        if (child instanceof SequenceGeneratorElement) {
            this.sequenceGenerators.add((SequenceGeneratorElement)child);
        }
        if (child instanceof TableGeneratorElement) {
            this.tableGenerators.add((TableGeneratorElement)child);
        }
        if (child instanceof EmbeddableMetadata) {
            this.entities.add((EmbeddableMetadata)((Object)child));
        }
        if (child instanceof MappedSuperclassMetadata) {
            this.entities.add((MappedSuperclassMetadata)((Object)child));
        }
        if (child instanceof EntityListenersElement) {
            this.entityListeners.addAll(((EntityListenersElement)child).getListeners());
        }
        if (child instanceof EntityMetadata) {
            this.entities.add((EntityMetadata)((Object)child));
        }
        if (child instanceof NamedQueryMetadata) {
            this.namedQueries.add((NamedQueryMetadata)((Object)child));
        }
        if (child instanceof NamedNativeQueryMetadata) {
            this.namedNativeQueries.add((NamedNativeQueryMetadata)((Object)child));
        }
        if (child instanceof SqlResultSetMappingMetadata) {
            this.sqlResultSetMappings.add((SqlResultSetMappingMetadata)((Object)child));
        }
    }

    @Override
    public boolean isXmlMappingMetadataComplete() {
        return this.xmlMappingMetadataComplete;
    }
}

