/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.api.java;

import htsjdk.samtools.ValidationStringency;
import java.io.Serializable;
import java.util.ArrayList;
import org.bdgenomics.adam.api.java.JavaADAMContext;
import org.bdgenomics.adam.api.java.JavaADAMCoverageConduit;
import org.bdgenomics.adam.api.java.JavaADAMFeatureConduit;
import org.bdgenomics.adam.api.java.JavaADAMFragmentConduit;
import org.bdgenomics.adam.api.java.JavaADAMGenotypeConduit;
import org.bdgenomics.adam.api.java.JavaADAMReadConduit;
import org.bdgenomics.adam.api.java.JavaADAMSequenceConduit;
import org.bdgenomics.adam.api.java.JavaADAMSliceConduit;
import org.bdgenomics.adam.api.java.JavaADAMVariantConduit;
import org.bdgenomics.adam.ds.ADAMContext;
import org.bdgenomics.adam.ds.ADAMContext$;
import org.bdgenomics.adam.ds.feature.CoverageDataset;
import org.bdgenomics.adam.ds.feature.FeatureDataset;
import org.bdgenomics.adam.ds.fragment.FragmentDataset;
import org.bdgenomics.adam.ds.read.AlignmentDataset;
import org.bdgenomics.adam.ds.sequence.SequenceDataset;
import org.bdgenomics.adam.ds.sequence.SliceDataset;
import org.bdgenomics.adam.ds.variant.GenotypeDataset;
import org.bdgenomics.adam.ds.variant.VariantDataset;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.util.ADAMFunSuite;
import org.bdgenomics.adam.util.ReferenceFile;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}1Aa\u0001\u0003\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017\t!\"*\u0019<b\u0003\u0012\u000bUjQ8oi\u0016DHoU;ji\u0016T!!\u0002\u0004\u0002\t)\fg/\u0019\u0006\u0003\u000f!\t1!\u00199j\u0015\tI!\"\u0001\u0003bI\u0006l'BA\u0006\r\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0003'!\tA!\u001e;jY&\u0011QC\u0005\u0002\r\u0003\u0012\u000bUJR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"!\u0007\u0001\u000e\u0003\u0011\t1A[1d+\u0005a\u0002CA\r\u001e\u0013\tqBAA\bKCZ\f\u0017\tR!N\u0007>tG/\u001a=u\u0001")
public class JavaADAMContextSuite
extends ADAMFunSuite {
    public JavaADAMContext jac() {
        return new JavaADAMContext(new ADAMContext(this.sc()));
    }

    public JavaADAMContextSuite() {
        this.sparkTest("can read and write a small .SAM file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("small.sam");
            AlignmentDataset aRdd = this.jac().loadAlignments(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)aRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right = 20;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            AlignmentDataset newRdd = JavaADAMReadConduit.conduit(aRdd, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 20;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        });
        this.sparkTest("loadIndexedBam with multiple ReferenceRegions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ReferenceRegion refRegion1 = new ReferenceRegion("chr2", 100L, 101L, ReferenceRegion$.MODULE$.apply$default$4());
            ReferenceRegion refRegion2 = new ReferenceRegion("3", 10L, 17L, ReferenceRegion$.MODULE$.apply$default$4());
            String path = this.testFile("indexed_bams/sorted.bam");
            ArrayList<ReferenceRegion> rrList = new ArrayList<ReferenceRegion>(2);
            rrList.add(refRegion1);
            rrList.add(refRegion2);
            AlignmentDataset reads = this.jac().loadIndexedBam(path, rrList, ValidationStringency.STRICT);
            long $org_scalatest_assert_macro_left = reads.rdd().count();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        });
        this.sparkTest("can read and write a small .SAM file as fragments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("small.sam");
            FragmentDataset aRdd = this.jac().loadFragments(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)aRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right = 20;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            FragmentDataset newRdd = JavaADAMFragmentConduit.conduit(aRdd, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 20;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        });
        this.sparkTest("can read and write a small .bed file as features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("gencode.v7.annotation.trunc10.bed");
            FeatureDataset aRdd = this.jac().loadFeatures(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)aRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            FeatureDataset newRdd = JavaADAMFeatureConduit.conduit(aRdd, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        });
        this.sparkTest("can read and write a small .bed file as coverage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("sample_coverage.bed");
            CoverageDataset aRdd = this.jac().loadCoverage(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)aRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            CoverageDataset newRdd = JavaADAMCoverageConduit.conduit(aRdd, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        });
        this.sparkTest("can read and write a small .vcf as genotypes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("small.vcf");
            GenotypeDataset aRdd = this.jac().loadGenotypes(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)aRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right = 18;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            GenotypeDataset newRdd = JavaADAMGenotypeConduit.conduit(aRdd, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 18;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        });
        this.sparkTest("can read and write a small .vcf as variants", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("small.vcf");
            VariantDataset aRdd = this.jac().loadVariants(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)aRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            VariantDataset newRdd = JavaADAMVariantConduit.conduit(aRdd, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 6;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        });
        this.sparkTest("can read a two bit file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("hg19.chrM.2bit");
            ReferenceFile refFile = this.jac().loadReferenceFile(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(refFile.extract(new ReferenceRegion("hg19_chrM", 16561L, 16571L, ReferenceRegion$.MODULE$.apply$default$4())));
            String $org_scalatest_assert_macro_right = "CATCACGATG";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        });
        this.sparkTest("can read and write .fa as sequences", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("trinity.fa");
            SequenceDataset sequences = this.jac().loadDnaSequences(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)sequences.jrdd().count()));
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            SequenceDataset newRdd = JavaADAMSequenceConduit.conduit(sequences, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        });
        this.sparkTest("can read and write .fa as slices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String path = this.copyResource("trinity.fa");
            SliceDataset slices = this.jac().loadSlices(path, Predef$.MODULE$.double2Double(10000.0));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)slices.jrdd().count()));
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            SliceDataset newRdd = JavaADAMSliceConduit.conduit(slices, ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)newRdd.jrdd().count()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JavaADAMContextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        });
    }
}

