/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import htsjdk.samtools.ValidationStringency;
import org.apache.parquet.filter2.dsl.Dsl;
import org.apache.parquet.filter2.dsl.Dsl$;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator$;
import org.bdgenomics.adam.cli.Transform$;
import org.bdgenomics.adam.cli.TransformArgs;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Filter$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDD;
import org.bdgenomics.adam.util.ReferenceFile;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.bdgenomics.utils.misc.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mu!B\u0001\u0003\u0011\u0003Y\u0011!\u0003+sC:\u001chm\u001c:n\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!!\u0003+sC:\u001chm\u001c:n'\ri\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]YR\"\u0001\r\u000b\u0005\rI\"B\u0001\u000e\u0007\u0003\u0015)H/\u001b7t\u0013\ta\u0002DA\nC\t\u001e\u001bu.\\7b]\u0012\u001cu.\u001c9b]&|g\u000eC\u0003\u001f\u001b\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9\u0011%\u0004b\u0001\n\u0003\u0011\u0013aC2p[6\fg\u000e\u001a(b[\u0016,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\"1A&\u0004Q\u0001\n\r\nAbY8n[\u0006tGMT1nK\u0002BqAL\u0007C\u0002\u0013\u0005!%\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007B\u0002\u0019\u000eA\u0003%1%A\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007\u0005C\u00033\u001b\u0011\u00051'A\u0003baBd\u0017\u0010F\u00025\u0003\u0013\u0003\"\u0001D\u001b\u0007\t9\u0011\u0001AN\n\u0005k]R\u0004\t\u0005\u0002%q%\u0011\u0011(\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007]YT(\u0003\u0002=1\ty!\tR$Ta\u0006\u00148nQ8n[\u0006tG\r\u0005\u0002\r}%\u0011qH\u0001\u0002\u000e)J\fgn\u001d4pe6\f%oZ:\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rK\u0012\u0001B7jg\u000eL!!\u0012\"\u0003\u000f1{wmZ5oO\"Aq)\u000eBC\u0002\u0013E\u0001*\u0001\u0003be\u001e\u001cX#A\u001f\t\u0011)+$\u0011!Q\u0001\nu\nQ!\u0019:hg\u0002BQAH\u001b\u0005\u00021#\"\u0001N'\t\u000b\u001d[\u0005\u0019A\u001f\t\u000f=+$\u0019!C\u0001!\u0006I1m\\7qC:LwN\\\u000b\u0002#:\u0011A\u0002\u0001\u0005\u0007'V\u0002\u000b\u0011B)\u0002\u0015\r|W\u000e]1oS>t\u0007\u0005C\u0004Vk\t\u0007I\u0011\u0001,\u0002\u0015M$(/\u001b8hK:\u001c\u00170F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0005tC6$xn\u001c7t\u0015\u0005a\u0016A\u00025ug*$7.\u0003\u0002_3\n!b+\u00197jI\u0006$\u0018n\u001c8TiJLgnZ3oGfDa\u0001Y\u001b!\u0002\u00139\u0016aC:ue&tw-\u001a8ds\u0002BQAY\u001b\u0005\n\r\f\u0001#\\1zE\u0016\u0014V\r]1si&$\u0018n\u001c8\u0015\u0005\u0011d\u0007CA3k\u001b\u00051'BA4i\u0003\u0011\u0011X-\u00193\u000b\u0005%$\u0011a\u0001:eI&\u00111N\u001a\u0002\u0013\u00032LwM\\7f]R\u0014VmY8sIJ#E\tC\u0003jC\u0002\u0007A\rC\u0003ok\u0011%q.A\u0006nCf\u0014W\rR3ekB,GC\u00013q\u0011\u0015IW\u000e1\u0001e\u0011\u0015\u0011X\u0007\"\u0003t\u00031i\u0017-\u001f2f%\u0016\fG.[4o)\u0011!GO`@\t\u000bU\f\b\u0019\u0001<\u0002\u0005M\u001c\u0007CA<}\u001b\u0005A(BA={\u0003\u0015\u0019\b/\u0019:l\u0015\tY\b\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003{b\u0014Ab\u00159be.\u001cuN\u001c;fqRDQ![9A\u0002\u0011Dq!!\u0001r\u0001\u0004\t\u0019!\u0001\u0002tYB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\na\fqa\u001d;pe\u0006<W-\u0003\u0003\u0002\u000e\u0005\u001d!\u0001D*u_J\fw-\u001a'fm\u0016d\u0007bBA\tk\u0011%\u00111C\u0001\u0011[\u0006L(-\u001a*fG\u0006d\u0017N\u0019:bi\u0016$R\u0001ZA\u000b\u0003/Aa![A\b\u0001\u0004!\u0007\u0002CA\u0001\u0003\u001f\u0001\r!a\u0001\t\u000f\u0005mQ\u0007\"\u0003\u0002\u001e\u0005iQ.Y=cK\u000e{\u0017\r\\3tG\u0016$2\u0001ZA\u0010\u0011\u0019I\u0017\u0011\u0004a\u0001I\"9\u00111E\u001b\u0005\n\u0005\u0015\u0012!C7bs\n,7k\u001c:u)\u0015!\u0017qEA\u0015\u0011\u0019I\u0017\u0011\u0005a\u0001I\"A\u0011\u0011AA\u0011\u0001\u0004\t\u0019\u0001C\u0004\u0002.U\"\t!a\f\u0002\u00155\f\u0017PY3NIR\u000bw\rF\u0004e\u0003c\t\u0019$!\u000e\t\rU\fY\u00031\u0001w\u0011\u0019I\u00171\u0006a\u0001I\"A\u0011qGA\u0016\u0001\u0004\tI$A\u0007tiJLgnZ3oGf|\u0005\u000f\u001e\t\u0005#\u0005mr+C\u0002\u0002>I\u0011aa\u00149uS>t\u0007B\u0002\u001a6\t\u0003\t\t\u0005F\u0002e\u0003\u0007Ba![A \u0001\u0004!\u0007bBA$k\u0011\u0005\u0011\u0011J\u0001\u0010M>\u00148-\u001a(p]B\u000b'/];fiR\u0011\u00111\n\t\u0004#\u00055\u0013bAA(%\t9!i\\8mK\u0006t\u0007bBA*k\u0011\u0005\u0011QK\u0001\rSNtuN\u001c)beF,X\r\u001e\u000b\u0005\u0003\u0017\n9\u0006\u0003\u0005\u0002Z\u0005E\u0003\u0019AA.\u0003%Ig\u000e];u!\u0006$\b\u000e\u0005\u0003\u0002^\u0005\rdbA\t\u0002`%\u0019\u0011\u0011\r\n\u0002\rA\u0013X\rZ3g\u0013\rQ\u0013Q\r\u0006\u0004\u0003C\u0012\u0002bBA5k\u0011\u0005\u00111N\u0001\u0004eVtG\u0003BA7\u0003g\u00022!EA8\u0013\r\t\tH\u0005\u0002\u0005+:LG\u000f\u0003\u0004v\u0003O\u0002\rA\u001e\u0005\b\u0003o*D\u0011BA=\u0003Q\u0019'/Z1uK.swn\u001e8T]B\u001cH+\u00192mKR!\u00111PAD!\u0011\ti(a!\u000e\u0005\u0005}$bAAA\t\u00051Qn\u001c3fYNLA!!\"\u0002\u0000\tA1K\u001c9UC\ndW\r\u0003\u0004v\u0003k\u0002\rA\u001e\u0005\b\u0003\u0017\u000b\u0004\u0019AAG\u0003\u001d\u0019W\u000e\u001a'j]\u0016\u0004R!EAH\u00037J1!!%\u0013\u0005\u0015\t%O]1z\u0001")
public class Transform
implements BDGSparkCommand<TransformArgs>,
Logging {
    private final TransformArgs args;
    private final Transform$ companion;
    private final ValidationStringency stringency;
    private transient Logger org$bdgenomics$utils$misc$Logging$$log_;

    public static void main(String[] stringArray) {
        Transform$.MODULE$.main(stringArray);
    }

    public static String commandDescription() {
        return Transform$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Transform$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger org$bdgenomics$utils$misc$Logging$$log_() {
        return this.org$bdgenomics$utils$misc$Logging$$log_;
    }

    public void org$bdgenomics$utils$misc$Logging$$log__$eq(Logger x$1) {
        this.org$bdgenomics$utils$misc$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public TransformArgs args() {
        return this.args;
    }

    public Transform$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private AlignmentRecordRDD maybeRepartition(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().repartition() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            alignmentRecordRDD = (AlignmentRecordRDD)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$1) {
                    int x$6 = this.$outer.args().repartition();
                    Ordering x$7 = x$1.repartition$default$2(x$6);
                    return x$1.repartition(x$6, x$7);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeDedupe(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().markDuplicates()) {
            this.log().info("Marking duplicates");
            alignmentRecordRDD = rdd.markDuplicates();
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeRealign(SparkContext sc, AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().locallyRealign()) {
            this.log().info("Locally realigning indels.");
            Object object = this.args().cache() ? rdd.rdd().persist(sl) : BoxedUnit.UNIT;
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsensusGenerator apply() {
                    return ConsensusGenerator$.MODULE$.fromReads();
                }
            }, (Function1)new Serializable(this, rdd){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordRDD rdd$1;

                public final ConsensusGenerator apply(String file) {
                    ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.rdd$1.rdd().context());
                    String x$8 = file;
                    Option x$9 = qual$1.loadVariants$default$2();
                    ValidationStringency x$10 = qual$1.loadVariants$default$3();
                    return ConsensusGenerator$.MODULE$.fromKnownIndels(qual$1.loadVariants(x$8, x$9, x$10), ConsensusGenerator$.MODULE$.fromKnownIndels$default$2());
                }
                {
                    this.rdd$1 = rdd$1;
                }
            });
            Option optReferenceFile = Option$.MODULE$.apply((Object)this.args().reference()).map((Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;
                private final SparkContext sc$1;

                public final ReferenceFile apply(String f) {
                    return ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$1).loadReferenceFile(f, this.$outer.args().mdTagsFragmentSize());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.sc$1 = sc$1;
                }
            });
            AlignmentRecordRDD realignmentRdd = rdd.realignIndels(consensusGenerator, false, this.args().maxIndelSize(), this.args().maxConsensusNumber(), this.args().lodThreshold(), this.args().maxTargetSize(), this.args().maxReadsPerTarget(), optReferenceFile, this.args().unclipReads());
            Object object2 = this.args().cache() ? rdd.rdd().unpersist(rdd.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordRDD = realignmentRdd;
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeRecalibrate(AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().recalibrateBaseQualities()) {
            AlignmentRecordRDD bqsredRdd;
            this.log().info("Recalibrating base qualities");
            None$ optSl = this.args().cache() ? new Some((Object)sl) : None$.MODULE$;
            SnpTable knownSnps = this.createKnownSnpsTable(rdd.rdd().context());
            Broadcast broadcastedSnps = (Broadcast)Timers$.MODULE$.BroadcastingKnownSnps().time((Function0)new Serializable(this, rdd, knownSnps){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordRDD rdd$2;
                private final SnpTable knownSnps$1;

                public final Broadcast<SnpTable> apply() {
                    return this.rdd$2.rdd().context().broadcast((Object)this.knownSnps$1, ClassTag$.MODULE$.apply(SnpTable.class));
                }
                {
                    this.rdd$2 = rdd$2;
                    this.knownSnps$1 = knownSnps$1;
                }
            });
            alignmentRecordRDD = bqsredRdd = rdd.recalibrateBaseQualities(broadcastedSnps, this.args().minAcceptableQuality(), (Option)optSl);
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeCoalesce(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().coalesce() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            alignmentRecordRDD = this.args().coalesce() > rdd.rdd().partitions().length || this.args().forceShuffle() ? (AlignmentRecordRDD)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$2) {
                    int x$11 = this.$outer.args().coalesce();
                    boolean x$12 = true;
                    Option x$13 = x$2.coalesce$default$3();
                    Ordering x$14 = x$2.coalesce$default$4(x$11, x$12, x$13);
                    return x$2.coalesce(x$11, x$12, x$13, x$14);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }) : (AlignmentRecordRDD)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$3) {
                    int x$15 = this.$outer.args().coalesce();
                    boolean x$16 = false;
                    Option x$17 = x$3.coalesce$default$3();
                    Ordering x$18 = x$3.coalesce$default$4(x$15, x$16, x$17);
                    return x$3.coalesce(x$15, x$16, x$17, x$18);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    /*
     * WARNING - void declaration
     */
    private AlignmentRecordRDD maybeSort(AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().sortReads()) {
            void var3_3;
            Object object = this.args().cache() ? rdd.rdd().persist(sl) : BoxedUnit.UNIT;
            this.log().info("Sorting reads");
            AlignmentRecordRDD sortedRdd = this.args().sortLexicographically() ? rdd.sortReadsByReferencePosition() : rdd.sortReadsByReferencePositionAndIndex();
            Object object2 = this.args().cache() ? rdd.rdd().unpersist(rdd.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordRDD = var3_3;
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    public AlignmentRecordRDD maybeMdTag(SparkContext sc, AlignmentRecordRDD rdd, Option<ValidationStringency> stringencyOpt) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().mdTagsReferenceFile() == null) {
            alignmentRecordRDD = rdd;
        } else {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding MDTags to reads based on reference file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args().mdTagsReferenceFile()})));
            ReferenceFile referenceFile = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadReferenceFile(this.args().mdTagsReferenceFile(), this.args().mdTagsFragmentSize());
            alignmentRecordRDD = rdd.computeMismatchingPositions(referenceFile, this.args().mdTagsOverwrite(), (ValidationStringency)stringencyOpt.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ValidationStringency apply() {
                    return ValidationStringency.STRICT;
                }
            }));
        }
        return alignmentRecordRDD;
    }

    public AlignmentRecordRDD apply(AlignmentRecordRDD rdd) {
        SparkContext sc = rdd.rdd().context();
        StorageLevel sl = StorageLevel$.MODULE$.fromString(this.args().storageLevel());
        Option stringencyOpt = Option$.MODULE$.apply((Object)this.args().stringency()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidationStringency apply(String x$4) {
                return ValidationStringency.valueOf((String)x$4);
            }
        });
        AlignmentRecordRDD initialRdd = this.maybeRepartition(rdd);
        AlignmentRecordRDD maybeDedupedRdd = this.maybeDedupe(initialRdd);
        AlignmentRecordRDD maybeRealignedRdd = this.maybeRealign(sc, maybeDedupedRdd, sl);
        AlignmentRecordRDD maybeRecalibratedRdd = this.maybeRecalibrate(maybeRealignedRdd, sl);
        AlignmentRecordRDD finalPreprocessedRdd = this.maybeCoalesce(maybeRecalibratedRdd);
        AlignmentRecordRDD maybeSortedRdd = this.maybeSort(finalPreprocessedRdd, sl);
        return this.maybeMdTag(sc, maybeSortedRdd, (Option<ValidationStringency>)stringencyOpt);
    }

    public boolean forceNonParquet() {
        return this.args().forceLoadBam() || this.args().forceLoadFastq() || this.args().forceLoadIFastq();
    }

    public boolean isNonParquet(String inputPath) {
        return inputPath.endsWith(".sam") || inputPath.endsWith(".bam") || inputPath.endsWith(".ifq") || inputPath.endsWith(".fq") || inputPath.endsWith(".fastq") || inputPath.endsWith(".fa") || inputPath.endsWith(".fasta");
    }

    public void run(SparkContext sc) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().useAlignedReadPredicate() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().limitProjection() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().useAlignedReadPredicate() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().limitProjection() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().forceLoadBam()) {
            ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$19 = this.args().inputPath();
            ValidationStringency x$20 = qual$2.loadBam$default$2();
            alignmentRecordRDD = qual$2.loadBam(x$19, x$20);
        } else if (this.args().forceLoadFastq()) {
            alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFastq(this.args().inputPath(), Option$.MODULE$.apply((Object)this.args().pairedFastqFile()), Option$.MODULE$.apply((Object)this.args().fastqRecordGroup()), this.stringency());
        } else if (this.args().forceLoadIFastq()) {
            alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(this.args().inputPath());
        } else if (this.args().forceLoadParquet() || this.args().useAlignedReadPredicate() || this.args().limitProjection()) {
            None$ pred = this.args().useAlignedReadPredicate() ? new Some((Object)Dsl$.MODULE$.enrichEqNotEq((Dsl.Column)new Dsl.BooleanColumn("readMapped")).$eq$eq$eq((Comparable)Predef$.MODULE$.boolean2Boolean(true))) : None$.MODULE$;
            None$ proj = this.args().limitProjection() ? new Some((Object)Filter$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.attributes(), AlignmentRecordField$.MODULE$.origQual()}))) : None$.MODULE$;
            alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadParquetAlignments(this.args().inputPath(), (Option)pred, (Option)proj);
        } else {
            ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$21 = this.args().inputPath();
            Option x$22 = Option$.MODULE$.apply((Object)this.args().pairedFastqFile());
            Option x$23 = Option$.MODULE$.apply((Object)this.args().fastqRecordGroup());
            ValidationStringency x$24 = this.stringency();
            Option x$25 = qual$3.loadAlignments$default$2();
            alignmentRecordRDD = qual$3.loadAlignments(x$21, x$25, x$22, x$23, x$24);
        }
        AlignmentRecordRDD aRdd = alignmentRecordRDD;
        RDD rdd = aRdd.rdd();
        SequenceDictionary sd = aRdd.sequences();
        RecordGroupDictionary rgd = aRdd.recordGroups();
        Option concatOpt = Option$.MODULE$.apply((Object)this.args().concatFilename()).map((Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Transform $outer;
            private final SparkContext sc$3;

            public final AlignmentRecordRDD apply(String concatFilename) {
                AlignmentRecordRDD alignmentRecordRDD;
                if (this.$outer.args().forceLoadBam()) {
                    ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$26 = concatFilename;
                    ValidationStringency x$27 = qual$4.loadBam$default$2();
                    alignmentRecordRDD = qual$4.loadBam(x$26, x$27);
                } else if (this.$outer.args().forceLoadIFastq()) {
                    alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3).loadInterleavedFastq(concatFilename);
                } else if (this.$outer.args().forceLoadParquet()) {
                    ADAMContext qual$5 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$28 = concatFilename;
                    Option x$29 = qual$5.loadParquetAlignments$default$2();
                    Option x$30 = qual$5.loadParquetAlignments$default$3();
                    alignmentRecordRDD = qual$5.loadParquetAlignments(x$28, x$29, x$30);
                } else {
                    ADAMContext qual$6 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$31 = concatFilename;
                    Option x$32 = Option$.MODULE$.apply((Object)this.$outer.args().fastqRecordGroup());
                    Option x$33 = qual$6.loadAlignments$default$2();
                    Option x$34 = qual$6.loadAlignments$default$3();
                    ValidationStringency x$35 = qual$6.loadAlignments$default$5();
                    alignmentRecordRDD = qual$6.loadAlignments(x$31, x$33, x$34, x$32, x$35);
                }
                return alignmentRecordRDD;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sc$3 = sc$3;
            }
        });
        Tuple3 tuple3 = (Tuple3)concatOpt.fold((Function0)new $anonfun$7(this, rdd, sd, rgd), (Function1)new $anonfun$8(this, rdd, sd, rgd));
        if (tuple3 != null) {
            Tuple3 tuple32;
            RDD mergedRdd = (RDD)tuple3._1();
            SequenceDictionary mergedSd = (SequenceDictionary)tuple3._2();
            RecordGroupDictionary mergedRgd = (RecordGroupDictionary)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)mergedRdd, (Object)mergedSd, (Object)mergedRgd);
            RDD mergedRdd2 = (RDD)tuple33._1();
            SequenceDictionary mergedSd2 = (SequenceDictionary)tuple33._2();
            RecordGroupDictionary mergedRgd2 = (RecordGroupDictionary)tuple33._3();
            AlignmentRecordRDD newRdd = new AlignmentRecordRDD(mergedRdd2, mergedSd2, mergedRgd2);
            AlignmentRecordRDD outputRdd = this.apply(newRdd);
            SequenceDictionary sdFinal = this.args().sortReads() ? (this.args().sortLexicographically() ? mergedSd2.stripIndices().sorted() : mergedSd2) : mergedSd2;
            outputRdd.save((ADAMSaveAnyArgs)this.args(), this.args().sortReads() || this.args().sortLexicographically());
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private SnpTable createKnownSnpsTable(SparkContext sc) {
        return (SnpTable)Option$.MODULE$.apply((Object)this.args().knownSnpsFile()).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SnpTable apply() {
                return SnpTable$.MODULE$.apply();
            }
        }, (Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;

            public final SnpTable apply(String f) {
                ADAMContext qual$7 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2);
                String x$36 = f;
                Option x$37 = qual$7.loadVariants$default$2();
                ValidationStringency x$38 = qual$7.loadVariants$default$3();
                return SnpTable$.MODULE$.apply(qual$7.loadVariants(x$36, x$37, x$38));
            }
            {
                this.sc$2 = sc$2;
            }
        });
    }

    public Transform(TransformArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = Transform$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

