/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import htsjdk.samtools.ValidationStringency;
import java.time.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.dsl.Dsl;
import org.apache.parquet.filter2.dsl.Dsl$;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator$;
import org.bdgenomics.adam.cli.About;
import org.bdgenomics.adam.cli.TransformAlignments$;
import org.bdgenomics.adam.cli.TransformAlignmentsArgs;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.io.FastqRecordReader;
import org.bdgenomics.adam.models.ReadGroupDictionary;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Filter$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.read.AlignmentRecordDataset;
import org.bdgenomics.adam.rdd.read.AlignmentRecordDataset$;
import org.bdgenomics.adam.rdd.read.QualityScoreBin$;
import org.bdgenomics.adam.util.ReferenceFile;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.bdgenomics.utils.misc.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mu!B\u0001\u0003\u0011\u0003Y\u0011a\u0005+sC:\u001chm\u001c:n\u00032LwM\\7f]R\u001c(BA\u0002\u0005\u0003\r\u0019G.\u001b\u0006\u0003\u000b\u0019\tA!\u00193b[*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003'Q\u0013\u0018M\\:g_Jl\u0017\t\\5h]6,g\u000e^:\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/mi\u0011\u0001\u0007\u0006\u0003\u0007eQ!A\u0007\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005qA\"a\u0005\"E\u000f\u000e{W.\\1oI\u000e{W\u000e]1oS>t\u0007\"\u0002\u0010\u000e\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001d\tSB1A\u0005\u0002\t\n1bY8n[\u0006tGMT1nKV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\rM#(/\u001b8h\u0011\u0019aS\u0002)A\u0005G\u0005a1m\\7nC:$g*Y7fA!9a&\u0004b\u0001\n\u0003\u0011\u0013AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:Da\u0001M\u0007!\u0002\u0013\u0019\u0013aE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\"\u0002\u001a\u000e\t\u0003\u0019\u0014!B1qa2LHc\u0001\u001b\u0002\u0012B\u0011A\"\u000e\u0004\u0005\u001d\t\u0001ag\u0005\u00036oi\u0002\u0005C\u0001\u00139\u0013\tITE\u0001\u0004PE*,7\r\u001e\t\u0004/mj\u0014B\u0001\u001f\u0019\u0005=\u0011EiR*qCJ\\7i\\7nC:$\u0007C\u0001\u0007?\u0013\ty$AA\fUe\u0006t7OZ8s[\u0006c\u0017n\u001a8nK:$8/\u0011:hgB\u0011\u0011\tR\u0007\u0002\u0005*\u00111)G\u0001\u0005[&\u001c8-\u0003\u0002F\u0005\n9Aj\\4hS:<\u0007\u0002C$6\u0005\u000b\u0007I\u0011\u0003%\u0002\t\u0005\u0014xm]\u000b\u0002{!A!*\u000eB\u0001B\u0003%Q(A\u0003be\u001e\u001c\b\u0005C\u0003\u001fk\u0011\u0005A\n\u0006\u00025\u001b\")qi\u0013a\u0001{!9q*\u000eb\u0001\n\u0003\u0001\u0016!C2p[B\fg.[8o+\u0005\tfB\u0001\u0007\u0001\u0011\u0019\u0019V\u0007)A\u0005#\u0006Q1m\\7qC:LwN\u001c\u0011\t\u000fU+$\u0019!C\u0001-\u0006Q1\u000f\u001e:j]\u001e,gnY=\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\u0011M\fW\u000e^8pYNT\u0011\u0001X\u0001\u0007QR\u001c(\u000eZ6\n\u0005yK&\u0001\u0006,bY&$\u0017\r^5p]N#(/\u001b8hK:\u001c\u0017\u0010\u0003\u0004ak\u0001\u0006IaV\u0001\fgR\u0014\u0018N\\4f]\u000eL\b\u0005C\u0003ck\u0011%1-\u0001\u0005nCf\u0014WMQ5o)\t!G\u000e\u0005\u0002fU6\taM\u0003\u0002hQ\u0006!!/Z1e\u0015\tIG!A\u0002sI\u0012L!a\u001b4\u0003-\u0005c\u0017n\u001a8nK:$(+Z2pe\u0012$\u0015\r^1tKRDQ![1A\u0002\u0011DQA\\\u001b\u0005\n=\f\u0001#\\1zE\u0016\u0014V\r]1si&$\u0018n\u001c8\u0015\u0005\u0011\u0004\b\"B5n\u0001\u0004!\u0007\"\u0002:6\t\u0013\u0019\u0018aC7bs\n,G)\u001a3va\u0016$\"\u0001\u001a;\t\u000b%\f\b\u0019\u00013\t\u000bY,D\u0011B<\u0002\u00195\f\u0017PY3SK\u0006d\u0017n\u001a8\u0015\r\u0011D\u0018QAA\u0004\u0011\u0015IX\u000f1\u0001{\u0003\t\u00198\rE\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fQa\u001d9be.T!a \u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\t\u0019\u0001 \u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006SV\u0004\r\u0001\u001a\u0005\b\u0003\u0013)\b\u0019AA\u0006\u0003\t\u0019H\u000e\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002`\u0001\bgR|'/Y4f\u0013\u0011\t)\"a\u0004\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000f\u0005eQ\u0007\"\u0003\u0002\u001c\u0005\u0001R.Y=cKJ+7-\u00197jEJ\fG/\u001a\u000b\u0006I\u0006u\u0011q\u0004\u0005\u0007S\u0006]\u0001\u0019\u00013\t\u0011\u0005%\u0011q\u0003a\u0001\u0003\u0017Aq!a\t6\t\u0013\t)#A\u0007nCf\u0014WmQ8bY\u0016\u001c8-\u001a\u000b\u0004I\u0006\u001d\u0002BB5\u0002\"\u0001\u0007A\rC\u0004\u0002,U\"I!!\f\u0002\u00135\f\u0017PY3T_J$H#\u00023\u00020\u0005E\u0002BB5\u0002*\u0001\u0007A\r\u0003\u0005\u0002\n\u0005%\u0002\u0019AA\u0006\u0011\u001d\t)$\u000eC\u0005\u0003o\t!\"\\1zE\u0016lE\rV1h)\u001d!\u0017\u0011HA\u001e\u0003{Aa!_A\u001a\u0001\u0004Q\bBB5\u00024\u0001\u0007A\r\u0003\u0005\u0002@\u0005M\u0002\u0019AA!\u00035\u0019HO]5oO\u0016t7-_(qiB!\u0011#a\u0011X\u0013\r\t)E\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\rI*D\u0011AA%)\r!\u00171\n\u0005\u0007S\u0006\u001d\u0003\u0019\u00013\t\u000f\u0005=S\u0007\"\u0001\u0002R\u0005yam\u001c:dK:{g\u000eU1scV,G\u000f\u0006\u0002\u0002TA\u0019\u0011#!\u0016\n\u0007\u0005]#CA\u0004C_>dW-\u00198\t\u000f\u0005mS\u0007\"\u0001\u0002^\u0005a\u0011n\u001d(p]B\u000b'/];fiR!\u00111KA0\u0011!\t\t'!\u0017A\u0002\u0005\r\u0014!C5oaV$\b+\u0019;i!\u0011\t)'a\u001b\u000f\u0007E\t9'C\u0002\u0002jI\ta\u0001\u0015:fI\u00164\u0017b\u0001\u0016\u0002n)\u0019\u0011\u0011\u000e\n\t\u000f\u0005ET\u0007\"\u0001\u0002t\u0005\u0019!/\u001e8\u0015\t\u0005U\u00141\u0010\t\u0004#\u0005]\u0014bAA=%\t!QK\\5u\u0011\u0019I\u0018q\u000ea\u0001u\"9\u0011qP\u001b\u0005\n\u0005\u0005\u0015\u0001F2sK\u0006$Xm\u00138po:\u001cf\u000e]:UC\ndW\r\u0006\u0003\u0002\u0004\u0006=\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%E!\u0001\u0004n_\u0012,Gn]\u0005\u0005\u0003\u001b\u000b9I\u0001\u0005T]B$\u0016M\u00197f\u0011\u0019I\u0018Q\u0010a\u0001u\"9\u00111S\u0019A\u0002\u0005U\u0015aB2nI2Kg.\u001a\t\u0006#\u0005]\u00151M\u0005\u0004\u00033\u0013\"!B!se\u0006L\b")
public class TransformAlignments
implements BDGSparkCommand<TransformAlignmentsArgs> {
    private final TransformAlignmentsArgs args;
    private final TransformAlignments$ companion;
    private final ValidationStringency stringency;
    private transient Logger org$bdgenomics$utils$misc$Logging$$log_;

    public static void main(String[] stringArray) {
        TransformAlignments$.MODULE$.main(stringArray);
    }

    public static String commandDescription() {
        return TransformAlignments$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformAlignments$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger org$bdgenomics$utils$misc$Logging$$log_() {
        return this.org$bdgenomics$utils$misc$Logging$$log_;
    }

    public void org$bdgenomics$utils$misc$Logging$$log__$eq(Logger x$1) {
        this.org$bdgenomics$utils$misc$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public TransformAlignmentsArgs args() {
        return this.args;
    }

    public TransformAlignments$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private AlignmentRecordDataset maybeBin(AlignmentRecordDataset rdd) {
        return (AlignmentRecordDataset)Option$.MODULE$.apply((Object)this.args().binQualityScores()).fold((Function0)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordDataset rdd$1;

            public final AlignmentRecordDataset apply() {
                return this.rdd$1;
            }
            {
                this.rdd$1 = rdd$1;
            }
        }, (Function1)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordDataset rdd$1;

            public final AlignmentRecordDataset apply(String binDescription) {
                Seq bins = QualityScoreBin$.MODULE$.apply(binDescription);
                return this.rdd$1.binQualityScores(bins);
            }
            {
                this.rdd$1 = rdd$1;
            }
        });
    }

    private AlignmentRecordDataset maybeRepartition(AlignmentRecordDataset rdd) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().repartition() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            alignmentRecordDataset = (AlignmentRecordDataset)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$1) {
                    int x$8 = this.$outer.args().repartition();
                    Ordering x$9 = x$1.repartition$default$2(x$8);
                    return x$1.repartition(x$8, x$9);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordDataset = rdd;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeDedupe(AlignmentRecordDataset rdd) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().markDuplicates()) {
            this.log().info("Marking duplicates");
            alignmentRecordDataset = rdd.markDuplicates();
        } else {
            alignmentRecordDataset = rdd;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeRealign(SparkContext sc, AlignmentRecordDataset rdd, StorageLevel sl) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().locallyRealign()) {
            this.log().info("Locally realigning indels.");
            Object object = this.args().cache() ? rdd.rdd().persist(sl) : BoxedUnit.UNIT;
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsensusGenerator apply() {
                    return ConsensusGenerator$.MODULE$.fromReads();
                }
            }, (Function1)new Serializable(this, rdd){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordDataset rdd$2;

                public final ConsensusGenerator apply(String file) {
                    ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.rdd$2.rdd().context());
                    String x$10 = file;
                    Option x$11 = qual$1.loadVariants$default$2();
                    Option x$12 = qual$1.loadVariants$default$3();
                    ValidationStringency x$13 = qual$1.loadVariants$default$4();
                    return ConsensusGenerator$.MODULE$.fromKnownIndels(qual$1.loadVariants(x$10, x$11, x$12, x$13));
                }
                {
                    this.rdd$2 = rdd$2;
                }
            });
            Option optReferenceFile = Option$.MODULE$.apply((Object)this.args().reference()).map((Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;
                private final SparkContext sc$1;

                public final ReferenceFile apply(String f) {
                    return ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$1).loadReferenceFile(f, this.$outer.args().mdTagsFragmentSize());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sc$1 = sc$1;
                }
            });
            ConsensusGenerator x$14 = consensusGenerator;
            boolean x$15 = false;
            int x$16 = this.args().maxIndelSize();
            int x$17 = this.args().maxConsensusNumber();
            double x$18 = this.args().lodThreshold();
            int x$19 = this.args().maxTargetSize();
            int x$20 = this.args().maxReadsPerTarget();
            Option x$21 = optReferenceFile;
            boolean x$22 = this.args().unclipReads();
            AlignmentRecordDataset realignmentRdd = rdd.realignIndels(x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$22, x$21);
            Object object2 = this.args().cache() ? rdd.rdd().unpersist(rdd.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordDataset = realignmentRdd;
        } else {
            alignmentRecordDataset = rdd;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeRecalibrate(AlignmentRecordDataset rdd, StorageLevel sl) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().recalibrateBaseQualities()) {
            AlignmentRecordDataset bqsredRdd;
            this.log().info("Recalibrating base qualities");
            None$ optSl = this.args().cache() ? new Some((Object)sl) : None$.MODULE$;
            SnpTable knownSnps = this.createKnownSnpsTable(rdd.rdd().context());
            Broadcast broadcastedSnps = (Broadcast)Timers$.MODULE$.BroadcastingKnownSnps().time((Function0)new Serializable(this, rdd, knownSnps){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordDataset rdd$3;
                private final SnpTable knownSnps$1;

                public final Broadcast<SnpTable> apply() {
                    return this.rdd$3.rdd().context().broadcast((Object)this.knownSnps$1, ClassTag$.MODULE$.apply(SnpTable.class));
                }
                {
                    this.rdd$3 = rdd$3;
                    this.knownSnps$1 = knownSnps$1;
                }
            });
            alignmentRecordDataset = bqsredRdd = rdd.recalibrateBaseQualities(broadcastedSnps, this.args().minAcceptableQuality(), (Option)optSl, Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.args().samplingFraction())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(double x$2) {
                    return this.apply$mcZD$sp(x$2);
                }

                public boolean apply$mcZD$sp(double x$2) {
                    return x$2 > 0.0;
                }
            }), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.args().samplingSeed())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(long x$3) {
                    return this.apply$mcZJ$sp(x$3);
                }

                public boolean apply$mcZJ$sp(long x$3) {
                    return x$3 != 0L;
                }
            }));
        } else {
            alignmentRecordDataset = rdd;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeCoalesce(AlignmentRecordDataset rdd) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().coalesce() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            alignmentRecordDataset = this.args().coalesce() > rdd.rdd().partitions().length || this.args().forceShuffle() ? (AlignmentRecordDataset)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$4) {
                    int x$23 = this.$outer.args().coalesce();
                    boolean x$24 = true;
                    Option x$25 = x$4.coalesce$default$3();
                    Ordering x$26 = x$4.coalesce$default$4(x$23, x$24, x$25);
                    return x$4.coalesce(x$23, x$24, x$25, x$26);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }) : (AlignmentRecordDataset)rdd.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$5) {
                    int x$27 = this.$outer.args().coalesce();
                    boolean x$28 = false;
                    Option x$29 = x$5.coalesce$default$3();
                    Ordering x$30 = x$5.coalesce$default$4(x$27, x$28, x$29);
                    return x$5.coalesce(x$27, x$28, x$29, x$30);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordDataset = rdd;
        }
        return alignmentRecordDataset;
    }

    /*
     * WARNING - void declaration
     */
    private AlignmentRecordDataset maybeSort(AlignmentRecordDataset rdd, StorageLevel sl) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().sortReads()) {
            void var3_3;
            Object object = this.args().cache() ? rdd.rdd().persist(sl) : BoxedUnit.UNIT;
            this.log().info("Sorting reads");
            AlignmentRecordDataset sortedRdd = this.args().sortLexicographically() ? rdd.sortReadsByReferencePosition() : rdd.sortReadsByReferencePositionAndIndex();
            Object object2 = this.args().cache() ? rdd.rdd().unpersist(rdd.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordDataset = var3_3;
        } else {
            alignmentRecordDataset = rdd;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeMdTag(SparkContext sc, AlignmentRecordDataset rdd, Option<ValidationStringency> stringencyOpt) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().mdTagsReferenceFile() == null) {
            alignmentRecordDataset = rdd;
        } else {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding MDTags to reads based on reference file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args().mdTagsReferenceFile()})));
            ReferenceFile referenceFile = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadReferenceFile(this.args().mdTagsReferenceFile(), this.args().mdTagsFragmentSize());
            alignmentRecordDataset = rdd.computeMismatchingPositions(referenceFile, this.args().mdTagsOverwrite(), (ValidationStringency)stringencyOpt.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ValidationStringency apply() {
                    return ValidationStringency.STRICT;
                }
            }));
        }
        return alignmentRecordDataset;
    }

    public AlignmentRecordDataset apply(AlignmentRecordDataset rdd) {
        SparkContext sc = rdd.rdd().context();
        StorageLevel sl = StorageLevel$.MODULE$.fromString(this.args().storageLevel());
        Option stringencyOpt = Option$.MODULE$.apply((Object)this.args().stringency()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidationStringency apply(String x$6) {
                return ValidationStringency.valueOf((String)x$6);
            }
        });
        if (this.args().maxReadLength() > 0) {
            FastqRecordReader.setMaxReadLength((Configuration)sc.hadoopConfiguration(), (int)this.args().maxReadLength());
        }
        AlignmentRecordDataset initialRdd = this.maybeRepartition(rdd);
        AlignmentRecordDataset binnedRdd = this.maybeBin(rdd);
        AlignmentRecordDataset maybeDedupedRdd = this.maybeDedupe(binnedRdd);
        AlignmentRecordDataset maybeRealignedRdd = this.maybeRealign(sc, maybeDedupedRdd, sl);
        AlignmentRecordDataset maybeRecalibratedRdd = this.maybeRecalibrate(maybeRealignedRdd, sl);
        AlignmentRecordDataset finalPreprocessedRdd = this.maybeCoalesce(maybeRecalibratedRdd);
        AlignmentRecordDataset maybeSortedRdd = this.maybeSort(finalPreprocessedRdd, sl);
        return this.maybeMdTag(sc, maybeSortedRdd, (Option<ValidationStringency>)stringencyOpt);
    }

    public boolean forceNonParquet() {
        return this.args().forceLoadBam() || this.args().forceLoadFastq() || this.args().forceLoadIFastq();
    }

    public boolean isNonParquet(String inputPath) {
        return inputPath.endsWith(".sam") || inputPath.endsWith(".bam") || inputPath.endsWith(".ifq") || inputPath.endsWith(".fq") || inputPath.endsWith(".fastq") || inputPath.endsWith(".fa") || inputPath.endsWith(".fasta");
    }

    public void run(SparkContext sc) {
        AlignmentRecordDataset alignmentRecordDataset;
        AlignmentRecordDataset loadedRdd;
        AlignmentRecordDataset alignmentRecordDataset2;
        if (this.args().useAlignedReadPredicate() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().limitProjection() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().useAlignedReadPredicate() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().limitProjection() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().useAlignedReadPredicate() && this.args().regionPredicate() != null) {
            throw new IllegalArgumentException("-aligned_read_predicate and -region_predicate are mutually exclusive");
        }
        if (this.args().forceLoadBam()) {
            if (this.args().regionPredicate() == null) {
                ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$34 = this.args().inputPath();
                ValidationStringency x$35 = qual$3.loadBam$default$2();
                alignmentRecordDataset2 = qual$3.loadBam(x$34, x$35);
            } else {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$31 = this.args().inputPath();
                Iterable x$32 = loci;
                ValidationStringency x$33 = qual$2.loadIndexedBam$default$3();
                alignmentRecordDataset2 = qual$2.loadIndexedBam(x$31, x$32, x$33, Predef.DummyImplicit$.MODULE$.dummyImplicit());
            }
        } else if (this.args().forceLoadFastq()) {
            alignmentRecordDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFastq(this.args().inputPath(), Option$.MODULE$.apply((Object)this.args().pairedFastqFile()), Option$.MODULE$.apply((Object)this.args().fastqReadGroup()), this.stringency());
        } else if (this.args().forceLoadIFastq()) {
            alignmentRecordDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(this.args().inputPath());
        } else if (this.args().forceLoadParquet() || this.args().useAlignedReadPredicate() || this.args().limitProjection()) {
            Some pred = this.args().useAlignedReadPredicate() ? new Some((Object)Dsl$.MODULE$.enrichEqNotEq((Dsl.Column)new Dsl.BooleanColumn("readMapped")).$eq$eq$eq((Comparable)Predef$.MODULE$.boolean2Boolean(true))) : (this.args().regionPredicate() == null ? None$.MODULE$ : new Some((Object)ReferenceRegion$.MODULE$.createPredicate(ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate()).toSeq())));
            None$ proj = this.args().limitProjection() ? new Some((Object)Filter$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.attributes(), AlignmentRecordField$.MODULE$.originalQuality()}))) : None$.MODULE$;
            alignmentRecordDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadParquetAlignments(this.args().inputPath(), (Option)pred, (Option)proj);
        } else {
            ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$36 = this.args().inputPath();
            Option x$37 = Option$.MODULE$.apply((Object)this.args().pairedFastqFile());
            Option x$38 = Option$.MODULE$.apply((Object)this.args().fastqReadGroup());
            ValidationStringency x$39 = this.stringency();
            Option x$40 = qual$4.loadAlignments$default$4();
            Option x$41 = qual$4.loadAlignments$default$5();
            AlignmentRecordDataset loadedReads = qual$4.loadAlignments(x$36, x$37, x$38, x$40, x$41, x$39);
            if (this.args().regionPredicate() == null) {
                alignmentRecordDataset2 = loadedReads;
            } else {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                alignmentRecordDataset2 = loadedRdd = (AlignmentRecordDataset)loadedReads.filterByOverlappingRegions(loci);
            }
        }
        if (this.args().disableProcessingStep()) {
            alignmentRecordDataset = loadedRdd;
        } else {
            About about = new About();
            String version = about.isSnapshot() ? new StringOps(Predef$.MODULE$.augmentString("%s--%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{about.version(), about.commit()})) : about.version();
            long epoch = Instant.now().getEpochSecond();
            ProcessingStep processingStep = ProcessingStep.newBuilder().setId(new StringOps(Predef$.MODULE$.augmentString("ADAM_%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epoch)}))).setProgramName("org.bdgenomics.adam.cli.TransformAlignments").setVersion(version).setCommandLine(this.args().command()).build();
            alignmentRecordDataset = (AlignmentRecordDataset)loadedRdd.addProcessingStep(processingStep);
        }
        AlignmentRecordDataset aRdd = alignmentRecordDataset;
        RDD rdd = aRdd.rdd();
        SequenceDictionary sd = aRdd.sequences();
        ReadGroupDictionary rgd = aRdd.readGroups();
        Seq pgs = aRdd.processingSteps();
        Option concatOpt = Option$.MODULE$.apply((Object)this.args().concatFilename()).map((Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransformAlignments $outer;
            private final SparkContext sc$3;

            public final AlignmentRecordDataset apply(String concatFilename) {
                AlignmentRecordDataset alignmentRecordDataset;
                if (this.$outer.args().forceLoadBam()) {
                    ADAMContext qual$5 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$42 = concatFilename;
                    ValidationStringency x$43 = qual$5.loadBam$default$2();
                    alignmentRecordDataset = qual$5.loadBam(x$42, x$43);
                } else if (this.$outer.args().forceLoadIFastq()) {
                    alignmentRecordDataset = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3).loadInterleavedFastq(concatFilename);
                } else if (this.$outer.args().forceLoadParquet()) {
                    ADAMContext qual$6 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$44 = concatFilename;
                    Option x$45 = qual$6.loadParquetAlignments$default$2();
                    Option x$46 = qual$6.loadParquetAlignments$default$3();
                    alignmentRecordDataset = qual$6.loadParquetAlignments(x$44, x$45, x$46);
                } else {
                    ADAMContext qual$7 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$47 = concatFilename;
                    Option x$48 = Option$.MODULE$.apply((Object)this.$outer.args().fastqReadGroup());
                    Option x$49 = qual$7.loadAlignments$default$2();
                    Option x$50 = qual$7.loadAlignments$default$4();
                    Option x$51 = qual$7.loadAlignments$default$5();
                    ValidationStringency x$52 = qual$7.loadAlignments$default$6();
                    alignmentRecordDataset = qual$7.loadAlignments(x$47, x$49, x$48, x$50, x$51, x$52);
                }
                return alignmentRecordDataset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sc$3 = sc$3;
            }
        });
        Tuple4 tuple4 = (Tuple4)concatOpt.fold((Function0)new Serializable(this, rdd, sd, rgd, pgs){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$4;
            private final SequenceDictionary sd$1;
            private final ReadGroupDictionary rgd$1;
            private final Seq pgs$1;

            public final Tuple4<RDD<AlignmentRecord>, SequenceDictionary, ReadGroupDictionary, Seq<ProcessingStep>> apply() {
                return new Tuple4((Object)this.rdd$4, (Object)this.sd$1, (Object)this.rgd$1, (Object)this.pgs$1);
            }
            {
                this.rdd$4 = rdd$4;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
                this.pgs$1 = pgs$1;
            }
        }, (Function1)new Serializable(this, rdd, sd, rgd, pgs){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$4;
            private final SequenceDictionary sd$1;
            private final ReadGroupDictionary rgd$1;
            private final Seq pgs$1;

            public final Tuple4<RDD<AlignmentRecord>, SequenceDictionary, ReadGroupDictionary, Seq<ProcessingStep>> apply(AlignmentRecordDataset t) {
                return new Tuple4((Object)this.rdd$4.$plus$plus(t.rdd()), (Object)this.sd$1.$plus$plus(t.sequences()), (Object)this.rgd$1.$plus$plus(t.readGroups()), this.pgs$1.$plus$plus((GenTraversableOnce)t.processingSteps(), Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.rdd$4 = rdd$4;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
                this.pgs$1 = pgs$1;
            }
        });
        if (tuple4 != null) {
            SequenceDictionary sdFinal;
            Tuple4 tuple42;
            RDD mergedRdd = (RDD)tuple4._1();
            SequenceDictionary mergedSd = (SequenceDictionary)tuple4._2();
            ReadGroupDictionary mergedRgd = (ReadGroupDictionary)tuple4._3();
            Seq mergedPgs = (Seq)tuple4._4();
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)mergedRdd, (Object)mergedSd, (Object)mergedRgd, (Object)mergedPgs);
            RDD mergedRdd2 = (RDD)tuple43._1();
            SequenceDictionary mergedSd2 = (SequenceDictionary)tuple43._2();
            ReadGroupDictionary mergedRgd2 = (ReadGroupDictionary)tuple43._3();
            Seq mergedPgs2 = (Seq)tuple43._4();
            AlignmentRecordDataset newRdd = AlignmentRecordDataset$.MODULE$.apply(mergedRdd2, mergedSd2, mergedRgd2, mergedPgs2);
            AlignmentRecordDataset outputRdd = this.apply(newRdd);
            SequenceDictionary sequenceDictionary = this.args().sortReads() ? (this.args().sortLexicographically() ? mergedSd2.stripIndices().sorted() : mergedSd2) : (sdFinal = mergedSd2);
            if (this.args().partitionByStartPos()) {
                if (outputRdd.sequences().isEmpty()) {
                    this.log().warn("This dataset is not aligned and therefore will not benefit from being saved as a partitioned dataset");
                }
                String x$53 = this.args().outputPath();
                int x$54 = this.args().partitionedBinSize();
                CompressionCodecName x$55 = outputRdd.saveAsPartitionedParquet$default$2();
                outputRdd.saveAsPartitionedParquet(x$53, x$55, x$54);
            } else {
                outputRdd.save((ADAMSaveAnyArgs)this.args(), this.args().sortReads() || this.args().sortLexicographically());
            }
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    private SnpTable createKnownSnpsTable(SparkContext sc) {
        return (SnpTable)Option$.MODULE$.apply((Object)this.args().knownSnpsFile()).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SnpTable apply() {
                return SnpTable$.MODULE$.apply();
            }
        }, (Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;

            public final SnpTable apply(String f) {
                ADAMContext qual$8 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2);
                String x$56 = f;
                Option x$57 = qual$8.loadVariants$default$2();
                Option x$58 = qual$8.loadVariants$default$3();
                ValidationStringency x$59 = qual$8.loadVariants$default$4();
                return SnpTable$.MODULE$.apply(qual$8.loadVariants(x$56, x$57, x$58, x$59));
            }
            {
                this.sc$2 = sc$2;
            }
        });
    }

    public TransformAlignments(TransformAlignmentsArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = TransformAlignments$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

