/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.cli.Fasta2ADAM$;
import org.bdgenomics.adam.cli.Fasta2ADAMArgs;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.contig.NucleotideContigFragmentDataset;
import org.bdgenomics.formats.avro.NucleotideContigFragment;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=<Q!\u0001\u0002\t\u0002-\t!BR1ti\u0006\u0014\u0014\tR!N\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!A\u0003$bgR\f''\u0011#B\u001bN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t92$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u001b\r\u0005)Q\u000f^5mg&\u0011A\u0004\u0007\u0002\u0014\u0005\u0012;5i\\7nC:$7i\\7qC:LwN\u001c\u0005\u0006=5!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-Aq!I\u0007C\u0002\u0013\u0005!%A\u0006d_6l\u0017M\u001c3OC6,W#A\u0012\u0011\u0005\u0011:cBA\t&\u0013\t1##\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014\u0013\u0011\u0019YS\u0002)A\u0005G\u0005a1m\\7nC:$g*Y7fA!9Q&\u0004b\u0001\n\u0003\u0011\u0013AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:DaaL\u0007!\u0002\u0013\u0019\u0013aE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\"B\u0019\u000e\t\u0003\u0011\u0014!B1qa2LHCA\u001ak!\taAG\u0002\u0003\u000f\u0005\u0001)4\u0003\u0002\u001b7}\u0011\u0003\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t1\fgn\u001a\u0006\u0002w\u0005!!.\u0019<b\u0013\ti\u0004H\u0001\u0004PE*,7\r\u001e\t\u0004/}\n\u0015B\u0001!\u0019\u0005=\u0011EiR*qCJ\\7i\\7nC:$\u0007C\u0001\u0007C\u0013\t\u0019%A\u0001\bGCN$\u0018MM!E\u00036\u000b%oZ:\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015!B:mMRR'\"A%\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0013$\u0003\u000f1{wmZ5oO\"AQ\n\u000eBC\u0002\u0013Ea*\u0001\u0003be\u001e\u001cX#A!\t\u0011A#$\u0011!Q\u0001\n\u0005\u000bQ!\u0019:hg\u0002BQA\b\u001b\u0005\u0002I#\"aM*\t\u000b5\u000b\u0006\u0019A!\t\u000fU#$\u0019!C\u0001-\u0006I1m\\7qC:LwN\\\u000b\u0002/:\u0011A\u0002\u0001\u0005\u00073R\u0002\u000b\u0011B,\u0002\u0015\r|W\u000e]1oS>t\u0007\u0005C\u0003\\i\u0011\u0005A,A\u0002sk:$\"!\u00181\u0011\u0005Eq\u0016BA0\u0013\u0005\u0011)f.\u001b;\t\u000b\u0005T\u0006\u0019\u00012\u0002\u0005M\u001c\u0007CA2i\u001b\u0005!'BA3g\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0007\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003S\u0012\u0014Ab\u00159be.\u001cuN\u001c;fqRDQa\u001b\u0019A\u00021\fqaY7e\u0019&tW\rE\u0002\u0012[\u000eJ!A\u001c\n\u0003\u000b\u0005\u0013(/Y=")
public class Fasta2ADAM
implements BDGSparkCommand<Fasta2ADAMArgs> {
    private final Fasta2ADAMArgs args;
    private final Fasta2ADAM$ companion;
    private final transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static void main(String[] stringArray) {
        Fasta2ADAM$.MODULE$.main(stringArray);
    }

    public static Fasta2ADAM apply(String[] stringArray) {
        return Fasta2ADAM$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return Fasta2ADAM$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Fasta2ADAM$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Fasta2ADAM fasta2ADAM = this;
        synchronized (fasta2ADAM) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$trans$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    public Fasta2ADAMArgs args() {
        return this.args;
    }

    public Fasta2ADAM$ companion() {
        return this.companion;
    }

    public void run(SparkContext sc) {
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Loading FASTA data from disk.";
            }
        });
        NucleotideContigFragmentDataset adamFasta = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFasta(this.args().fastaFile(), this.args().maximumLength());
        if (this.args().verbose()) {
            this.info((Function0<Object>)new Serializable(this, adamFasta){
                public static final long serialVersionUID = 0L;
                private final NucleotideContigFragmentDataset adamFasta$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("FASTA contains: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.adamFasta$1.sequences().toString()}));
                }
                {
                    this.adamFasta$1 = adamFasta$1;
                }
            });
        }
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Writing records to disk.";
            }
        });
        NucleotideContigFragmentDataset finalFasta = this.args().partitions() > 0 ? (NucleotideContigFragmentDataset)adamFasta.transform((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Fasta2ADAM $outer;

            public final RDD<NucleotideContigFragment> apply(RDD<NucleotideContigFragment> rdd) {
                int x$1 = this.$outer.args().partitions();
                Ordering x$2 = rdd.repartition$default$2(x$1);
                return rdd.repartition(x$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }) : adamFasta;
        finalFasta.saveAsParquet((SaveArgs)this.args());
    }

    public Fasta2ADAM(Fasta2ADAMArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = Fasta2ADAM$.MODULE$;
    }
}

