/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformFragments$;
import org.bdgenomics.adam.cli.TransformFragmentsArgs;
import org.bdgenomics.adam.io.FastqRecordReader;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.fragment.FragmentDataset;
import org.bdgenomics.adam.rdd.read.AlignmentRecordDataset;
import org.bdgenomics.adam.rdd.read.QualityScoreBin$;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015q!B\u0001\u0003\u0011\u0003Y\u0011A\u0005+sC:\u001chm\u001c:n\rJ\fw-\\3oiNT!a\u0001\u0003\u0002\u0007\rd\u0017N\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0013)J\fgn\u001d4pe64%/Y4nK:$8oE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001c\u001b\u0005A\"BA\u0002\u001a\u0015\tQb!A\u0003vi&d7/\u0003\u0002\u001d1\t\u0019\"\tR$D_6l\u0017M\u001c3D_6\u0004\u0018M\\5p]\")a$\u0004C\u0001?\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\bC5\u0011\r\u0011\"\u0001#\u0003-\u0019w.\\7b]\u0012t\u0015-\\3\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004TiJLgn\u001a\u0005\u0007Y5\u0001\u000b\u0011B\u0012\u0002\u0019\r|W.\\1oI:\u000bW.\u001a\u0011\t\u000f9j!\u0019!C\u0001E\u0005\u00112m\\7nC:$G)Z:de&\u0004H/[8o\u0011\u0019\u0001T\u0002)A\u0005G\u0005\u00192m\\7nC:$G)Z:de&\u0004H/[8oA!)!'\u0004C\u0001g\u0005)\u0011\r\u001d9msR\u0011Ag\u001e\t\u0003\u0019U2AA\u0004\u0002\u0001mM!Qg\u000e\u001eA!\t!\u0003(\u0003\u0002:K\t1qJ\u00196fGR\u00042aF\u001e>\u0013\ta\u0004DA\bC\t\u001e\u001b\u0006/\u0019:l\u0007>lW.\u00198e!\taa(\u0003\u0002@\u0005\t1BK]1og\u001a|'/\u001c$sC\u001elWM\u001c;t\u0003J<7\u000f\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006)1\u000f\u001c45U*\tQ)\u0001\u0005he&T(\u0010\\3e\u0013\t9%IA\u0004M_\u001e<\u0017N\\4\t\u0011%+$Q1A\u0005\u0012)\u000bA!\u0019:hgV\tQ\b\u0003\u0005Mk\t\u0005\t\u0015!\u0003>\u0003\u0015\t'oZ:!\u0011\u0015qR\u0007\"\u0001O)\t!t\nC\u0003J\u001b\u0002\u0007Q\bC\u0004Rk\t\u0007I\u0011\u0001*\u0002\u0013\r|W\u000e]1oS>tW#A*\u000f\u00051\u0001\u0001BB+6A\u0003%1+\u0001\u0006d_6\u0004\u0018M\\5p]\u0002BQaV\u001b\u0005\u0002a\u000b1\"\\1zE\u0016$U\rZ;qKR\u0011\u0011,\u0019\t\u00035~k\u0011a\u0017\u0006\u00039v\u000b\u0001B\u001a:bO6,g\u000e\u001e\u0006\u0003=\u0012\t1A\u001d3e\u0013\t\u00017LA\bGe\u0006<W.\u001a8u\t\u0006$\u0018m]3u\u0011\u0015\u0011g\u000b1\u0001Z\u0003\u0015\u0011X-\u00193t\u0011\u0015!W\u0007\"\u0003f\u0003!i\u0017-\u001f2f\u0005&tGCA-g\u0011\u0015q6\r1\u0001Z\u0011\u0015AW\u0007\"\u0001j\u0003\r\u0011XO\u001c\u000b\u0003U6\u0004\"!E6\n\u00051\u0014\"\u0001B+oSRDQA\\4A\u0002=\f!a]2\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018!B:qCJ\\'B\u0001;\t\u0003\u0019\t\u0007/Y2iK&\u0011a/\u001d\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006qF\u0002\r!_\u0001\bG6$G*\u001b8f!\r\t\"\u0010`\u0005\u0003wJ\u0011Q!\u0011:sCf\u00042!`A\u0001\u001d\t\tb0\u0003\u0002\u0000%\u00051\u0001K]3eK\u001aL1AKA\u0002\u0015\ty(\u0003")
public class TransformFragments
implements BDGSparkCommand<TransformFragmentsArgs> {
    private final TransformFragmentsArgs args;
    private final TransformFragments$ companion;
    private final transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static void main(String[] stringArray) {
        TransformFragments$.MODULE$.main(stringArray);
    }

    public static TransformFragments apply(String[] stringArray) {
        return TransformFragments$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return TransformFragments$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformFragments$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformFragments transformFragments = this;
        synchronized (transformFragments) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$trans$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    public TransformFragmentsArgs args() {
        return this.args;
    }

    public TransformFragments$ companion() {
        return this.companion;
    }

    public FragmentDataset maybeDedupe(FragmentDataset reads) {
        return this.args().markDuplicates() ? reads.markDuplicates() : reads;
    }

    private FragmentDataset maybeBin(FragmentDataset rdd) {
        return (FragmentDataset)Option$.MODULE$.apply((Object)this.args().binQualityScores()).fold((Function0)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final FragmentDataset rdd$1;

            public final FragmentDataset apply() {
                return this.rdd$1;
            }
            {
                this.rdd$1 = rdd$1;
            }
        }, (Function1)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final FragmentDataset rdd$1;

            public final FragmentDataset apply(String binDescription) {
                Seq bins = QualityScoreBin$.MODULE$.apply(binDescription);
                return this.rdd$1.binQualityScores(bins);
            }
            {
                this.rdd$1 = rdd$1;
            }
        });
    }

    public void run(SparkContext sc) {
        FragmentDataset fragmentDataset;
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        if (this.args().loadAsReads() && this.args().saveAsReads()) {
            this.warn((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "If loading and saving as reads, consider using TransformAlignments instead.";
                }
            });
        }
        if (this.args().sortReads()) {
            Predef$.MODULE$.require(this.args().saveAsReads(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "-sort_reads is only valid if -save_as_reads is given.";
                }
            });
        }
        if (this.args().sortLexicographically()) {
            Predef$.MODULE$.require(this.args().saveAsReads(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "-sort_lexicographically is only valid if -save_as_reads is given.";
                }
            });
        }
        if (this.args().maxReadLength() > 0) {
            FastqRecordReader.setMaxReadLength((Configuration)sc.hadoopConfiguration(), (int)this.args().maxReadLength());
        }
        if (this.args().loadAsReads()) {
            ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$1 = this.args().inputPath();
            Option x$2 = qual$1.loadAlignments$default$2();
            Option x$3 = qual$1.loadAlignments$default$3();
            Option x$4 = qual$1.loadAlignments$default$4();
            Option x$5 = qual$1.loadAlignments$default$5();
            ValidationStringency x$6 = qual$1.loadAlignments$default$6();
            fragmentDataset = qual$1.loadAlignments(x$1, x$2, x$3, x$4, x$5, x$6).toFragments();
        } else {
            ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$7 = this.args().inputPath();
            Option x$8 = qual$2.loadFragments$default$2();
            Option x$9 = qual$2.loadFragments$default$3();
            ValidationStringency x$10 = qual$2.loadFragments$default$4();
            fragmentDataset = qual$2.loadFragments(x$7, x$8, x$9, x$10);
        }
        FragmentDataset rdd = fragmentDataset;
        FragmentDataset maybeBinnedReads = this.maybeBin(rdd);
        FragmentDataset maybeDedupedReads = this.maybeDedupe(maybeBinnedReads);
        if (this.args().saveAsReads()) {
            AlignmentRecordDataset readRdd = maybeDedupedReads.toReads();
            AlignmentRecordDataset finalRdd = this.args().sortReads() ? readRdd.sortReadsByReferencePosition() : (this.args().sortLexicographically() ? readRdd.sortReadsByReferencePositionAndIndex() : readRdd);
            finalRdd.save((ADAMSaveAnyArgs)this.args(), this.args().sortReads() || this.args().sortLexicographically());
        } else {
            maybeDedupedReads.saveAsParquet((SaveArgs)this.args());
        }
    }

    public TransformFragments(TransformFragmentsArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = TransformFragments$.MODULE$;
    }
}

