/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformGenotypes$;
import org.bdgenomics.adam.cli.TransformGenotypesArgs;
import org.bdgenomics.adam.converters.VariantContextConverter$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.GenomicDataset;
import org.bdgenomics.adam.rdd.variant.GenotypeDataset;
import org.bdgenomics.adam.rdd.variant.VariantContextDataset;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}r!B\u0001\u0003\u0011\u0003Y\u0011A\u0005+sC:\u001chm\u001c:n\u000f\u0016tw\u000e^=qKNT!a\u0001\u0003\u0002\u0007\rd\u0017N\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0013)J\fgn\u001d4pe6<UM\\8usB,7oE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001c\u001b\u0005A\"BA\u0002\u001a\u0015\tQb!A\u0003vi&d7/\u0003\u0002\u001d1\t\u0019\"\tR$D_6l\u0017M\u001c3D_6\u0004\u0018M\\5p]\")a$\u0004C\u0001?\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\bC5\u0011\r\u0011\"\u0001#\u0003-\u0019w.\\7b]\u0012t\u0015-\\3\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004TiJLgn\u001a\u0005\u0007Y5\u0001\u000b\u0011B\u0012\u0002\u0019\r|W.\\1oI:\u000bW.\u001a\u0011\t\u000f9j!\u0019!C\u0001E\u0005\u00112m\\7nC:$G)Z:de&\u0004H/[8o\u0011\u0019\u0001T\u0002)A\u0005G\u0005\u00192m\\7nC:$G)Z:de&\u0004H/[8oA!)!'\u0004C\u0001g\u0005)\u0011\r\u001d9msR\u0019A'!\u000b\u0011\u00051)d\u0001\u0002\b\u0003\u0001Y\u001a2!N\u001c;!\t!\u0003(\u0003\u0002:K\t1qJ\u00196fGR\u00042aF\u001e>\u0013\ta\u0004DA\bC\t\u001e\u001b\u0006/\u0019:l\u0007>lW.\u00198e!\taa(\u0003\u0002@\u0005\t1BK]1og\u001a|'/\\$f]>$\u0018\u0010]3t\u0003J<7\u000f\u0003\u0005Bk\t\u0015\r\u0011\"\u0001C\u0003\u0011\t'oZ:\u0016\u0003uB\u0001\u0002R\u001b\u0003\u0002\u0003\u0006I!P\u0001\u0006CJ<7\u000f\t\u0005\u0006=U\"\tA\u0012\u000b\u0003i\u001dCQ!Q#A\u0002uBq!S\u001bC\u0002\u0013\u0005!*A\u0005d_6\u0004\u0018M\\5p]V\t1J\u0004\u0002\r\u0001!1Q*\u000eQ\u0001\n-\u000b!bY8na\u0006t\u0017n\u001c8!\u0011\u001dyUG1A\u0005\u0002A\u000b!b\u001d;sS:<WM\\2z+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003!\u0019\u0018-\u001c;p_2\u001c(\"\u0001,\u0002\r!$8O\u001b3l\u0013\tA6K\u0001\u000bWC2LG-\u0019;j_:\u001cFO]5oO\u0016t7-\u001f\u0005\u00075V\u0002\u000b\u0011B)\u0002\u0017M$(/\u001b8hK:\u001c\u0017\u0010\t\u0005\u00069V\"I!X\u0001\u000e[\u0006L(-Z\"pC2,7oY3\u0015\u0005y3\u0007CA0e\u001b\u0005\u0001'BA1c\u0003\u001d1\u0018M]5b]RT!a\u0019\u0003\u0002\u0007I$G-\u0003\u0002fA\nyq)\u001a8pif\u0004X\rR1uCN,G\u000fC\u0003h7\u0002\u0007a,\u0001\u0002eg\")\u0011.\u000eC\u0005U\u0006IQ.Y=cKN{'\u000f^\u000b\u0003W:$2\u0001\\A\u0004!\tig\u000e\u0004\u0001\u0005\u000b=D'\u0019\u00019\u0003\u0003U\u000b\"!\u001d;\u0011\u0005E\u0011\u0018BA:\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u0004D!\u001e>\u0002\u0004A1ao^=\u0002\u00021l\u0011AY\u0005\u0003q\n\u0014abR3o_6L7\rR1uCN,G\u000f\u0005\u0002nu\u0012I1P\\A\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0004?\u0012\n\u0014CA9~!\t\tb0\u0003\u0002\u0000%\t\u0019\u0011I\\=\u0011\u00075\f\u0019\u0001\u0002\u0006\u0002\u00069\f\t\u0011!A\u0003\u0002q\u00141a\u0018\u00133\u0011\u00159\u0007\u000e1\u0001m\u0011\u001d\tY!\u000eC\u0001\u0003\u001b\t1A];o)\u0011\ty!!\u0006\u0011\u0007E\t\t\"C\u0002\u0002\u0014I\u0011A!\u00168ji\"A\u0011qCA\u0005\u0001\u0004\tI\"\u0001\u0002tGB!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012!B:qCJ\\'bAA\u0012\u0011\u00051\u0011\r]1dQ\u0016LA!a\n\u0002\u001e\ta1\u000b]1sW\u000e{g\u000e^3yi\"9\u00111F\u0019A\u0002\u00055\u0012aB2nI2Kg.\u001a\t\u0006#\u0005=\u00121G\u0005\u0004\u0003c\u0011\"!B!se\u0006L\b\u0003BA\u001b\u0003wq1!EA\u001c\u0013\r\tIDE\u0001\u0007!J,G-\u001a4\n\u0007)\niDC\u0002\u0002:I\u0001")
public class TransformGenotypes
implements BDGSparkCommand<TransformGenotypesArgs> {
    private final TransformGenotypesArgs args;
    private final TransformGenotypes$ companion;
    private final ValidationStringency stringency;
    private final transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static void main(String[] stringArray) {
        TransformGenotypes$.MODULE$.main(stringArray);
    }

    public static TransformGenotypes apply(String[] stringArray) {
        return TransformGenotypes$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return TransformGenotypes$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformGenotypes$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformGenotypes transformGenotypes = this;
        synchronized (transformGenotypes) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$trans$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    public TransformGenotypesArgs args() {
        return this.args;
    }

    public TransformGenotypes$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private GenotypeDataset maybeCoalesce(GenotypeDataset ds) {
        GenotypeDataset genotypeDataset;
        if (this.args().coalesce() != -1) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformGenotypes $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.args().coalesce())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            genotypeDataset = this.args().coalesce() > ds.rdd().partitions().length || this.args().forceShuffle() ? (GenotypeDataset)ds.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformGenotypes $outer;

                public final RDD<Genotype> apply(RDD<Genotype> rdd) {
                    int x$1 = this.$outer.args().coalesce();
                    boolean x$2 = true;
                    Option x$3 = rdd.coalesce$default$3();
                    Ordering x$4 = rdd.coalesce$default$4(x$1, x$2, x$3);
                    return rdd.coalesce(x$1, x$2, x$3, x$4);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }) : (GenotypeDataset)ds.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformGenotypes $outer;

                public final RDD<Genotype> apply(RDD<Genotype> rdd) {
                    int x$5 = this.$outer.args().coalesce();
                    boolean x$6 = false;
                    Option x$7 = rdd.coalesce$default$3();
                    Ordering x$8 = rdd.coalesce$default$4(x$5, x$6, x$7);
                    return rdd.coalesce(x$5, x$6, x$7, x$8);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            genotypeDataset = ds;
        }
        return genotypeDataset;
    }

    private <U extends GenomicDataset<?, ?, U>> U maybeSort(U ds) {
        Object object;
        if (this.args().sort()) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sorting before saving";
                }
            });
            object = ds.sort();
        } else if (this.args().sortLexicographically()) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sorting lexicographically before saving";
                }
            });
            object = ds.sortLexicographically();
        } else {
            object = ds;
        }
        return object;
    }

    public void run(SparkContext sc) {
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        Predef$.MODULE$.require(!this.args().sort() || !this.args().sortLexicographically(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot set both -sort_on_save and -sort_lexicographically_on_save.";
            }
        });
        if (this.args().nestedAnnotations()) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Populating the variant.annotation field in the Genotype records";
                }
            });
            sc.hadoopConfiguration().setBoolean(VariantContextConverter$.MODULE$.nestAnnotationInGenotypesProperty(), true);
        }
        GenotypeDataset genotypes = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadGenotypes(this.args().inputPath(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.stringency());
        if (this.args().outputPath().endsWith(".vcf")) {
            VariantContextDataset qual$1 = this.maybeSort(this.maybeCoalesce(genotypes).toVariantContexts());
            TransformGenotypesArgs x$9 = this.args();
            ValidationStringency x$10 = qual$1.saveAsVcf$default$2();
            qual$1.saveAsVcf((ADAMSaveAnyArgs)x$9, x$10);
        } else if (this.args().partitionByStartPos()) {
            GenotypeDataset qual$2 = this.maybeSort(this.maybeCoalesce(genotypes));
            String x$11 = this.args().outputPath();
            int x$12 = this.args().partitionedBinSize();
            CompressionCodecName x$13 = qual$2.saveAsPartitionedParquet$default$2();
            qual$2.saveAsPartitionedParquet(x$11, x$13, x$12);
        } else {
            this.maybeSort(this.maybeCoalesce(genotypes)).saveAsParquet((SaveArgs)this.args());
        }
    }

    public TransformGenotypes(TransformGenotypesArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = TransformGenotypes$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

