/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import java.time.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator$;
import org.bdgenomics.adam.cli.About;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformAlignments$;
import org.bdgenomics.adam.cli.TransformAlignmentsArgs;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.io.FastqRecordReader;
import org.bdgenomics.adam.models.ReadGroupDictionary;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Filter$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.read.AlignmentRecordDataset;
import org.bdgenomics.adam.rdd.read.AlignmentRecordDataset$;
import org.bdgenomics.adam.rdd.read.QualityScoreBin$;
import org.bdgenomics.adam.util.ReferenceFile;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005v!B\u0001\u0003\u0011\u0003Y\u0011a\u0005+sC:\u001chm\u001c:n\u00032LwM\\7f]R\u001c(BA\u0002\u0005\u0003\r\u0019G.\u001b\u0006\u0003\u000b\u0019\tA!\u00193b[*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003'Q\u0013\u0018M\\:g_Jl\u0017\t\\5h]6,g\u000e^:\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/mi\u0011\u0001\u0007\u0006\u0003\u0007eQ!A\u0007\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005qA\"a\u0005\"E\u000f\u000e{W.\\1oI\u000e{W\u000e]1oS>t\u0007\"\u0002\u0010\u000e\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001d\tSB1A\u0005\u0002\t\n1bY8n[\u0006tGMT1nKV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\rM#(/\u001b8h\u0011\u0019aS\u0002)A\u0005G\u0005a1m\\7nC:$g*Y7fA!9a&\u0004b\u0001\n\u0003\u0011\u0013AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:Da\u0001M\u0007!\u0002\u0013\u0019\u0013aE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\"\u0002\u001a\u000e\t\u0003\u0019\u0014!B1qa2LHc\u0001\u001b\u0002\u0018B\u0011A\"\u000e\u0004\u0005\u001d\t\u0001ag\u0005\u00036oi\u0002\u0005C\u0001\u00139\u0013\tITE\u0001\u0004PE*,7\r\u001e\t\u0004/mj\u0014B\u0001\u001f\u0019\u0005=\u0011EiR*qCJ\\7i\\7nC:$\u0007C\u0001\u0007?\u0013\ty$AA\fUe\u0006t7OZ8s[\u0006c\u0017n\u001a8nK:$8/\u0011:hgB\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0006g24GG\u001b\u0006\u0002\u000b\u0006AqM]5{u2,G-\u0003\u0002H\u0005\n9Aj\\4hS:<\u0007\u0002C%6\u0005\u000b\u0007I\u0011\u0003&\u0002\t\u0005\u0014xm]\u000b\u0002{!AA*\u000eB\u0001B\u0003%Q(A\u0003be\u001e\u001c\b\u0005C\u0003\u001fk\u0011\u0005a\n\u0006\u00025\u001f\")\u0011*\u0014a\u0001{!9\u0011+\u000eb\u0001\n\u0003\u0011\u0016!C2p[B\fg.[8o+\u0005\u0019fB\u0001\u0007\u0001\u0011\u0019)V\u0007)A\u0005'\u0006Q1m\\7qC:LwN\u001c\u0011\t\u000f]+$\u0019!C\u00011\u0006Q1\u000f\u001e:j]\u001e,gnY=\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u0011M\fW\u000e^8pYNT\u0011AX\u0001\u0007QR\u001c(\u000eZ6\n\u0005\u0001\\&\u0001\u0006,bY&$\u0017\r^5p]N#(/\u001b8hK:\u001c\u0017\u0010\u0003\u0004ck\u0001\u0006I!W\u0001\fgR\u0014\u0018N\\4f]\u000eL\b\u0005C\u0003ek\u0011%Q-\u0001\u0005nCf\u0014WMQ5o)\t1g\u000e\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!!/Z1e\u0015\tYG!A\u0002sI\u0012L!!\u001c5\u0003-\u0005c\u0017n\u001a8nK:$(+Z2pe\u0012$\u0015\r^1tKRDQa[2A\u0002\u0019DQ\u0001]\u001b\u0005\nE\f\u0001#\\1zE\u0016\u0014V\r]1si&$\u0018n\u001c8\u0015\u0005\u0019\u0014\b\"B:p\u0001\u00041\u0017A\u00013t\u0011\u0015)X\u0007\"\u0003w\u0003-i\u0017-\u001f2f\t\u0016$W\u000f]3\u0015\u0005\u0019<\b\"B:u\u0001\u00041\u0007\"B=6\t\u0013Q\u0018\u0001D7bs\n,'+Z1mS\u001etGC\u00024|\u0003\u0017\ti\u0001C\u0003}q\u0002\u0007Q0\u0001\u0002tGB\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005)1\u000f]1sW*\u0019\u0011Q\u0001\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\tIa \u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006gb\u0004\rA\u001a\u0005\b\u0003\u001fA\b\u0019AA\t\u0003\t\u0019H\u000e\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9b`\u0001\bgR|'/Y4f\u0013\u0011\tY\"!\u0006\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000f\u0005}Q\u0007\"\u0003\u0002\"\u0005\u0001R.Y=cKJ+7-\u00197jEJ\fG/\u001a\u000b\u0006M\u0006\r\u0012Q\u0005\u0005\u0007g\u0006u\u0001\u0019\u00014\t\u0011\u0005=\u0011Q\u0004a\u0001\u0003#Aq!!\u000b6\t\u0013\tY#A\u0007nCf\u0014WmQ8bY\u0016\u001c8-\u001a\u000b\u0004M\u00065\u0002BB:\u0002(\u0001\u0007a\rC\u0004\u00022U\"I!a\r\u0002\u00135\f\u0017PY3T_J$H#\u00024\u00026\u0005]\u0002BB:\u00020\u0001\u0007a\r\u0003\u0005\u0002\u0010\u0005=\u0002\u0019AA\t\u0011\u001d\tY$\u000eC\u0005\u0003{\t!\"\\1zE\u0016lE\rV1h)\u001d1\u0017qHA!\u0003\u0007Ba\u0001`A\u001d\u0001\u0004i\bBB:\u0002:\u0001\u0007a\r\u0003\u0005\u0002F\u0005e\u0002\u0019AA$\u00035\u0019HO]5oO\u0016t7-_(qiB!\u0011#!\u0013Z\u0013\r\tYE\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\rI*D\u0011AA()\r1\u0017\u0011\u000b\u0005\u0007g\u00065\u0003\u0019\u00014\t\u000f\u0005US\u0007\"\u0001\u0002X\u0005yam\u001c:dK:{g\u000eU1scV,G\u000f\u0006\u0002\u0002ZA\u0019\u0011#a\u0017\n\u0007\u0005u#CA\u0004C_>dW-\u00198\t\u000f\u0005\u0005T\u0007\"\u0001\u0002d\u0005a\u0011n\u001d(p]B\u000b'/];fiR!\u0011\u0011LA3\u0011!\t9'a\u0018A\u0002\u0005%\u0014!C5oaV$\b+\u0019;i!\u0011\tY'!\u001d\u000f\u0007E\ti'C\u0002\u0002pI\ta\u0001\u0015:fI\u00164\u0017b\u0001\u0016\u0002t)\u0019\u0011q\u000e\n\t\u000f\u0005]T\u0007\"\u0001\u0002z\u0005\u0019!/\u001e8\u0015\t\u0005m\u0014\u0011\u0011\t\u0004#\u0005u\u0014bAA@%\t!QK\\5u\u0011\u0019a\u0018Q\u000fa\u0001{\"9\u0011QQ\u001b\u0005\n\u0005\u001d\u0015\u0001F2sK\u0006$Xm\u00138po:\u001cf\u000e]:UC\ndW\r\u0006\u0003\u0002\n\u0006U\u0005\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=E!\u0001\u0004n_\u0012,Gn]\u0005\u0005\u0003'\u000biI\u0001\u0005T]B$\u0016M\u00197f\u0011\u0019a\u00181\u0011a\u0001{\"9\u0011\u0011T\u0019A\u0002\u0005m\u0015aB2nI2Kg.\u001a\t\u0006#\u0005u\u0015\u0011N\u0005\u0004\u0003?\u0013\"!B!se\u0006L\b")
public class TransformAlignments
implements BDGSparkCommand<TransformAlignmentsArgs> {
    private final TransformAlignmentsArgs args;
    private final TransformAlignments$ companion;
    private final ValidationStringency stringency;
    private final transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static void main(String[] stringArray) {
        TransformAlignments$.MODULE$.main(stringArray);
    }

    public static String commandDescription() {
        return TransformAlignments$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformAlignments$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformAlignments transformAlignments = this;
        synchronized (transformAlignments) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$trans$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    public TransformAlignmentsArgs args() {
        return this.args;
    }

    public TransformAlignments$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private AlignmentRecordDataset maybeBin(AlignmentRecordDataset rdd) {
        return (AlignmentRecordDataset)Option$.MODULE$.apply((Object)this.args().binQualityScores()).fold((Function0)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordDataset rdd$1;

            public final AlignmentRecordDataset apply() {
                return this.rdd$1;
            }
            {
                this.rdd$1 = rdd$1;
            }
        }, (Function1)new Serializable(this, rdd){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordDataset rdd$1;

            public final AlignmentRecordDataset apply(String binDescription) {
                Seq bins = QualityScoreBin$.MODULE$.apply(binDescription);
                return this.rdd$1.binQualityScores(bins);
            }
            {
                this.rdd$1 = rdd$1;
            }
        });
    }

    private AlignmentRecordDataset maybeRepartition(AlignmentRecordDataset ds) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().repartition() != -1) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.args().repartition())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            alignmentRecordDataset = (AlignmentRecordDataset)ds.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rdd) {
                    int x$5 = this.$outer.args().repartition();
                    Ordering x$6 = rdd.repartition$default$2(x$5);
                    return rdd.repartition(x$5, x$6);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordDataset = ds;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeDedupe(AlignmentRecordDataset ds) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().markDuplicates()) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Marking duplicates";
                }
            });
            alignmentRecordDataset = ds.markDuplicates();
        } else {
            alignmentRecordDataset = ds;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeRealign(SparkContext sc, AlignmentRecordDataset ds, StorageLevel sl) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().locallyRealign()) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Locally realigning indels.";
                }
            });
            Object object = this.args().cache() ? ds.rdd().persist(sl) : BoxedUnit.UNIT;
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsensusGenerator apply() {
                    return ConsensusGenerator$.MODULE$.fromReads();
                }
            }, (Function1)new Serializable(this, ds){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordDataset ds$1;

                public final ConsensusGenerator apply(String file) {
                    ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.ds$1.rdd().context());
                    String x$7 = file;
                    Option x$8 = qual$1.loadVariants$default$2();
                    Option x$9 = qual$1.loadVariants$default$3();
                    ValidationStringency x$10 = qual$1.loadVariants$default$4();
                    return ConsensusGenerator$.MODULE$.fromKnownIndels(qual$1.loadVariants(x$7, x$8, x$9, x$10));
                }
                {
                    this.ds$1 = ds$1;
                }
            });
            Option optReferenceFile = Option$.MODULE$.apply((Object)this.args().reference()).map((Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;
                private final SparkContext sc$1;

                public final ReferenceFile apply(String f) {
                    return ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$1).loadReferenceFile(f, this.$outer.args().mdTagsFragmentSize());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sc$1 = sc$1;
                }
            });
            ConsensusGenerator x$11 = consensusGenerator;
            boolean x$12 = false;
            int x$13 = this.args().maxIndelSize();
            int x$14 = this.args().maxConsensusNumber();
            double x$15 = this.args().lodThreshold();
            int x$16 = this.args().maxTargetSize();
            int x$17 = this.args().maxReadsPerTarget();
            Option x$18 = optReferenceFile;
            boolean x$19 = this.args().unclipReads();
            AlignmentRecordDataset realignmentDs = ds.realignIndels(x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$19, x$18);
            Object object2 = this.args().cache() ? ds.rdd().unpersist(ds.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordDataset = realignmentDs;
        } else {
            alignmentRecordDataset = ds;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeRecalibrate(AlignmentRecordDataset ds, StorageLevel sl) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().recalibrateBaseQualities()) {
            AlignmentRecordDataset bqsredDs;
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Recalibrating base qualities";
                }
            });
            None$ optSl = this.args().cache() ? new Some((Object)sl) : None$.MODULE$;
            SnpTable knownSnps = this.createKnownSnpsTable(ds.rdd().context());
            Broadcast broadcastedSnps = (Broadcast)Timers$.MODULE$.BroadcastingKnownSnps().time((Function0)new Serializable(this, ds, knownSnps){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordDataset ds$2;
                private final SnpTable knownSnps$1;

                public final Broadcast<SnpTable> apply() {
                    return this.ds$2.rdd().context().broadcast((Object)this.knownSnps$1, ClassTag$.MODULE$.apply(SnpTable.class));
                }
                {
                    this.ds$2 = ds$2;
                    this.knownSnps$1 = knownSnps$1;
                }
            });
            alignmentRecordDataset = bqsredDs = ds.recalibrateBaseQualities(broadcastedSnps, this.args().minAcceptableQuality(), (Option)optSl, Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.args().samplingFraction())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(double x$1) {
                    return this.apply$mcZD$sp(x$1);
                }

                public boolean apply$mcZD$sp(double x$1) {
                    return x$1 > 0.0;
                }
            }), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.args().samplingSeed())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(long x$2) {
                    return this.apply$mcZJ$sp(x$2);
                }

                public boolean apply$mcZJ$sp(long x$2) {
                    return x$2 != 0L;
                }
            }));
        } else {
            alignmentRecordDataset = ds;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeCoalesce(AlignmentRecordDataset ds) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().coalesce() != -1) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.args().coalesce())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            alignmentRecordDataset = this.args().coalesce() > ds.rdd().partitions().length || this.args().forceShuffle() ? (AlignmentRecordDataset)ds.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rdd) {
                    int x$20 = this.$outer.args().coalesce();
                    boolean x$21 = true;
                    Option x$22 = rdd.coalesce$default$3();
                    Ordering x$23 = rdd.coalesce$default$4(x$20, x$21, x$22);
                    return rdd.coalesce(x$20, x$21, x$22, x$23);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }) : (AlignmentRecordDataset)ds.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rdd) {
                    int x$24 = this.$outer.args().coalesce();
                    boolean x$25 = false;
                    Option x$26 = rdd.coalesce$default$3();
                    Ordering x$27 = rdd.coalesce$default$4(x$24, x$25, x$26);
                    return rdd.coalesce(x$24, x$25, x$26, x$27);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordDataset = ds;
        }
        return alignmentRecordDataset;
    }

    /*
     * WARNING - void declaration
     */
    private AlignmentRecordDataset maybeSort(AlignmentRecordDataset ds, StorageLevel sl) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().sortByReadName() || this.args().sortByReferencePosition() || this.args().sortByReferencePositionAndIndex()) {
            void var3_3;
            AlignmentRecordDataset alignmentRecordDataset2;
            Object object = this.args().cache() ? ds.rdd().persist(sl) : BoxedUnit.UNIT;
            if (this.args().sortByReadName()) {
                this.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Sorting alignments by read name";
                    }
                });
                alignmentRecordDataset2 = ds.sortByReadName();
            } else if (this.args().sortByReferencePosition()) {
                this.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Sorting alignments by reference position, with references ordered by name";
                    }
                });
                alignmentRecordDataset2 = ds.sortByReferencePosition();
            } else {
                this.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Sorting alignments by reference position, with references ordered by index";
                    }
                });
                alignmentRecordDataset2 = ds.sortByReferencePositionAndIndex();
            }
            AlignmentRecordDataset sortedDs = alignmentRecordDataset2;
            Object object2 = this.args().cache() ? ds.rdd().unpersist(ds.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordDataset = var3_3;
        } else {
            alignmentRecordDataset = ds;
        }
        return alignmentRecordDataset;
    }

    private AlignmentRecordDataset maybeMdTag(SparkContext sc, AlignmentRecordDataset ds, Option<ValidationStringency> stringencyOpt) {
        AlignmentRecordDataset alignmentRecordDataset;
        if (this.args().mdTagsReferenceFile() == null) {
            alignmentRecordDataset = ds;
        } else {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformAlignments $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding MDTags to reads based on reference file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.args().mdTagsReferenceFile()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ReferenceFile referenceFile = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadReferenceFile(this.args().mdTagsReferenceFile(), this.args().mdTagsFragmentSize());
            alignmentRecordDataset = ds.computeMismatchingPositions(referenceFile, this.args().mdTagsOverwrite(), (ValidationStringency)stringencyOpt.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ValidationStringency apply() {
                    return ValidationStringency.STRICT;
                }
            }));
        }
        return alignmentRecordDataset;
    }

    public AlignmentRecordDataset apply(AlignmentRecordDataset ds) {
        SparkContext sc = ds.rdd().context();
        StorageLevel sl = StorageLevel$.MODULE$.fromString(this.args().storageLevel());
        Option stringencyOpt = Option$.MODULE$.apply((Object)this.args().stringency()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidationStringency apply(String x$3) {
                return ValidationStringency.valueOf((String)x$3);
            }
        });
        if (this.args().maxReadLength() > 0) {
            FastqRecordReader.setMaxReadLength((Configuration)sc.hadoopConfiguration(), (int)this.args().maxReadLength());
        }
        AlignmentRecordDataset initialDs = this.maybeRepartition(ds);
        AlignmentRecordDataset binnedDs = this.maybeBin(initialDs);
        AlignmentRecordDataset maybeDedupedDs = this.maybeDedupe(binnedDs);
        AlignmentRecordDataset maybeRealignedDs = this.maybeRealign(sc, maybeDedupedDs, sl);
        AlignmentRecordDataset maybeRecalibratedDs = this.maybeRecalibrate(maybeRealignedDs, sl);
        AlignmentRecordDataset finalPreprocessedDs = this.maybeCoalesce(maybeRecalibratedDs);
        AlignmentRecordDataset maybeSortedDs = this.maybeSort(finalPreprocessedDs, sl);
        return this.maybeMdTag(sc, maybeSortedDs, (Option<ValidationStringency>)stringencyOpt);
    }

    public boolean forceNonParquet() {
        return this.args().forceLoadBam() || this.args().forceLoadFastq() || this.args().forceLoadIFastq();
    }

    public boolean isNonParquet(String inputPath) {
        return inputPath.endsWith(".sam") || inputPath.endsWith(".bam") || inputPath.endsWith(".ifq") || inputPath.endsWith(".fq") || inputPath.endsWith(".fastq") || inputPath.endsWith(".fa") || inputPath.endsWith(".fasta");
    }

    public void run(SparkContext sc) {
        AlignmentRecordDataset alignmentRecordDataset;
        AlignmentRecordDataset loadedDs;
        AlignmentRecordDataset alignmentRecordDataset2;
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        if (this.args().useAlignedReadPredicate() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet force load flag was passed");
        }
        if (this.args().limitProjection() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet force load flag was passed");
        }
        if (this.args().useAlignedReadPredicate() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet input path was specified");
        }
        if (this.args().limitProjection() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet input path was specified");
        }
        if (this.args().useAlignedReadPredicate() && this.args().regionPredicate() != null) {
            throw new IllegalArgumentException("-aligned_read_predicate and -region_predicate are mutually exclusive");
        }
        if (((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{this.args().sortByReadName(), this.args().sortByReferencePosition(), this.args().sortByReferencePositionAndIndex()}))).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean b) {
                return b;
            }
        }) > 1) {
            throw new IllegalArgumentException("only one of -sort_by_name, -sort_by_reference_position, and -sort_by_reference_position_and_index may be specified");
        }
        if (this.args().forceLoadBam()) {
            if (this.args().regionPredicate() == null) {
                ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$31 = this.args().inputPath();
                ValidationStringency x$32 = qual$3.loadBam$default$2();
                alignmentRecordDataset2 = qual$3.loadBam(x$31, x$32);
            } else {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$28 = this.args().inputPath();
                Iterable x$29 = loci;
                ValidationStringency x$30 = qual$2.loadIndexedBam$default$3();
                alignmentRecordDataset2 = qual$2.loadIndexedBam(x$28, x$29, x$30, Predef.DummyImplicit$.MODULE$.dummyImplicit());
            }
        } else if (this.args().forceLoadFastq()) {
            alignmentRecordDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFastq(this.args().inputPath(), Option$.MODULE$.apply((Object)this.args().pairedFastqFile()), Option$.MODULE$.apply((Object)this.args().fastqReadGroup()), this.stringency());
        } else if (this.args().forceLoadIFastq()) {
            alignmentRecordDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(this.args().inputPath());
        } else if (this.args().forceLoadParquet() || this.args().useAlignedReadPredicate() || this.args().limitProjection()) {
            Some pred = this.args().useAlignedReadPredicate() ? new Some((Object)FilterApi.eq((Operators.Column)FilterApi.booleanColumn((String)"readMapped"), (Comparable)Predef$.MODULE$.boolean2Boolean(true))) : (this.args().regionPredicate() == null ? None$.MODULE$ : new Some((Object)ReferenceRegion$.MODULE$.createPredicate(ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate()).toSeq())));
            None$ proj = this.args().limitProjection() ? new Some((Object)Filter$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.attributes(), AlignmentRecordField$.MODULE$.originalQuality()}))) : None$.MODULE$;
            alignmentRecordDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadParquetAlignments(this.args().inputPath(), (Option)pred, (Option)proj);
        } else {
            ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$33 = this.args().inputPath();
            Option x$34 = Option$.MODULE$.apply((Object)this.args().pairedFastqFile());
            Option x$35 = Option$.MODULE$.apply((Object)this.args().fastqReadGroup());
            ValidationStringency x$36 = this.stringency();
            Option x$37 = qual$4.loadAlignments$default$4();
            Option x$38 = qual$4.loadAlignments$default$5();
            AlignmentRecordDataset loadedReads = qual$4.loadAlignments(x$33, x$34, x$35, x$37, x$38, x$36);
            if (this.args().regionPredicate() == null) {
                alignmentRecordDataset2 = loadedReads;
            } else {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                alignmentRecordDataset2 = loadedDs = (AlignmentRecordDataset)loadedReads.filterByOverlappingRegions(loci);
            }
        }
        if (this.args().disableProcessingStep()) {
            alignmentRecordDataset = loadedDs;
        } else {
            About about = new About();
            String version = about.isSnapshot() ? new StringOps(Predef$.MODULE$.augmentString("%s--%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{about.version(), about.commit()})) : about.version();
            long epoch = Instant.now().getEpochSecond();
            ProcessingStep processingStep = ProcessingStep.newBuilder().setId(new StringOps(Predef$.MODULE$.augmentString("ADAM_%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epoch)}))).setProgramName("org.bdgenomics.adam.cli.TransformAlignments").setVersion(version).setCommandLine(this.args().command()).build();
            alignmentRecordDataset = (AlignmentRecordDataset)loadedDs.addProcessingStep(processingStep);
        }
        AlignmentRecordDataset aDs = alignmentRecordDataset;
        RDD rdd = aDs.rdd();
        SequenceDictionary sd = aDs.sequences();
        ReadGroupDictionary rgd = aDs.readGroups();
        Seq pgs = aDs.processingSteps();
        Option concatOpt = Option$.MODULE$.apply((Object)this.args().concatFilename()).map((Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransformAlignments $outer;
            private final SparkContext sc$3;

            public final AlignmentRecordDataset apply(String concatFilename) {
                AlignmentRecordDataset alignmentRecordDataset;
                if (this.$outer.args().forceLoadBam()) {
                    ADAMContext qual$5 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$39 = concatFilename;
                    ValidationStringency x$40 = qual$5.loadBam$default$2();
                    alignmentRecordDataset = qual$5.loadBam(x$39, x$40);
                } else if (this.$outer.args().forceLoadIFastq()) {
                    alignmentRecordDataset = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3).loadInterleavedFastq(concatFilename);
                } else if (this.$outer.args().forceLoadParquet()) {
                    ADAMContext qual$6 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$41 = concatFilename;
                    Option x$42 = qual$6.loadParquetAlignments$default$2();
                    Option x$43 = qual$6.loadParquetAlignments$default$3();
                    alignmentRecordDataset = qual$6.loadParquetAlignments(x$41, x$42, x$43);
                } else {
                    ADAMContext qual$7 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$3);
                    String x$44 = concatFilename;
                    Option x$45 = Option$.MODULE$.apply((Object)this.$outer.args().fastqReadGroup());
                    Option x$46 = qual$7.loadAlignments$default$2();
                    Option x$47 = qual$7.loadAlignments$default$4();
                    Option x$48 = qual$7.loadAlignments$default$5();
                    ValidationStringency x$49 = qual$7.loadAlignments$default$6();
                    alignmentRecordDataset = qual$7.loadAlignments(x$44, x$46, x$45, x$47, x$48, x$49);
                }
                return alignmentRecordDataset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sc$3 = sc$3;
            }
        });
        Tuple4 tuple4 = (Tuple4)concatOpt.fold((Function0)new Serializable(this, rdd, sd, rgd, pgs){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$2;
            private final SequenceDictionary sd$1;
            private final ReadGroupDictionary rgd$1;
            private final Seq pgs$1;

            public final Tuple4<RDD<AlignmentRecord>, SequenceDictionary, ReadGroupDictionary, Seq<ProcessingStep>> apply() {
                return new Tuple4((Object)this.rdd$2, (Object)this.sd$1, (Object)this.rgd$1, (Object)this.pgs$1);
            }
            {
                this.rdd$2 = rdd$2;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
                this.pgs$1 = pgs$1;
            }
        }, (Function1)new Serializable(this, rdd, sd, rgd, pgs){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$2;
            private final SequenceDictionary sd$1;
            private final ReadGroupDictionary rgd$1;
            private final Seq pgs$1;

            public final Tuple4<RDD<AlignmentRecord>, SequenceDictionary, ReadGroupDictionary, Seq<ProcessingStep>> apply(AlignmentRecordDataset t) {
                return new Tuple4((Object)this.rdd$2.$plus$plus(t.rdd()), (Object)this.sd$1.$plus$plus(t.sequences()), (Object)this.rgd$1.$plus$plus(t.readGroups()), this.pgs$1.$plus$plus((GenTraversableOnce)t.processingSteps(), Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.rdd$2 = rdd$2;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
                this.pgs$1 = pgs$1;
            }
        });
        if (tuple4 != null) {
            SequenceDictionary sdFinal;
            Tuple4 tuple42;
            RDD mergedRdd = (RDD)tuple4._1();
            SequenceDictionary mergedSd = (SequenceDictionary)tuple4._2();
            ReadGroupDictionary mergedRgd = (ReadGroupDictionary)tuple4._3();
            Seq mergedPgs = (Seq)tuple4._4();
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)mergedRdd, (Object)mergedSd, (Object)mergedRgd, (Object)mergedPgs);
            RDD mergedRdd2 = (RDD)tuple43._1();
            SequenceDictionary mergedSd2 = (SequenceDictionary)tuple43._2();
            ReadGroupDictionary mergedRgd2 = (ReadGroupDictionary)tuple43._3();
            Seq mergedPgs2 = (Seq)tuple43._4();
            AlignmentRecordDataset newDs = AlignmentRecordDataset$.MODULE$.apply(mergedRdd2, mergedSd2, mergedRgd2, mergedPgs2);
            AlignmentRecordDataset outputDs = this.apply(newDs);
            SequenceDictionary sequenceDictionary = sdFinal = this.args().sortByReferencePosition() ? mergedSd2.stripIndices().sorted() : mergedSd2;
            if (this.args().partitionByStartPos()) {
                if (outputDs.sequences().isEmpty()) {
                    this.warn((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "This dataset is not aligned and therefore will not benefit from being saved as a partitioned dataset";
                        }
                    });
                }
                String x$50 = this.args().outputPath();
                int x$51 = this.args().partitionedBinSize();
                CompressionCodecName x$52 = outputDs.saveAsPartitionedParquet$default$2();
                outputDs.saveAsPartitionedParquet(x$50, x$52, x$51);
            } else {
                outputDs.save((ADAMSaveAnyArgs)this.args(), this.args().sortByReadName() || this.args().sortByReferencePosition() || this.args().sortByReferencePositionAndIndex());
            }
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    private SnpTable createKnownSnpsTable(SparkContext sc) {
        return (SnpTable)Option$.MODULE$.apply((Object)this.args().knownSnpsFile()).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SnpTable apply() {
                return SnpTable$.MODULE$.apply();
            }
        }, (Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;

            public final SnpTable apply(String f) {
                ADAMContext qual$8 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2);
                String x$53 = f;
                Option x$54 = qual$8.loadVariants$default$2();
                Option x$55 = qual$8.loadVariants$default$3();
                ValidationStringency x$56 = qual$8.loadVariants$default$4();
                return SnpTable$.MODULE$.apply(qual$8.loadVariants(x$53, x$54, x$55, x$56));
            }
            {
                this.sc$2 = sc$2;
            }
        });
    }

    public TransformAlignments(TransformAlignmentsArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = TransformAlignments$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

