/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformVariants$;
import org.bdgenomics.adam.cli.TransformVariantsArgs;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.GenomicDataset;
import org.bdgenomics.adam.rdd.variant.VariantDataset;
import org.bdgenomics.adam.util.FileExtensions$;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}r!B\u0001\u0003\u0011\u0003Y\u0011!\u0005+sC:\u001chm\u001c:n-\u0006\u0014\u0018.\u00198ug*\u00111\u0001B\u0001\u0004G2L'BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qBA\tUe\u0006t7OZ8s[Z\u000b'/[1oiN\u001c2!\u0004\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011qcG\u0007\u00021)\u00111!\u0007\u0006\u00035\u0019\tQ!\u001e;jYNL!\u0001\b\r\u0003'\t#uiQ8n[\u0006tGmQ8na\u0006t\u0017n\u001c8\t\u000byiA\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005Y\u0001bB\u0011\u000e\u0005\u0004%\tAI\u0001\fG>lW.\u00198e\u001d\u0006lW-F\u0001$!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003mC:<'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012aa\u0015;sS:<\u0007B\u0002\u0017\u000eA\u0003%1%\u0001\u0007d_6l\u0017M\u001c3OC6,\u0007\u0005C\u0004/\u001b\t\u0007I\u0011\u0001\u0012\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\u001c\u0005\u0007a5\u0001\u000b\u0011B\u0012\u0002'\r|W.\\1oI\u0012+7o\u0019:jaRLwN\u001c\u0011\t\u000bIjA\u0011A\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007Q\nI\u0003\u0005\u0002\rk\u0019!aB\u0001\u00017'\r)tG\u000f\t\u0003IaJ!!O\u0013\u0003\r=\u0013'.Z2u!\r92(P\u0005\u0003ya\u0011qB\u0011#H'B\f'o[\"p[6\fg\u000e\u001a\t\u0003\u0019yJ!a\u0010\u0002\u0003+Q\u0013\u0018M\\:g_Jlg+\u0019:jC:$8/\u0011:hg\"A\u0011)\u000eBC\u0002\u0013\u0005!)\u0001\u0003be\u001e\u001cX#A\u001f\t\u0011\u0011+$\u0011!Q\u0001\nu\nQ!\u0019:hg\u0002BQAH\u001b\u0005\u0002\u0019#\"\u0001N$\t\u000b\u0005+\u0005\u0019A\u001f\t\u000f%+$\u0019!C\u0001\u0015\u0006I1m\\7qC:LwN\\\u000b\u0002\u0017:\u0011A\u0002\u0001\u0005\u0007\u001bV\u0002\u000b\u0011B&\u0002\u0015\r|W\u000e]1oS>t\u0007\u0005C\u0004Pk\t\u0007I\u0011\u0001)\u0002\u0015M$(/\u001b8hK:\u001c\u00170F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0005tC6$xn\u001c7t\u0015\u00051\u0016A\u00025ug*$7.\u0003\u0002Y'\n!b+\u00197jI\u0006$\u0018n\u001c8TiJLgnZ3oGfDaAW\u001b!\u0002\u0013\t\u0016aC:ue&tw-\u001a8ds\u0002BQ\u0001X\u001b\u0005\nu\u000bQ\"\\1zE\u0016\u001cu.\u00197fg\u000e,GC\u00010g!\tyF-D\u0001a\u0015\t\t'-A\u0004wCJL\u0017M\u001c;\u000b\u0005\r$\u0011a\u0001:eI&\u0011Q\r\u0019\u0002\u000f-\u0006\u0014\u0018.\u00198u\t\u0006$\u0018m]3u\u0011\u001597\f1\u0001_\u0003\t!7\u000fC\u0003jk\u0011%!.A\u0005nCf\u0014WmU8siV\u00111N\u001c\u000b\u0004Y\u0006\u001d\u0001CA7o\u0019\u0001!Qa\u001c5C\u0002A\u0014\u0011!V\t\u0003cR\u0004\"!\u0005:\n\u0005M\u0014\"a\u0002(pi\"Lgn\u001a\u0019\u0005kj\f\u0019\u0001\u0005\u0004wof\f\t\u0001\\\u0007\u0002E&\u0011\u0001P\u0019\u0002\u000f\u000f\u0016tw.\\5d\t\u0006$\u0018m]3u!\ti'\u0010B\u0005|]\u0006\u0005\t\u0011!B\u0001y\n\u0019q\fJ\u0019\u0012\u0005El\bCA\t\u007f\u0013\ty(CA\u0002B]f\u00042!\\A\u0002\t)\t)A\\A\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0004?\u0012\u0012\u0004\"B4i\u0001\u0004a\u0007bBA\u0006k\u0011\u0005\u0011QB\u0001\u0004eVtG\u0003BA\b\u0003+\u00012!EA\t\u0013\r\t\u0019B\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0018\u0005%\u0001\u0019AA\r\u0003\t\u00198\r\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u000bM\u0004\u0018M]6\u000b\u0007\u0005\r\u0002\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003O\tiB\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0002,E\u0002\r!!\f\u0002\u000f\rlG\rT5oKB)\u0011#a\f\u00024%\u0019\u0011\u0011\u0007\n\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005U\u00121\b\b\u0004#\u0005]\u0012bAA\u001d%\u00051\u0001K]3eK\u001aL1AKA\u001f\u0015\r\tID\u0005")
public class TransformVariants
implements BDGSparkCommand<TransformVariantsArgs> {
    private final TransformVariantsArgs args;
    private final TransformVariants$ companion;
    private final ValidationStringency stringency;
    private final transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static void main(String[] stringArray) {
        TransformVariants$.MODULE$.main(stringArray);
    }

    public static TransformVariants apply(String[] stringArray) {
        return TransformVariants$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return TransformVariants$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformVariants$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformVariants transformVariants = this;
        synchronized (transformVariants) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$trans$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    public TransformVariantsArgs args() {
        return this.args;
    }

    public TransformVariants$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private VariantDataset maybeCoalesce(VariantDataset ds) {
        VariantDataset variantDataset;
        if (this.args().coalesce() != -1) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformVariants $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.args().coalesce())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            variantDataset = this.args().coalesce() > ds.rdd().partitions().length || this.args().forceShuffle() ? (VariantDataset)ds.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformVariants $outer;

                public final RDD<Variant> apply(RDD<Variant> rdd) {
                    int x$1 = this.$outer.args().coalesce();
                    boolean x$2 = true;
                    Option x$3 = rdd.coalesce$default$3();
                    Ordering x$4 = rdd.coalesce$default$4(x$1, x$2, x$3);
                    return rdd.coalesce(x$1, x$2, x$3, x$4);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }) : (VariantDataset)ds.transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransformVariants $outer;

                public final RDD<Variant> apply(RDD<Variant> rdd) {
                    int x$5 = this.$outer.args().coalesce();
                    boolean x$6 = false;
                    Option x$7 = rdd.coalesce$default$3();
                    Ordering x$8 = rdd.coalesce$default$4(x$5, x$6, x$7);
                    return rdd.coalesce(x$5, x$6, x$7, x$8);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            variantDataset = ds;
        }
        return variantDataset;
    }

    private <U extends GenomicDataset<?, ?, U>> U maybeSort(U ds) {
        Object object;
        if (this.args().sort()) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sorting before saving";
                }
            });
            object = ds.sort();
        } else if (this.args().sortLexicographically()) {
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sorting lexicographically before saving";
                }
            });
            object = ds.sortLexicographically();
        } else {
            object = ds;
        }
        return object;
    }

    public void run(SparkContext sc) {
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        Predef$.MODULE$.require(!this.args().sort() || !this.args().sortLexicographically(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot set both -sort_on_save and -sort_lexicographically_on_save.";
            }
        });
        VariantDataset variants = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadVariants(this.args().inputPath(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.stringency());
        if (FileExtensions$.MODULE$.isVcfExt(this.args().outputPath())) {
            this.maybeSort(this.maybeCoalesce(variants).toVariantContexts()).saveAsVcf((ADAMSaveAnyArgs)this.args(), this.stringency());
        } else if (this.args().partitionByStartPos()) {
            VariantDataset qual$1 = this.maybeSort(this.maybeCoalesce(variants));
            String x$9 = this.args().outputPath();
            int x$10 = this.args().partitionedBinSize();
            CompressionCodecName x$11 = qual$1.saveAsPartitionedParquet$default$2();
            qual$1.saveAsPartitionedParquet(x$9, x$11, x$10);
        } else {
            this.maybeSort(this.maybeCoalesce(variants)).saveAsParquet((SaveArgs)this.args());
        }
    }

    public TransformVariants(TransformVariantsArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = TransformVariants$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

