/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.bdgenomics.adam.cli.Fasta2ADAM$;
import org.bdgenomics.adam.cli.Fasta2ADAMArgs;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.contig.NucleotideContigFragmentDataset;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M<Qa\u0004\t\t\u0002e1Qa\u0007\t\t\u0002qAQAK\u0001\u0005\u0002-Bq\u0001L\u0001C\u0002\u0013\u0005Q\u0006\u0003\u0004:\u0003\u0001\u0006IA\f\u0005\bu\u0005\u0011\r\u0011\"\u0001.\u0011\u0019Y\u0014\u0001)A\u0005]!)A(\u0001C\u0001{\u0019!1\u0004\u0005\u0001@\u0011!1\u0006B!b\u0001\n#9\u0006\u0002\u0003-\t\u0005\u0003\u0005\u000b\u0011B&\t\u000b)BA\u0011A-\t\u000fmC!\u0019!C\u00019\"1a\f\u0003Q\u0001\nuCQa\u0018\u0005\u0005\u0002\u0001\f!BR1ti\u0006\u0014\u0014\tR!N\u0015\t\t\"#A\u0002dY&T!a\u0005\u000b\u0002\t\u0005$\u0017-\u001c\u0006\u0003+Y\t!B\u00193hK:|W.[2t\u0015\u00059\u0012aA8sO\u000e\u0001\u0001C\u0001\u000e\u0002\u001b\u0005\u0001\"A\u0003$bgR\f''\u0011#B\u001bN\u0019\u0011!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\t!\u0003&D\u0001&\u0015\t\tbE\u0003\u0002()\u0005)Q\u000f^5mg&\u0011\u0011&\n\u0002\u0014\u0005\u0012;5i\\7nC:$7i\\7qC:LwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\t1bY8n[\u0006tGMT1nKV\ta\u0006\u0005\u00020m9\u0011\u0001\u0007\u000e\t\u0003c}i\u0011A\r\u0006\u0003ga\ta\u0001\u0010:p_Rt\u0014BA\u001b \u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Uz\u0012\u0001D2p[6\fg\u000e\u001a(b[\u0016\u0004\u0013AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\f1cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0002\nQ!\u00199qYf$\"A\u00108\u0011\u0005iA1\u0003\u0002\u0005A\u0011:\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\t1\fgn\u001a\u0006\u0002\u000b\u0006!!.\u0019<b\u0013\t9%I\u0001\u0004PE*,7\r\u001e\t\u0004I%[\u0015B\u0001&&\u0005=\u0011EiR*qCJ\\7i\\7nC:$\u0007C\u0001\u000eM\u0013\ti\u0005C\u0001\bGCN$\u0018MM!E\u00036\u000b%oZ:\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016!B:mMRR'\"A*\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0016)\u0003\u000f1{wmZ5oO\u0006!\u0011M]4t+\u0005Y\u0015!B1sON\u0004CC\u0001 [\u0011\u001516\u00021\u0001L\u0003%\u0019w.\u001c9b]&|g.F\u0001^\u001d\tQ\u0002!\u0001\u0006d_6\u0004\u0018M\\5p]\u0002\n1A];o)\t\tG\r\u0005\u0002\u001fE&\u00111m\b\u0002\u0005+:LG\u000fC\u0003f\u001d\u0001\u0007a-\u0001\u0002tGB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\u0006gB\f'o\u001b\u0006\u0003WZ\ta!\u00199bG\",\u0017BA7i\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015yw\u00011\u0001q\u0003\u001d\u0019W\u000e\u001a'j]\u0016\u00042AH9/\u0013\t\u0011xDA\u0003BeJ\f\u0017\u0010")
public class Fasta2ADAM
implements BDGSparkCommand<Fasta2ADAMArgs> {
    private final Fasta2ADAMArgs args;
    private final Fasta2ADAM$ companion;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static Fasta2ADAM apply(String[] stringArray) {
        return Fasta2ADAM$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return Fasta2ADAM$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Fasta2ADAM$.MODULE$.commandName();
    }

    public static void main(String[] stringArray) {
        Fasta2ADAM$.MODULE$.main(stringArray);
    }

    public void run() {
        BDGSparkCommand.run$((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.initializeMetrics$((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.printMetrics$((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Fasta2ADAM fasta2ADAM = this;
        synchronized (fasta2ADAM) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Fasta2ADAMArgs args() {
        return this.args;
    }

    public Fasta2ADAM$ companion() {
        return this.companion;
    }

    public void run(SparkContext sc) {
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Loading FASTA data from disk.");
        NucleotideContigFragmentDataset adamFasta = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFasta(this.args().fastaFile(), this.args().maximumLength());
        if (this.args().verbose()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("FASTA contains: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{adamFasta.sequences().toString()})));
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Writing records to disk.");
        NucleotideContigFragmentDataset finalFasta = this.args().partitions() > 0 ? (NucleotideContigFragmentDataset)adamFasta.transform((Function1 & Serializable & scala.Serializable)rdd -> {
            int x$1 = this.args().partitions();
            Ordering x$2 = rdd.repartition$default$2(x$1);
            return rdd.repartition(x$1, x$2);
        }) : adamFasta;
        finalFasta.saveAsParquet((SaveArgs)this.args());
    }

    public Fasta2ADAM(Fasta2ADAMArgs args) {
        this.args = args;
        Logging.$init$((Logging)this);
        BDGSparkCommand.$init$((BDGSparkCommand)this);
        this.companion = Fasta2ADAM$.MODULE$;
    }
}

