/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import org.apache.spark.SparkContext;
import org.bdgenomics.adam.cli.TransformSequences$;
import org.bdgenomics.adam.cli.TransformSequencesArgs;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.sequence.SequenceDataset;
import org.bdgenomics.formats.avro.Alphabet;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Marker;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i<Q!\u0005\n\t\u0002m1Q!\b\n\t\u0002yAQ\u0001L\u0001\u0005\u00025BqAL\u0001C\u0002\u0013\u0005q\u0006\u0003\u00049\u0003\u0001\u0006I\u0001\r\u0005\bs\u0005\u0011\r\u0011\"\u00010\u0011\u0019Q\u0014\u0001)A\u0005a!)1(\u0001C\u0001y\u0019!QD\u0005\u0001?\u0011!A\u0005B!b\u0001\n\u0003I\u0005\u0002\u0003&\t\u0005\u0003\u0005\u000b\u0011B#\t\u000b1BA\u0011A&\t\u000f5C!\u0019!C\u0001\u001d\"1\u0001\u000b\u0003Q\u0001\n=Cq!\u0015\u0005C\u0002\u0013\u0005!\u000b\u0003\u0004\\\u0011\u0001\u0006Ia\u0015\u0005\u00069\"!\t!X\u0001\u0013)J\fgn\u001d4pe6\u001cV-];f]\u000e,7O\u0003\u0002\u0014)\u0005\u00191\r\\5\u000b\u0005U1\u0012\u0001B1eC6T!a\u0006\r\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\u001a\u0003\ry'oZ\u0002\u0001!\ta\u0012!D\u0001\u0013\u0005I!&/\u00198tM>\u0014XnU3rk\u0016t7-Z:\u0014\u0007\u0005yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M)j\u0011a\n\u0006\u0003'!R!!\u000b\f\u0002\u000bU$\u0018\u000e\\:\n\u0005-:#a\u0005\"E\u000f\u000e{W.\\1oI\u000e{W\u000e]1oS>t\u0017A\u0002\u001fj]&$h\bF\u0001\u001c\u0003-\u0019w.\\7b]\u0012t\u0015-\\3\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\t1\fgn\u001a\u0006\u0002k\u0005!!.\u0019<b\u0013\t9$G\u0001\u0004TiJLgnZ\u0001\rG>lW.\u00198e\u001d\u0006lW\rI\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.A\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007%A\u0003baBd\u0017\u0010\u0006\u0002>WB\u0011A\u0004C\n\u0004\u0011}\u0012\u0005CA\u0019A\u0013\t\t%G\u0001\u0004PE*,7\r\u001e\t\u0004M\r+\u0015B\u0001#(\u0005=\u0011EiR*qCJ\\7i\\7nC:$\u0007C\u0001\u000fG\u0013\t9%C\u0001\fUe\u0006t7OZ8s[N+\u0017/^3oG\u0016\u001c\u0018I]4t\u0003\u0011\t'oZ:\u0016\u0003\u0015\u000bQ!\u0019:hg\u0002\"\"!\u0010'\t\u000b![\u0001\u0019A#\u0002\u0013\r|W\u000e]1oS>tW#A(\u000f\u0005q\u0001\u0011AC2p[B\fg.[8oA\u0005A\u0011\r\u001c9iC\n,G/F\u0001T!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0003bmJ|'B\u0001-\u0017\u0003\u001d1wN]7biNL!AW+\u0003\u0011\u0005c\u0007\u000f[1cKR\f\u0011\"\u00197qQ\u0006\u0014W\r\u001e\u0011\u0002\u0007I,h\u000e\u0006\u0002_CB\u0011\u0001eX\u0005\u0003A\u0006\u0012A!\u00168ji\")!\r\u0005a\u0001G\u0006\u00111o\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fQa\u001d9be.T!\u0001\u001b\r\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tQWM\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003m\u000f\u0001\u0007Q.A\u0004d[\u0012d\u0015N\\3\u0011\u0007\u0001r\u0007/\u0003\u0002pC\t)\u0011I\u001d:bsB\u0011\u0011\u000f\u001f\b\u0003eZ\u0004\"a]\u0011\u000e\u0003QT!!\u001e\u000e\u0002\rq\u0012xn\u001c;?\u0013\t9\u0018%\u0001\u0004Qe\u0016$WMZ\u0005\u0003oeT!a^\u0011")
public class TransformSequences
implements BDGSparkCommand<TransformSequencesArgs> {
    private final TransformSequencesArgs args;
    private final TransformSequences$ companion;
    private final Alphabet alphabet;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static TransformSequences apply(String[] stringArray) {
        return TransformSequences$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return TransformSequences$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformSequences$.MODULE$.commandName();
    }

    public static void main(String[] stringArray) {
        TransformSequences$.MODULE$.main(stringArray);
    }

    public void run() {
        BDGSparkCommand.run$((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.initializeMetrics$((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.printMetrics$((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformSequences transformSequences = this;
        synchronized (transformSequences) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public TransformSequencesArgs args() {
        return this.args;
    }

    public TransformSequences$ companion() {
        return this.companion;
    }

    public Alphabet alphabet() {
        return this.alphabet;
    }

    public void run(SparkContext sc) {
        SequenceDataset sequenceDataset;
        Alphabet alphabet = this.alphabet();
        if (Alphabet.DNA.equals(alphabet)) {
            sequenceDataset = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadDnaSequences(this.args().sequencesFile(), (Option)None$.MODULE$, (Option)None$.MODULE$);
        } else if (Alphabet.PROTEIN.equals(alphabet)) {
            sequenceDataset = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadProteinSequences(this.args().sequencesFile(), (Option)None$.MODULE$, (Option)None$.MODULE$);
        } else if (Alphabet.RNA.equals(alphabet)) {
            sequenceDataset = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadRnaSequences(this.args().sequencesFile(), (Option)None$.MODULE$, (Option)None$.MODULE$);
        } else {
            throw new MatchError((Object)alphabet);
        }
        SequenceDataset sequences = sequenceDataset;
        SequenceDataset maybeCreateReference = this.args().createReference() ? sequences.createSequenceDictionary() : sequences;
        maybeCreateReference.save(this.args().outputPath(), Predef$.MODULE$.boolean2Boolean(this.args().single()), Predef$.MODULE$.boolean2Boolean(this.args().disableFastConcat()));
    }

    public TransformSequences(TransformSequencesArgs args) {
        this.args = args;
        Logging.$init$((Logging)this);
        BDGSparkCommand.$init$((BDGSparkCommand)this);
        this.companion = TransformSequences$.MODULE$;
        this.alphabet = Alphabet.valueOf((String)args.alphabet());
    }
}

