/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import java.io.Serializable;
import java.time.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator$;
import org.bdgenomics.adam.cli.About;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformAlignments$;
import org.bdgenomics.adam.cli.TransformAlignmentsArgs;
import org.bdgenomics.adam.io.FastqRecordReader;
import org.bdgenomics.adam.models.ReadGroupDictionary;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.projections.AlignmentField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Filter$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.read.AlignmentDataset;
import org.bdgenomics.adam.rdd.read.AlignmentDataset$;
import org.bdgenomics.adam.rdd.read.QualityScoreBin$;
import org.bdgenomics.adam.util.ReferenceFile;
import org.bdgenomics.formats.avro.ProcessingStep;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%v!B\u000f\u001f\u0011\u00039c!B\u0015\u001f\u0011\u0003Q\u0003\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%\ta\u000f\u0005\u0007\t\u0006\u0001\u000b\u0011\u0002\u001f\t\u000f\u0015\u000b!\u0019!C\u0001w!1a)\u0001Q\u0001\nqBQaR\u0001\u0005\u0002!3A!\u000b\u0010\u0001\u0015\"AA\f\u0003BC\u0002\u0013EQ\f\u0003\u0005_\u0011\t\u0005\t\u0015!\u0003R\u0011\u0015A\u0004\u0002\"\u0001`\u0011\u001d\t\u0007B1A\u0005\u0002\tDa\u0001\u001a\u0005!\u0002\u0013\u0019\u0007bB3\t\u0005\u0004%\tA\u001a\u0005\u0007_\"\u0001\u000b\u0011B4\t\u000bADA\u0011B9\t\u000bmDA\u0011\u0002?\t\r}DA\u0011BA\u0001\u0011\u001d\t)\u0001\u0003C\u0005\u0003\u000fAq!a\f\t\t\u0013\t\t\u0004C\u0004\u00028!!I!!\u000f\t\u000f\u0005u\u0002\u0002\"\u0003\u0002@!9\u0011Q\t\u0005\u0005\n\u0005\u001d\u0003BB$\t\t\u0003\t9\u0006C\u0004\u0002\\!!\t!!\u0018\t\u000f\u0005\u0015\u0004\u0002\"\u0001\u0002h!9\u0011\u0011\u0011\u0005\u0005\u0002\u0005\r\u0005bBAG\u0011\u0011%\u0011qR\u0001\u0014)J\fgn\u001d4pe6\fE.[4o[\u0016tGo\u001d\u0006\u0003?\u0001\n1a\u00197j\u0015\t\t#%\u0001\u0003bI\u0006l'BA\u0012%\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002K\u0005\u0019qN]4\u0004\u0001A\u0011\u0001&A\u0007\u0002=\t\u0019BK]1og\u001a|'/\\!mS\u001etW.\u001a8ugN\u0019\u0011aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g!\t\u0011d'D\u00014\u0015\tyBG\u0003\u00026E\u0005)Q\u000f^5mg&\u0011qg\r\u0002\u0014\u0005\u0012;5i\\7nC:$7i\\7qC:LwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\n1bY8n[\u0006tGMT1nKV\tA\b\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!A.\u00198h\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\rM#(/\u001b8h\u00031\u0019w.\\7b]\u0012t\u0015-\\3!\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\u0002'\r|W.\\1oI\u0012+7o\u0019:jaRLwN\u001c\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007%\u000by\n\u0005\u0002)\u0011M!\u0001b\u0013(U!\tiD*\u0003\u0002N}\t1qJ\u00196fGR\u00042AM(R\u0013\t\u00016GA\bC\t\u001e\u001b\u0006/\u0019:l\u0007>lW.\u00198e!\tA#+\u0003\u0002T=\t9BK]1og\u001a|'/\\!mS\u001etW.\u001a8ug\u0006\u0013xm\u001d\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bQa\u001d7gi)T\u0011!W\u0001\tOJL'P\u001f7fI&\u00111L\u0016\u0002\b\u0019><w-\u001b8h\u0003\u0011\t'oZ:\u0016\u0003E\u000bQ!\u0019:hg\u0002\"\"!\u00131\t\u000bq[\u0001\u0019A)\u0002\u0013\r|W\u000e]1oS>tW#A2\u000f\u0005!\u0002\u0011AC2p[B\fg.[8oA\u0005Q1\u000f\u001e:j]\u001e,gnY=\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0011M\fW\u000e^8pYNT\u0011\u0001\\\u0001\u0007QR\u001c(\u000eZ6\n\u00059L'\u0001\u0006,bY&$\u0017\r^5p]N#(/\u001b8hK:\u001c\u00170A\u0006tiJLgnZ3oGf\u0004\u0013\u0001C7bs\n,')\u001b8\u0015\u0005IT\bCA:y\u001b\u0005!(BA;w\u0003\u0011\u0011X-\u00193\u000b\u0005]\u0004\u0013a\u0001:eI&\u0011\u0011\u0010\u001e\u0002\u0011\u00032LwM\\7f]R$\u0015\r^1tKRDQa\u001e\tA\u0002I\f\u0001#\\1zE\u0016\u0014V\r]1si&$\u0018n\u001c8\u0015\u0005Il\b\"\u0002@\u0012\u0001\u0004\u0011\u0018A\u00013t\u0003-i\u0017-\u001f2f\t\u0016$W\u000f]3\u0015\u0007I\f\u0019\u0001C\u0003\u007f%\u0001\u0007!/\u0001\u0007nCf\u0014WMU3bY&<g\u000eF\u0004s\u0003\u0013\ti\"a\b\t\u000f\u0005-1\u00031\u0001\u0002\u000e\u0005\u00111o\u0019\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\r\t9\u0002J\u0001\u0007CB\f7\r[3\n\t\u0005m\u0011\u0011\u0003\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006}N\u0001\rA\u001d\u0005\b\u0003C\u0019\u0002\u0019AA\u0012\u0003\t\u0019H\u000e\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\u0011\tI#!\u0005\u0002\u000fM$xN]1hK&!\u0011QFA\u0014\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0003Ai\u0017-\u001f2f%\u0016\u001c\u0017\r\\5ce\u0006$X\rF\u0003s\u0003g\t)\u0004C\u0003\u007f)\u0001\u0007!\u000fC\u0004\u0002\"Q\u0001\r!a\t\u0002\u001b5\f\u0017PY3D_\u0006dWm]2f)\r\u0011\u00181\b\u0005\u0006}V\u0001\rA]\u0001\n[\u0006L(-Z*peR$RA]A!\u0003\u0007BQA \fA\u0002IDq!!\t\u0017\u0001\u0004\t\u0019#\u0001\u0006nCf\u0014W-\u00143UC\u001e$rA]A%\u0003\u0017\ni\u0005C\u0004\u0002\f]\u0001\r!!\u0004\t\u000by<\u0002\u0019\u0001:\t\u000f\u0005=s\u00031\u0001\u0002R\u0005i1\u000f\u001e:j]\u001e,gnY=PaR\u0004B\u0001LA*O&\u0019\u0011QK\u0017\u0003\r=\u0003H/[8o)\r\u0011\u0018\u0011\f\u0005\u0006}b\u0001\rA]\u0001\u0010M>\u00148-\u001a(p]B\u000b'/];fiR\u0011\u0011q\f\t\u0004Y\u0005\u0005\u0014bAA2[\t9!i\\8mK\u0006t\u0017\u0001D5t\u001d>t\u0007+\u0019:rk\u0016$H\u0003BA0\u0003SBq!a\u001b\u001b\u0001\u0004\ti'A\u0005j]B,H\u000fU1uQB!\u0011qNA?\u001d\u0011\t\t(!\u001f\u0011\u0007\u0005MT&\u0004\u0002\u0002v)\u0019\u0011q\u000f\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\tY(L\u0001\u0007!J,G-\u001a4\n\u0007\r\u000byHC\u0002\u0002|5\n1A];o)\u0011\t))a#\u0011\u00071\n9)C\u0002\u0002\n6\u0012A!\u00168ji\"9\u00111B\u000eA\u0002\u00055\u0011\u0001F2sK\u0006$Xm\u00138po:\u001cf\u000e]:UC\ndW\r\u0006\u0003\u0002\u0012\u0006u\u0005\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]\u0005%\u0001\u0004n_\u0012,Gn]\u0005\u0005\u00037\u000b)J\u0001\u0005T]B$\u0016M\u00197f\u0011\u001d\tY\u0001\ba\u0001\u0003\u001bAq!!)\b\u0001\u0004\t\u0019+A\u0004d[\u0012d\u0015N\\3\u0011\u000b1\n)+!\u001c\n\u0007\u0005\u001dVFA\u0003BeJ\f\u0017\u0010")
public class TransformAlignments
implements BDGSparkCommand<TransformAlignmentsArgs> {
    private final TransformAlignmentsArgs args;
    private final TransformAlignments$ companion;
    private final ValidationStringency stringency;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String commandDescription() {
        return TransformAlignments$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformAlignments$.MODULE$.commandName();
    }

    public static void main(String[] stringArray) {
        TransformAlignments$.MODULE$.main(stringArray);
    }

    public void run() {
        BDGSparkCommand.run$((BDGSparkCommand)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformAlignments transformAlignments = this;
        synchronized (transformAlignments) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public TransformAlignmentsArgs args() {
        return this.args;
    }

    public TransformAlignments$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private AlignmentDataset maybeBin(AlignmentDataset rdd) {
        return (AlignmentDataset)Option$.MODULE$.apply((Object)this.args().binQualityScores()).fold((Function0 & Serializable & scala.Serializable)() -> rdd, (Function1 & Serializable & scala.Serializable)binDescription -> {
            Seq bins = QualityScoreBin$.MODULE$.apply(binDescription);
            return rdd.binQualityScores(bins);
        });
    }

    private AlignmentDataset maybeRepartition(AlignmentDataset ds) {
        AlignmentDataset alignmentDataset;
        if (this.args().repartition() != -1) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            alignmentDataset = (AlignmentDataset)ds.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                int x$1 = this.args().repartition();
                Ordering x$2 = rdd.repartition$default$2(x$1);
                return rdd.repartition(x$1, x$2);
            });
        } else {
            alignmentDataset = ds;
        }
        return alignmentDataset;
    }

    private AlignmentDataset maybeDedupe(AlignmentDataset ds) {
        AlignmentDataset alignmentDataset;
        if (this.args().markDuplicates()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Marking duplicates");
            alignmentDataset = ds.markDuplicates();
        } else {
            alignmentDataset = ds;
        }
        return alignmentDataset;
    }

    private AlignmentDataset maybeRealign(SparkContext sc, AlignmentDataset ds, StorageLevel sl) {
        AlignmentDataset alignmentDataset;
        if (this.args().locallyRealign()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Locally realigning indels.");
            Object object = this.args().cache() ? ds.rdd().persist(sl) : BoxedUnit.UNIT;
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0 & Serializable & scala.Serializable)() -> ConsensusGenerator$.MODULE$.fromReads(), (Function1 & Serializable & scala.Serializable)file -> {
                ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(ds.rdd().context());
                String x$1 = file;
                Option x$2 = qual$1.loadVariants$default$2();
                Option x$3 = qual$1.loadVariants$default$3();
                ValidationStringency x$4 = qual$1.loadVariants$default$4();
                return ConsensusGenerator$.MODULE$.fromKnownIndels(qual$1.loadVariants(x$1, x$2, x$3, x$4));
            });
            Option optReferenceFile = Option$.MODULE$.apply((Object)this.args().reference()).map((Function1 & Serializable & scala.Serializable)f -> ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadReferenceFile(f, this.args().mdTagsFragmentSize()));
            ConsensusGenerator x$5 = consensusGenerator;
            boolean x$6 = false;
            int x$7 = this.args().maxIndelSize();
            int x$8 = this.args().maxConsensusNumber();
            double x$9 = this.args().lodThreshold();
            int x$10 = this.args().maxTargetSize();
            int x$11 = this.args().maxReadsPerTarget();
            Option x$12 = optReferenceFile;
            boolean x$13 = this.args().unclipReads();
            AlignmentDataset realignmentDs = ds.realignIndels(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$13, x$12);
            Object object2 = this.args().cache() ? ds.rdd().unpersist(ds.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentDataset = realignmentDs;
        } else {
            alignmentDataset = ds;
        }
        return alignmentDataset;
    }

    private AlignmentDataset maybeRecalibrate(AlignmentDataset ds, StorageLevel sl) {
        AlignmentDataset alignmentDataset;
        if (this.args().recalibrateBaseQualities()) {
            AlignmentDataset bqsredDs;
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Recalibrating base qualities");
            None$ optSl = this.args().cache() ? new Some((Object)sl) : None$.MODULE$;
            SnpTable knownSnps = this.createKnownSnpsTable(ds.rdd().context());
            Broadcast broadcastedSnps = ds.rdd().context().broadcast((Object)knownSnps, ClassTag$.MODULE$.apply(SnpTable.class));
            alignmentDataset = bqsredDs = ds.recalibrateBaseQualities(broadcastedSnps, this.args().minAcceptableQuality(), (Option)optSl, Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.args().samplingFraction())).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0.0), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.args().samplingSeed())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 != 0L));
        } else {
            alignmentDataset = ds;
        }
        return alignmentDataset;
    }

    private AlignmentDataset maybeCoalesce(AlignmentDataset ds) {
        AlignmentDataset alignmentDataset;
        if (this.args().coalesce() != -1) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            alignmentDataset = this.args().coalesce() > ds.rdd().partitions().length || this.args().forceShuffle() ? (AlignmentDataset)ds.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                int x$1 = this.args().coalesce();
                boolean x$2 = true;
                Option x$3 = rdd.coalesce$default$3();
                Ordering x$4 = rdd.coalesce$default$4(x$1, x$2, x$3);
                return rdd.coalesce(x$1, x$2, x$3, x$4);
            }) : (AlignmentDataset)ds.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                int x$5 = this.args().coalesce();
                boolean x$6 = false;
                Option x$7 = rdd.coalesce$default$3();
                Ordering x$8 = rdd.coalesce$default$4(x$5, x$6, x$7);
                return rdd.coalesce(x$5, x$6, x$7, x$8);
            });
        } else {
            alignmentDataset = ds;
        }
        return alignmentDataset;
    }

    /*
     * WARNING - void declaration
     */
    private AlignmentDataset maybeSort(AlignmentDataset ds, StorageLevel sl) {
        AlignmentDataset alignmentDataset;
        if (this.args().sortByReadName() || this.args().sortByReferencePosition() || this.args().sortByReferencePositionAndIndex()) {
            void var3_3;
            AlignmentDataset alignmentDataset2;
            Object object = this.args().cache() ? ds.rdd().persist(sl) : BoxedUnit.UNIT;
            if (this.args().sortByReadName()) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Sorting alignments by read name");
                alignmentDataset2 = ds.sortByReadName();
            } else if (this.args().sortByReferencePosition()) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Sorting alignments by reference position, with references ordered by name");
                alignmentDataset2 = ds.sortByReferencePosition();
            } else {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Sorting alignments by reference position, with references ordered by index");
                alignmentDataset2 = ds.sortByReferencePositionAndIndex();
            }
            AlignmentDataset sortedDs = alignmentDataset2;
            Object object2 = this.args().cache() ? ds.rdd().unpersist(ds.rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentDataset = var3_3;
        } else {
            alignmentDataset = ds;
        }
        return alignmentDataset;
    }

    private AlignmentDataset maybeMdTag(SparkContext sc, AlignmentDataset ds, Option<ValidationStringency> stringencyOpt) {
        AlignmentDataset alignmentDataset;
        if (this.args().mdTagsReferenceFile() != null) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Adding MDTags to reads based on reference file ").append(this.args().mdTagsReferenceFile()).toString());
            ReferenceFile referenceFile = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadReferenceFile(this.args().mdTagsReferenceFile(), this.args().mdTagsFragmentSize());
            alignmentDataset = ds.computeMismatchingPositions(referenceFile, this.args().mdTagsOverwrite(), (ValidationStringency)stringencyOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ValidationStringency.STRICT));
        } else {
            alignmentDataset = ds;
        }
        return alignmentDataset;
    }

    public AlignmentDataset apply(AlignmentDataset ds) {
        SparkContext sc = ds.rdd().context();
        StorageLevel sl = StorageLevel$.MODULE$.fromString(this.args().storageLevel());
        Option stringencyOpt = Option$.MODULE$.apply((Object)this.args().stringency()).map((Function1 & Serializable & scala.Serializable)x$3 -> ValidationStringency.valueOf((String)x$3));
        if (this.args().maxReadLength() > 0) {
            FastqRecordReader.setMaxReadLength((Configuration)sc.hadoopConfiguration(), (int)this.args().maxReadLength());
        }
        AlignmentDataset initialDs = this.maybeRepartition(ds);
        AlignmentDataset binnedDs = this.maybeBin(initialDs);
        AlignmentDataset maybeDedupedDs = this.maybeDedupe(binnedDs);
        AlignmentDataset maybeRealignedDs = this.maybeRealign(sc, maybeDedupedDs, sl);
        AlignmentDataset maybeRecalibratedDs = this.maybeRecalibrate(maybeRealignedDs, sl);
        AlignmentDataset finalPreprocessedDs = this.maybeCoalesce(maybeRecalibratedDs);
        AlignmentDataset maybeSortedDs = this.maybeSort(finalPreprocessedDs, sl);
        return this.maybeMdTag(sc, maybeSortedDs, (Option<ValidationStringency>)stringencyOpt);
    }

    public boolean forceNonParquet() {
        return this.args().forceLoadBam() || this.args().forceLoadFastq() || this.args().forceLoadIFastq();
    }

    public boolean isNonParquet(String inputPath) {
        return inputPath.endsWith(".sam") || inputPath.endsWith(".bam") || inputPath.endsWith(".ifq") || inputPath.endsWith(".fq") || inputPath.endsWith(".fastq") || inputPath.endsWith(".fa") || inputPath.endsWith(".fasta");
    }

    public void run(SparkContext sc) {
        SequenceDictionary sdFinal;
        AlignmentDataset alignmentDataset;
        AlignmentDataset loadedDs;
        AlignmentDataset alignmentDataset2;
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        if (this.args().useAlignedReadPredicate() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet force load flag was passed");
        }
        if (this.args().limitProjection() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet force load flag was passed");
        }
        if (this.args().useAlignedReadPredicate() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet input path was specified");
        }
        if (this.args().limitProjection() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet input path was specified");
        }
        if (this.args().useAlignedReadPredicate() && this.args().regionPredicate() != null) {
            throw new IllegalArgumentException("-aligned_read_predicate and -region_predicate are mutually exclusive");
        }
        if (((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{this.args().sortByReadName(), this.args().sortByReferencePosition(), this.args().sortByReferencePositionAndIndex()}))).count((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b))) > 1) {
            throw new IllegalArgumentException("only one of -sort_by_name, -sort_by_reference_position, and -sort_by_reference_position_and_index may be specified");
        }
        if (this.args().forceLoadBam()) {
            if (this.args().regionPredicate() != null) {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$1 = this.args().inputPath();
                Iterable x$2 = loci;
                ValidationStringency x$3 = qual$1.loadIndexedBam$default$3();
                alignmentDataset2 = qual$1.loadIndexedBam(x$1, x$2, x$3, Predef.DummyImplicit$.MODULE$.dummyImplicit());
            } else {
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$4 = this.args().inputPath();
                ValidationStringency x$5 = qual$2.loadBam$default$2();
                alignmentDataset2 = qual$2.loadBam(x$4, x$5);
            }
        } else if (this.args().forceLoadFastq()) {
            alignmentDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFastq(this.args().inputPath(), Option$.MODULE$.apply((Object)this.args().pairedFastqFile()), Option$.MODULE$.apply((Object)this.args().fastqReadGroup()), this.stringency());
        } else if (this.args().forceLoadIFastq()) {
            alignmentDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(this.args().inputPath());
        } else if (this.args().forceLoadParquet() || this.args().useAlignedReadPredicate() || this.args().limitProjection()) {
            Some pred = this.args().useAlignedReadPredicate() ? new Some((Object)FilterApi.eq((Operators.Column)FilterApi.booleanColumn((String)"readMapped"), (Comparable)Predef$.MODULE$.boolean2Boolean(true))) : (this.args().regionPredicate() != null ? new Some((Object)ReferenceRegion$.MODULE$.createPredicate(ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate()).toSeq())) : None$.MODULE$);
            None$ proj = this.args().limitProjection() ? new Some((Object)Filter$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentField$.MODULE$.attributes(), AlignmentField$.MODULE$.originalQualityScores()}))) : None$.MODULE$;
            alignmentDataset2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadParquetAlignments(this.args().inputPath(), (Option)pred, (Option)proj);
        } else {
            ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$6 = this.args().inputPath();
            Option x$7 = Option$.MODULE$.apply((Object)this.args().pairedFastqFile());
            Option x$8 = Option$.MODULE$.apply((Object)this.args().fastqReadGroup());
            ValidationStringency x$9 = this.stringency();
            Option x$10 = qual$3.loadAlignments$default$4();
            Option x$11 = qual$3.loadAlignments$default$5();
            AlignmentDataset loadedReads = qual$3.loadAlignments(x$6, x$7, x$8, x$10, x$11, x$9);
            if (this.args().regionPredicate() != null) {
                Iterable loci = ReferenceRegion$.MODULE$.fromString(this.args().regionPredicate());
                alignmentDataset2 = (AlignmentDataset)loadedReads.filterByOverlappingRegions(loci);
            } else {
                alignmentDataset2 = loadedDs = loadedReads;
            }
        }
        if (this.args().disableProcessingStep()) {
            alignmentDataset = loadedDs;
        } else {
            About about = new About();
            String version = about.isSnapshot() ? new StringOps(Predef$.MODULE$.augmentString("%s--%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{about.version(), about.commit()})) : about.version();
            long epoch = Instant.now().getEpochSecond();
            ProcessingStep processingStep = ProcessingStep.newBuilder().setId(new StringOps(Predef$.MODULE$.augmentString("ADAM_%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epoch)}))).setProgramName("org.bdgenomics.adam.cli.TransformAlignments").setVersion(version).setCommandLine(this.args().command()).build();
            alignmentDataset = (AlignmentDataset)loadedDs.addProcessingStep(processingStep);
        }
        AlignmentDataset aDs = alignmentDataset;
        RDD rdd = aDs.rdd();
        SequenceDictionary sd = aDs.sequences();
        ReadGroupDictionary rgd = aDs.readGroups();
        Seq pgs = aDs.processingSteps();
        Option concatOpt = Option$.MODULE$.apply((Object)this.args().concatFilename()).map((Function1 & Serializable & scala.Serializable)concatFilename -> {
            AlignmentDataset alignmentDataset;
            if (this.args().forceLoadBam()) {
                ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$12 = concatFilename;
                ValidationStringency x$13 = qual$4.loadBam$default$2();
                alignmentDataset = qual$4.loadBam(x$12, x$13);
            } else if (this.args().forceLoadIFastq()) {
                alignmentDataset = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(concatFilename);
            } else if (this.args().forceLoadParquet()) {
                ADAMContext qual$5 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$14 = concatFilename;
                Option x$15 = qual$5.loadParquetAlignments$default$2();
                Option x$16 = qual$5.loadParquetAlignments$default$3();
                alignmentDataset = qual$5.loadParquetAlignments(x$14, x$15, x$16);
            } else {
                ADAMContext qual$6 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
                String x$17 = concatFilename;
                Option x$18 = Option$.MODULE$.apply((Object)this.args().fastqReadGroup());
                Option x$19 = qual$6.loadAlignments$default$2();
                Option x$20 = qual$6.loadAlignments$default$4();
                Option x$21 = qual$6.loadAlignments$default$5();
                ValidationStringency x$22 = qual$6.loadAlignments$default$6();
                alignmentDataset = qual$6.loadAlignments(x$17, x$19, x$18, x$20, x$21, x$22);
            }
            return alignmentDataset;
        });
        Tuple4 tuple4 = (Tuple4)concatOpt.fold((Function0 & Serializable & scala.Serializable)() -> new Tuple4((Object)rdd, (Object)sd, (Object)rgd, (Object)pgs), (Function1 & Serializable & scala.Serializable)t -> new Tuple4((Object)rdd.$plus$plus(t.rdd()), (Object)sd.$plus$plus(t.sequences()), (Object)rgd.$plus$plus(t.readGroups()), pgs.$plus$plus((GenTraversableOnce)t.processingSteps(), Seq$.MODULE$.canBuildFrom())));
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        RDD mergedRdd = (RDD)tuple4._1();
        SequenceDictionary mergedSd = (SequenceDictionary)tuple4._2();
        ReadGroupDictionary mergedRgd = (ReadGroupDictionary)tuple4._3();
        Seq mergedPgs = (Seq)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)mergedRdd, (Object)mergedSd, (Object)mergedRgd, (Object)mergedPgs);
        Tuple4 tuple43 = tuple42;
        RDD mergedRdd2 = (RDD)tuple43._1();
        SequenceDictionary mergedSd2 = (SequenceDictionary)tuple43._2();
        ReadGroupDictionary mergedRgd2 = (ReadGroupDictionary)tuple43._3();
        Seq mergedPgs2 = (Seq)tuple43._4();
        AlignmentDataset newDs = AlignmentDataset$.MODULE$.apply(mergedRdd2, mergedSd2, mergedRgd2, mergedPgs2);
        AlignmentDataset outputDs = this.apply(newDs);
        SequenceDictionary sequenceDictionary = sdFinal = this.args().sortByReferencePosition() ? mergedSd2.stripIndices().sorted() : mergedSd2;
        if (this.args().partitionByStartPos()) {
            if (outputDs.sequences().isEmpty()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "This dataset is not aligned and therefore will not benefit from being saved as a partitioned dataset");
            }
            String x$23 = this.args().outputPath();
            int x$24 = this.args().partitionedBinSize();
            CompressionCodecName x$25 = outputDs.saveAsPartitionedParquet$default$2();
            outputDs.saveAsPartitionedParquet(x$23, x$25, x$24);
        } else {
            outputDs.save((ADAMSaveAnyArgs)this.args(), this.args().sortByReadName() || this.args().sortByReferencePosition() || this.args().sortByReferencePositionAndIndex());
        }
    }

    private SnpTable createKnownSnpsTable(SparkContext sc) {
        return (SnpTable)Option$.MODULE$.apply((Object)this.args().knownSnpsFile()).fold((Function0 & Serializable & scala.Serializable)() -> SnpTable$.MODULE$.apply(), (Function1 & Serializable & scala.Serializable)f -> {
            ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$1 = f;
            Option x$2 = qual$1.loadVariants$default$2();
            Option x$3 = qual$1.loadVariants$default$3();
            ValidationStringency x$4 = qual$1.loadVariants$default$4();
            return SnpTable$.MODULE$.apply(qual$1.loadVariants(x$1, x$2, x$3, x$4));
        });
    }

    public TransformAlignments(TransformAlignmentsArgs args) {
        this.args = args;
        Logging.$init$((Logging)this);
        BDGSparkCommand.$init$((BDGSparkCommand)this);
        this.companion = TransformAlignments$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

