/**
 * Licensed to Big Data Genomics (BDG) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The BDG licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.bdgenomics.adam.cli;

/**
 * About.
 */
public final class About {
    private static final String ARTIFACT_ID = "adam-cli-spark3_2.12";
    private static final String BUILD_TIMESTAMP = "2020-12-16";
    private static final String COMMIT = "3a10f725008ed32b5af7d4f9bd34a4693db48418";
    private static final String HADOOP_VERSION = "2.7.5";
    private static final String SCALA_VERSION = "2.12.8";
    private static final String SPARK_VERSION = "3.0.1";
    private static final String VERSION = "0.33.0";

    /**
     * Return the artifact id.
     *
     * @return the artifact id
     */
    public String artifactId() {
        return ARTIFACT_ID;
    }

    /**
     * Return the build timestamp.
     *
     * @return the build timestamp
     */
    public String buildTimestamp() {
        return BUILD_TIMESTAMP;
    }

    /**
     * Return the last commit.
     *
     * @return the last commit
     */
    public String commit() {
        return COMMIT;
    }

    /**
     * Return the Hadoop compile scope dependency version.
     *
     * @return the Hadoop compile scope dependency version
     */
    public String hadoopVersion() {
        return HADOOP_VERSION;
    }

    /**
     * Return the Scala compile scope dependency version.
     *
     * @return the Scala compile scope dependency version
     */
    public String scalaVersion() {
        return SCALA_VERSION;
    }

    /**
     * Return the Apache Spark compile scope dependency version.
     *
     * @return the Apache Spark compile scope dependency version
     */
    public String sparkVersion() {
        return SPARK_VERSION;
    }

    /**
     * Return the ADAM version.
     *
     * @return the ADAM version
     */
    public String version() {
        return VERSION;
    }

    /**
     * Return true if the ADAM version is a snapshot.
     *
     * @return true if the ADAM version is a snapshot
     */
    public boolean isSnapshot() {
        return VERSION.contains("SNAPSHOT");
    }
}
