/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformFragments$;
import org.bdgenomics.adam.cli.TransformFragmentsArgs;
import org.bdgenomics.adam.ds.ADAMContext;
import org.bdgenomics.adam.ds.ADAMContext$;
import org.bdgenomics.adam.ds.ADAMSaveAnyArgs;
import org.bdgenomics.adam.ds.fragment.FragmentDataset;
import org.bdgenomics.adam.ds.read.AlignmentDataset;
import org.bdgenomics.adam.ds.read.QualityScoreBin$;
import org.bdgenomics.adam.io.FastqRecordReader;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=q!B\t\u0013\u0011\u0003Yb!B\u000f\u0013\u0011\u0003q\u0002\"\u0002\u0017\u0002\t\u0003i\u0003b\u0002\u0018\u0002\u0005\u0004%\ta\f\u0005\u0007q\u0005\u0001\u000b\u0011\u0002\u0019\t\u000fe\n!\u0019!C\u0001_!1!(\u0001Q\u0001\nABQaO\u0001\u0005\u0002q2A!\b\n\u0001}!A\u0001\u000b\u0003BC\u0002\u0013E\u0011\u000b\u0003\u0005S\u0011\t\u0005\t\u0015!\u0003F\u0011\u0015a\u0003\u0002\"\u0001T\u0011\u001d)\u0006B1A\u0005\u0002YCa\u0001\u0017\u0005!\u0002\u00139\u0006\"B-\t\t\u0003Q\u0006\"B3\t\t\u00131\u0007\"B5\t\t\u0003Q\u0017A\u0005+sC:\u001chm\u001c:n\rJ\fw-\\3oiNT!a\u0005\u000b\u0002\u0007\rd\u0017N\u0003\u0002\u0016-\u0005!\u0011\rZ1n\u0015\t9\u0002$\u0001\u0006cI\u001e,gn\\7jGNT\u0011!G\u0001\u0004_J<7\u0001\u0001\t\u00039\u0005i\u0011A\u0005\u0002\u0013)J\fgn\u001d4pe64%/Y4nK:$8oE\u0002\u0002?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014+\u001b\u00059#BA\n)\u0015\tIc#A\u0003vi&d7/\u0003\u0002,O\t\u0019\"\tR$D_6l\u0017M\u001c3D_6\u0004\u0018M\\5p]\u00061A(\u001b8jiz\"\u0012aG\u0001\fG>lW.\u00198e\u001d\u0006lW-F\u00011!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0003mC:<'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oI\u0012aa\u0015;sS:<\u0017\u0001D2p[6\fg\u000e\u001a(b[\u0016\u0004\u0013AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\f1cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0002\nQ!\u00199qYf$\"!\u0010=\u0011\u0005qA1\u0003\u0002\u0005@\u0005\"\u0003\"!\r!\n\u0005\u0005\u0013$AB(cU\u0016\u001cG\u000fE\u0002'\u0007\u0016K!\u0001R\u0014\u0003\u001f\t#ui\u00159be.\u001cu.\\7b]\u0012\u0004\"\u0001\b$\n\u0005\u001d\u0013\"A\u0006+sC:\u001chm\u001c:n\rJ\fw-\\3oiN\f%oZ:\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015!B:mMRR'\"A'\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0014&\u0003\u000f1{wmZ5oO\u0006!\u0011M]4t+\u0005)\u0015!B1sON\u0004CCA\u001fU\u0011\u0015\u00016\u00021\u0001F\u0003%\u0019w.\u001c9b]&|g.F\u0001X\u001d\ta\u0002!\u0001\u0006d_6\u0004\u0018M\\5p]\u0002\n1\"\\1zE\u0016$U\rZ;qKR\u00111l\u0019\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b\u0001B\u001a:bO6,g\u000e\u001e\u0006\u0003AR\t!\u0001Z:\n\u0005\tl&a\u0004$sC\u001elWM\u001c;ECR\f7/\u001a;\t\u000b\u0011t\u0001\u0019A.\u0002\u000bI,\u0017\rZ:\u0002\u00115\f\u0017PY3CS:$\"aW4\t\u000b!|\u0001\u0019A.\u0002\u0007I$G-A\u0002sk:$\"a\u001b8\u0011\u0005\u0001b\u0017BA7\"\u0005\u0011)f.\u001b;\t\u000b=\u0004\u0002\u0019\u00019\u0002\u0005M\u001c\u0007CA9w\u001b\u0005\u0011(BA:u\u0003\u0015\u0019\b/\u0019:l\u0015\t)\b$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003oJ\u0014Ab\u00159be.\u001cuN\u001c;fqRDQ!_\u0004A\u0002i\fqaY7e\u0019&tW\rE\u0002!wvL!\u0001`\u0011\u0003\u000b\u0005\u0013(/Y=\u0011\u0007y\fYAD\u0002\u0000\u0003\u000f\u00012!!\u0001\"\u001b\t\t\u0019AC\u0002\u0002\u0006i\ta\u0001\u0010:p_Rt\u0014bAA\u0005C\u00051\u0001K]3eK\u001aL1aNA\u0007\u0015\r\tI!\t")
public class TransformFragments
implements BDGSparkCommand<TransformFragmentsArgs> {
    private final TransformFragmentsArgs args;
    private final TransformFragments$ companion;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static TransformFragments apply(String[] stringArray) {
        return TransformFragments$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return TransformFragments$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformFragments$.MODULE$.commandName();
    }

    public static void main(String[] stringArray) {
        TransformFragments$.MODULE$.main(stringArray);
    }

    public void run() {
        BDGSparkCommand.run$((BDGSparkCommand)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformFragments transformFragments = this;
        synchronized (transformFragments) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TransformFragmentsArgs args() {
        return this.args;
    }

    public TransformFragments$ companion() {
        return this.companion;
    }

    public FragmentDataset maybeDedupe(FragmentDataset reads) {
        if (this.args().markDuplicates()) {
            return reads.markDuplicates();
        }
        return reads;
    }

    private FragmentDataset maybeBin(FragmentDataset rdd) {
        return (FragmentDataset)Option$.MODULE$.apply((Object)this.args().binQualityScores()).fold((Function0 & Serializable & scala.Serializable)() -> rdd, (Function1 & Serializable & scala.Serializable)binDescription -> {
            Seq bins = QualityScoreBin$.MODULE$.apply(binDescription);
            return rdd.binQualityScores(bins);
        });
    }

    public void run(SparkContext sc) {
        FragmentDataset fragmentDataset;
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        if (this.args().loadAsAlignments() && this.args().saveAsAlignments()) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "If loading and saving as alignments, consider using TransformAlignments instead");
        }
        if (this.args().sortByReadName() || this.args().sortByReferencePosition() || this.args().sortByReferencePositionAndIndex()) {
            Predef$.MODULE$.require(this.args().saveAsAlignments(), (Function0 & Serializable & scala.Serializable)() -> "-sort_by_* flags are only valid if -save_as_alignments is given");
        }
        if (((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{this.args().sortByReadName(), this.args().sortByReferencePosition(), this.args().sortByReferencePositionAndIndex()}))).count((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b))) > 1) {
            throw new IllegalArgumentException("only one of -sort_by_name, -sort_by_reference_position, and -sort_by_reference_position_and_index may be specified");
        }
        if (this.args().maxReadLength() > 0) {
            FastqRecordReader.setMaxReadLength((Configuration)sc.hadoopConfiguration(), (int)this.args().maxReadLength());
        }
        this.args().configureCramFormat(sc);
        Option optPairedFastqFile = Option$.MODULE$.apply((Object)this.args().pairedFastqFile());
        if (this.args().loadAsAlignments() || optPairedFastqFile.isDefined()) {
            ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$1 = this.args().inputPath();
            Option x$2 = optPairedFastqFile;
            Option x$3 = qual$1.loadAlignments$default$3();
            Option x$4 = qual$1.loadAlignments$default$4();
            Option x$5 = qual$1.loadAlignments$default$5();
            ValidationStringency x$6 = qual$1.loadAlignments$default$6();
            fragmentDataset = qual$1.loadAlignments(x$1, x$2, x$3, x$4, x$5, x$6).toFragments();
        } else {
            ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$7 = this.args().inputPath();
            Option x$8 = qual$2.loadFragments$default$2();
            Option x$9 = qual$2.loadFragments$default$3();
            ValidationStringency x$10 = qual$2.loadFragments$default$4();
            fragmentDataset = qual$2.loadFragments(x$7, x$8, x$9, x$10);
        }
        FragmentDataset rdd = fragmentDataset;
        FragmentDataset maybeBinnedReads = this.maybeBin(rdd);
        FragmentDataset maybeDedupedReads = this.maybeDedupe(maybeBinnedReads);
        if (this.args().saveAsAlignments()) {
            AlignmentDataset alignmentRdd = maybeDedupedReads.toAlignments();
            AlignmentDataset finalRdd = this.args().sortByReadName() ? alignmentRdd.sortByReadName() : (this.args().sortByReferencePosition() ? alignmentRdd.sortByReferencePosition() : (this.args().sortByReferencePositionAndIndex() ? alignmentRdd.sortByReferencePositionAndIndex() : alignmentRdd));
            finalRdd.save((ADAMSaveAnyArgs)this.args(), this.args().sortByReadName() || this.args().sortByReferencePosition() || this.args().sortByReferencePositionAndIndex());
            return;
        }
        maybeDedupedReads.saveAsParquet((SaveArgs)this.args());
    }

    public TransformFragments(TransformFragmentsArgs args) {
        this.args = args;
        Logging.$init$((Logging)this);
        BDGSparkCommand.$init$((BDGSparkCommand)this);
        this.companion = TransformFragments$.MODULE$;
    }
}

