/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import java.io.Serializable;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.SparkContext;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformGenotypes$;
import org.bdgenomics.adam.cli.TransformGenotypesArgs;
import org.bdgenomics.adam.converters.VariantContextConverter$;
import org.bdgenomics.adam.ds.ADAMContext$;
import org.bdgenomics.adam.ds.ADAMSaveAnyArgs;
import org.bdgenomics.adam.ds.GenomicDataset;
import org.bdgenomics.adam.ds.variant.GenotypeDataset;
import org.bdgenomics.adam.ds.variant.VariantContextDataset;
import org.bdgenomics.adam.util.FileExtensions$;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015s!B\n\u0015\u0011\u0003ib!B\u0010\u0015\u0011\u0003\u0001\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nIBQ!P\u0001\u0005\u0002y2Aa\b\u000b\u0001\u0001\"A!\n\u0003BC\u0002\u0013\u00051\n\u0003\u0005M\u0011\t\u0005\t\u0015!\u0003H\u0011\u0015q\u0003\u0002\"\u0001N\u0011\u001dy\u0005B1A\u0005\u0002ACaA\u0015\u0005!\u0002\u0013\t\u0006bB*\t\u0005\u0004%\t\u0001\u0016\u0005\u0007;\"\u0001\u000b\u0011B+\t\u000byCA\u0011B0\t\u000b%DA\u0011\u00026\t\u000f\u0005%\u0001\u0002\"\u0001\u0002\f\u0005\u0011BK]1og\u001a|'/\\$f]>$\u0018\u0010]3t\u0015\t)b#A\u0002dY&T!a\u0006\r\u0002\t\u0005$\u0017-\u001c\u0006\u00033i\t!B\u00193hK:|W.[2t\u0015\u0005Y\u0012aA8sO\u000e\u0001\u0001C\u0001\u0010\u0002\u001b\u0005!\"A\u0005+sC:\u001chm\u001c:n\u000f\u0016tw\u000e^=qKN\u001c2!A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001\u0006L\u0007\u0002S)\u0011QC\u000b\u0006\u0003Wa\tQ!\u001e;jYNL!!L\u0015\u0003'\t#uiQ8n[\u0006tGmQ8na\u0006t\u0017n\u001c8\u0002\rqJg.\u001b;?)\u0005i\u0012aC2p[6\fg\u000e\u001a(b[\u0016,\u0012A\r\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001\\1oO*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u0019\u0019FO]5oO\u0006a1m\\7nC:$g*Y7fA\u0005\u00112m\\7nC:$G)Z:de&\u0004H/[8o\u0003M\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8!\u0003\u0015\t\u0007\u000f\u001d7z)\ry\u0014q\u0005\t\u0003=!\u00192\u0001C!E!\t\u0019$)\u0003\u0002Di\t1qJ\u00196fGR\u00042\u0001K#H\u0013\t1\u0015FA\bC\t\u001e\u001b\u0006/\u0019:l\u0007>lW.\u00198e!\tq\u0002*\u0003\u0002J)\t1BK]1og\u001a|'/\\$f]>$\u0018\u0010]3t\u0003J<7/\u0001\u0003be\u001e\u001cX#A$\u0002\u000b\u0005\u0014xm\u001d\u0011\u0015\u0005}r\u0005\"\u0002&\f\u0001\u00049\u0015!C2p[B\fg.[8o+\u0005\tfB\u0001\u0010\u0001\u0003)\u0019w.\u001c9b]&|g\u000eI\u0001\u000bgR\u0014\u0018N\\4f]\u000eLX#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001C:b[R|w\u000e\\:\u000b\u0003i\u000ba\u0001\u001b;tU\u0012\\\u0017B\u0001/X\u0005Q1\u0016\r\\5eCRLwN\\*ue&tw-\u001a8ds\u0006Y1\u000f\u001e:j]\u001e,gnY=!\u00035i\u0017-\u001f2f\u0007>\fG.Z:dKR\u0011\u0001\r\u001b\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fqA^1sS\u0006tGO\u0003\u0002f-\u0005\u0011Am]\u0005\u0003O\n\u0014qbR3o_RL\b/\u001a#bi\u0006\u001cX\r\u001e\u0005\u0006KB\u0001\r\u0001Y\u0001\n[\u0006L(-Z*peR,\"a\u001b8\u0015\u00071\f9\u0001\u0005\u0002n]2\u0001A!B8\u0012\u0005\u0004\u0001(!A+\u0012\u0005E$\bC\u0001\u0012s\u0013\t\u00198EA\u0004O_RD\u0017N\\41\tUT\u00181\u0001\t\u0007m^L\u0018\u0011\u00017\u000e\u0003\u0011L!\u0001\u001f3\u0003\u001d\u001d+gn\\7jG\u0012\u000bG/Y:fiB\u0011QN\u001f\u0003\nw:\f\t\u0011!A\u0003\u0002q\u00141a\u0018\u00132#\t\tX\u0010\u0005\u0002#}&\u0011qp\t\u0002\u0004\u0003:L\bcA7\u0002\u0004\u0011Q\u0011Q\u00018\u0002\u0002\u0003\u0005)\u0011\u0001?\u0003\u0007}##\u0007C\u0003f#\u0001\u0007A.A\u0002sk:$B!!\u0004\u0002\u0014A\u0019!%a\u0004\n\u0007\u0005E1E\u0001\u0003V]&$\bbBA\u000b%\u0001\u0007\u0011qC\u0001\u0003g\u000e\u0004B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0003ta\u0006\u00148NC\u0002\u0002\"i\ta!\u00199bG\",\u0017\u0002BA\u0013\u00037\u0011Ab\u00159be.\u001cuN\u001c;fqRDq!!\u000b\b\u0001\u0004\tY#A\u0004d[\u0012d\u0015N\\3\u0011\u000b\t\ni#!\r\n\u0007\u0005=2EA\u0003BeJ\f\u0017\u0010\u0005\u0003\u00024\u0005\u0005c\u0002BA\u001b\u0003{\u00012!a\u000e$\u001b\t\tIDC\u0002\u0002<q\ta\u0001\u0010:p_Rt\u0014bAA G\u00051\u0001K]3eK\u001aL1!OA\"\u0015\r\tyd\t")
public class TransformGenotypes
implements BDGSparkCommand<TransformGenotypesArgs> {
    private final TransformGenotypesArgs args;
    private final TransformGenotypes$ companion;
    private final ValidationStringency stringency;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static TransformGenotypes apply(String[] stringArray) {
        return TransformGenotypes$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return TransformGenotypes$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformGenotypes$.MODULE$.commandName();
    }

    public static void main(String[] stringArray) {
        TransformGenotypes$.MODULE$.main(stringArray);
    }

    public void run() {
        BDGSparkCommand.run$((BDGSparkCommand)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformGenotypes transformGenotypes = this;
        synchronized (transformGenotypes) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TransformGenotypesArgs args() {
        return this.args;
    }

    public TransformGenotypes$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private GenotypeDataset maybeCoalesce(GenotypeDataset ds) {
        if (this.args().coalesce() != -1) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            if (this.args().coalesce() > ds.rdd().partitions().length || this.args().forceShuffle()) {
                return (GenotypeDataset)ds.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                    int x$1 = this.args().coalesce();
                    boolean x$2 = true;
                    Option x$3 = rdd.coalesce$default$3();
                    Ordering x$4 = rdd.coalesce$default$4(x$1, x$2, x$3);
                    return rdd.coalesce(x$1, x$2, x$3, x$4);
                });
            }
            return (GenotypeDataset)ds.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                int x$5 = this.args().coalesce();
                boolean x$6 = false;
                Option x$7 = rdd.coalesce$default$3();
                Ordering x$8 = rdd.coalesce$default$4(x$5, x$6, x$7);
                return rdd.coalesce(x$5, x$6, x$7, x$8);
            });
        }
        return ds;
    }

    private <U extends GenomicDataset<?, ?, U>> U maybeSort(U ds) {
        if (this.args().sort()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Sorting before saving");
            return (U)ds.sort();
        }
        if (this.args().sortLexicographically()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Sorting lexicographically before saving");
            return (U)ds.sortLexicographically();
        }
        return ds;
    }

    public void run(SparkContext sc) {
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        Predef$.MODULE$.require(!this.args().sort() || !this.args().sortLexicographically(), (Function0 & Serializable & scala.Serializable)() -> "Cannot set both -sort_on_save and -sort_lexicographically_on_save.");
        if (this.args().nestedAnnotations()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Populating the variant.annotation field in the Genotype records");
            sc.hadoopConfiguration().setBoolean(VariantContextConverter$.MODULE$.nestAnnotationInGenotypesProperty(), true);
        }
        GenotypeDataset genotypes = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadGenotypes(this.args().inputPath(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.stringency());
        if (FileExtensions$.MODULE$.isVcfExt(this.args().outputPath())) {
            VariantContextDataset qual$1 = this.maybeSort(this.maybeCoalesce(genotypes).toVariantContexts());
            TransformGenotypesArgs x$1 = this.args();
            ValidationStringency x$2 = qual$1.saveAsVcf$default$2();
            qual$1.saveAsVcf((ADAMSaveAnyArgs)x$1, x$2);
            return;
        }
        if (this.args().partitionByStartPos()) {
            GenotypeDataset qual$2 = this.maybeSort(this.maybeCoalesce(genotypes));
            String x$3 = this.args().outputPath();
            int x$4 = this.args().partitionedBinSize();
            CompressionCodecName x$5 = qual$2.saveAsPartitionedParquet$default$2();
            qual$2.saveAsPartitionedParquet(x$3, x$5, x$4);
            return;
        }
        this.maybeSort(this.maybeCoalesce(genotypes)).saveAsParquet((SaveArgs)this.args());
    }

    public TransformGenotypes(TransformGenotypesArgs args) {
        this.args = args;
        Logging.$init$((Logging)this);
        BDGSparkCommand.$init$((BDGSparkCommand)this);
        this.companion = TransformGenotypes$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

