/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import htsjdk.samtools.ValidationStringency;
import java.io.Serializable;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.SparkContext;
import org.bdgenomics.adam.cli.FileSystemUtils$;
import org.bdgenomics.adam.cli.TransformVariants$;
import org.bdgenomics.adam.cli.TransformVariantsArgs;
import org.bdgenomics.adam.ds.ADAMContext$;
import org.bdgenomics.adam.ds.ADAMSaveAnyArgs;
import org.bdgenomics.adam.ds.GenomicDataset;
import org.bdgenomics.adam.ds.variant.VariantDataset;
import org.bdgenomics.adam.util.FileExtensions$;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.cli.SaveArgs;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015s!B\n\u0015\u0011\u0003ib!B\u0010\u0015\u0011\u0003\u0001\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nIBQ!P\u0001\u0005\u0002y2Aa\b\u000b\u0001\u0001\"A!\n\u0003BC\u0002\u0013\u00051\n\u0003\u0005M\u0011\t\u0005\t\u0015!\u0003H\u0011\u0015q\u0003\u0002\"\u0001N\u0011\u001dy\u0005B1A\u0005\u0002ACaA\u0015\u0005!\u0002\u0013\t\u0006bB*\t\u0005\u0004%\t\u0001\u0016\u0005\u0007;\"\u0001\u000b\u0011B+\t\u000byCA\u0011B0\t\u000b%DA\u0011\u00026\t\u000f\u0005%\u0001\u0002\"\u0001\u0002\f\u0005\tBK]1og\u001a|'/\u001c,be&\fg\u000e^:\u000b\u0005U1\u0012aA2mS*\u0011q\u0003G\u0001\u0005C\u0012\fWN\u0003\u0002\u001a5\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003m\t1a\u001c:h\u0007\u0001\u0001\"AH\u0001\u000e\u0003Q\u0011\u0011\u0003\u0016:b]N4wN]7WCJL\u0017M\u001c;t'\r\t\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!bS\"A\u0015\u000b\u0005UQ#BA\u0016\u0019\u0003\u0015)H/\u001b7t\u0013\ti\u0013FA\nC\t\u001e\u001bu.\\7b]\u0012\u001cu.\u001c9b]&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005Y1m\\7nC:$g*Y7f+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019\r|W.\\1oI:\u000bW.\u001a\u0011\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0001\u0014G>lW.\u00198e\t\u0016\u001c8M]5qi&|g\u000eI\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u007f\u0005\u001d\u0002C\u0001\u0010\t'\rA\u0011\t\u0012\t\u0003g\tK!a\u0011\u001b\u0003\r=\u0013'.Z2u!\rASiR\u0005\u0003\r&\u0012qB\u0011#H'B\f'o[\"p[6\fg\u000e\u001a\t\u0003=!K!!\u0013\u000b\u0003+Q\u0013\u0018M\\:g_Jlg+\u0019:jC:$8/\u0011:hg\u0006!\u0011M]4t+\u00059\u0015!B1sON\u0004CCA O\u0011\u0015Q5\u00021\u0001H\u0003%\u0019w.\u001c9b]&|g.F\u0001R\u001d\tq\u0002!\u0001\u0006d_6\u0004\u0018M\\5p]\u0002\n!b\u001d;sS:<WM\\2z+\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003!\u0019\u0018-\u001c;p_2\u001c(\"\u0001.\u0002\r!$8O\u001b3l\u0013\tavK\u0001\u000bWC2LG-\u0019;j_:\u001cFO]5oO\u0016t7-_\u0001\fgR\u0014\u0018N\\4f]\u000eL\b%A\u0007nCf\u0014WmQ8bY\u0016\u001c8-\u001a\u000b\u0003A\"\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u000fY\f'/[1oi*\u0011QMF\u0001\u0003INL!a\u001a2\u0003\u001dY\u000b'/[1oi\u0012\u000bG/Y:fi\")Q\r\u0005a\u0001A\u0006IQ.Y=cKN{'\u000f^\u000b\u0003W:$2\u0001\\A\u0004!\tig\u000e\u0004\u0001\u0005\u000b=\f\"\u0019\u00019\u0003\u0003U\u000b\"!\u001d;\u0011\u0005\t\u0012\u0018BA:$\u0005\u001dqu\u000e\u001e5j]\u001e\u0004D!\u001e>\u0002\u0004A1ao^=\u0002\u00021l\u0011\u0001Z\u0005\u0003q\u0012\u0014abR3o_6L7\rR1uCN,G\u000f\u0005\u0002nu\u0012I1P\\A\u0001\u0002\u0003\u0015\t\u0001 \u0002\u0004?\u0012\n\u0014CA9~!\t\u0011c0\u0003\u0002\u0000G\t\u0019\u0011I\\=\u0011\u00075\f\u0019\u0001\u0002\u0006\u0002\u00069\f\t\u0011!A\u0003\u0002q\u00141a\u0018\u00133\u0011\u0015)\u0017\u00031\u0001m\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002#\u0003\u001fI1!!\u0005$\u0005\u0011)f.\u001b;\t\u000f\u0005U!\u00031\u0001\u0002\u0018\u0005\u00111o\u0019\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\r\t\tCG\u0001\u0007CB\f7\r[3\n\t\u0005\u0015\u00121\u0004\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003S9\u0001\u0019AA\u0016\u0003\u001d\u0019W\u000e\u001a'j]\u0016\u0004RAIA\u0017\u0003cI1!a\f$\u0005\u0015\t%O]1z!\u0011\t\u0019$!\u0011\u000f\t\u0005U\u0012Q\b\t\u0004\u0003o\u0019SBAA\u001d\u0015\r\tY\u0004H\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}2%\u0001\u0004Qe\u0016$WMZ\u0005\u0004s\u0005\r#bAA G\u0001")
public class TransformVariants
implements BDGSparkCommand<TransformVariantsArgs> {
    private final TransformVariantsArgs args;
    private final TransformVariants$ companion;
    private final ValidationStringency stringency;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static TransformVariants apply(String[] stringArray) {
        return TransformVariants$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return TransformVariants$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return TransformVariants$.MODULE$.commandName();
    }

    public static void main(String[] stringArray) {
        TransformVariants$.MODULE$.main(stringArray);
    }

    public void run() {
        BDGSparkCommand.run$((BDGSparkCommand)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TransformVariants transformVariants = this;
        synchronized (transformVariants) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TransformVariantsArgs args() {
        return this.args;
    }

    public TransformVariants$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private VariantDataset maybeCoalesce(VariantDataset ds) {
        if (this.args().coalesce() != -1) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            if (this.args().coalesce() > ds.rdd().partitions().length || this.args().forceShuffle()) {
                return (VariantDataset)ds.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                    int x$1 = this.args().coalesce();
                    boolean x$2 = true;
                    Option x$3 = rdd.coalesce$default$3();
                    Ordering x$4 = rdd.coalesce$default$4(x$1, x$2, x$3);
                    return rdd.coalesce(x$1, x$2, x$3, x$4);
                });
            }
            return (VariantDataset)ds.transform((Function1 & Serializable & scala.Serializable)rdd -> {
                int x$5 = this.args().coalesce();
                boolean x$6 = false;
                Option x$7 = rdd.coalesce$default$3();
                Ordering x$8 = rdd.coalesce$default$4(x$5, x$6, x$7);
                return rdd.coalesce(x$5, x$6, x$7, x$8);
            });
        }
        return ds;
    }

    private <U extends GenomicDataset<?, ?, U>> U maybeSort(U ds) {
        if (this.args().sort()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Sorting before saving");
            return (U)ds.sort();
        }
        if (this.args().sortLexicographically()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Sorting lexicographically before saving");
            return (U)ds.sortLexicographically();
        }
        return ds;
    }

    public void run(SparkContext sc) {
        FileSystemUtils$.MODULE$.checkWriteablePath(this.args().outputPath(), sc.hadoopConfiguration());
        Predef$.MODULE$.require(!this.args().sort() || !this.args().sortLexicographically(), (Function0 & Serializable & scala.Serializable)() -> "Cannot set both -sort_on_save and -sort_lexicographically_on_save.");
        VariantDataset variants = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadVariants(this.args().inputPath(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.stringency());
        if (FileExtensions$.MODULE$.isVcfExt(this.args().outputPath())) {
            this.maybeSort(this.maybeCoalesce(variants).toVariantContexts()).saveAsVcf((ADAMSaveAnyArgs)this.args(), this.stringency());
            return;
        }
        if (this.args().partitionByStartPos()) {
            VariantDataset qual$1 = this.maybeSort(this.maybeCoalesce(variants));
            String x$1 = this.args().outputPath();
            int x$2 = this.args().partitionedBinSize();
            CompressionCodecName x$3 = qual$1.saveAsPartitionedParquet$default$2();
            qual$1.saveAsPartitionedParquet(x$1, x$3, x$2);
            return;
        }
        this.maybeSort(this.maybeCoalesce(variants)).saveAsParquet((SaveArgs)this.args());
    }

    public TransformVariants(TransformVariantsArgs args) {
        this.args = args;
        Logging.$init$((Logging)this);
        BDGSparkCommand.$init$((BDGSparkCommand)this);
        this.companion = TransformVariants$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

