/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.cli.ADAMSparkCommand;
import org.bdgenomics.adam.cli.ADAMSparkCommand$class;
import org.bdgenomics.adam.cli.SparkArgs;
import org.bdgenomics.adam.cli.SparkCommand$class;
import org.bdgenomics.adam.cli.Transform$;
import org.bdgenomics.adam.cli.TransformArgs;
import org.bdgenomics.adam.models.ADAMVariantContext;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext$;
import org.bdgenomics.adam.rich.RichADAMVariant;
import org.bdgenomics.adam.util.ParquetLogger$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I<Q!\u0001\u0002\t\u0002-\t\u0011\u0002\u0016:b]N4wN]7\u000b\u0005\r!\u0011aA2mS*\u0011QAB\u0001\u0005C\u0012\fWN\u0003\u0002\b\u0011\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011\u0011\u0002\u0016:b]N4wN]7\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0019]I!\u0001\u0007\u0002\u0003)\u0005#\u0015)T\"p[6\fg\u000eZ\"p[B\fg.[8o\u0011\u0015QR\u0002\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001e\u001b\t\u0007I\u0011\u0001\u0010\u0002\u0017\r|W.\\1oI:\u000bW.Z\u000b\u0002?A\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0005Y\u0006twMC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019\n#AB*ue&tw\r\u0003\u0004)\u001b\u0001\u0006IaH\u0001\rG>lW.\u00198e\u001d\u0006lW\r\t\u0005\bU5\u0011\r\u0011\"\u0001\u001f\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\t\r1j\u0001\u0015!\u0003 \u0003M\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8!\u0011\u0015qS\u0002\"\u00010\u0003\u0015\t\u0007\u000f\u001d7z)\t\u0001t\r\u0005\u0002\rc\u0019!aB\u0001\u00013'\u0011\t4G\u000e\u001f\u0011\u0005\u0001\"\u0014BA\u001b\"\u0005\u0019y%M[3diB\u0019AbN\u001d\n\u0005a\u0012!\u0001E!E\u00036\u001b\u0006/\u0019:l\u0007>lW.\u00198e!\ta!(\u0003\u0002<\u0005\tiAK]1og\u001a|'/\\!sON\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005C\u0011AB1qC\u000eDW-\u0003\u0002D}\t9Aj\\4hS:<\u0007\u0002C#2\u0005\u000b\u0007I\u0011\u0003$\u0002\t\u0005\u0014xm]\u000b\u0002s!A\u0001*\rB\u0001B\u0003%\u0011(A\u0003be\u001e\u001c\b\u0005C\u0003\u001bc\u0011\u0005!\n\u0006\u00021\u0017\")Q)\u0013a\u0001s!9Q*\rb\u0001\n\u0003q\u0015!C2p[B\fg.[8o+\u0005yeB\u0001\u0007\u0001\u0011\u0019\t\u0016\u0007)A\u0005\u001f\u0006Q1m\\7qC:LwN\u001c\u0011\t\u000bM\u000bD\u0011\u0001+\u0002\u0007I,h\u000eF\u0002V1v\u0003\"!\u0005,\n\u0005]\u0013\"\u0001B+oSRDQ!\u0017*A\u0002i\u000b!a]2\u0011\u0005uZ\u0016B\u0001/?\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015q&\u000b1\u0001`\u0003\rQwN\u0019\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\f\u0011\"\\1qe\u0016$WoY3\u000b\u0005\u0011\u0004\u0015A\u00025bI>|\u0007/\u0003\u0002gC\n\u0019!j\u001c2\t\u000b!l\u0003\u0019A5\u0002\u000f\rlG\rT5oKB\u0019\u0011C\u001b7\n\u0005-\u0014\"!B!se\u0006L\bCA7q\u001d\t\tb.\u0003\u0002p%\u00051\u0001K]3eK\u001aL!AJ9\u000b\u0005=\u0014\u0002")
public class Transform
implements ADAMSparkCommand<TransformArgs>,
Logging {
    private final TransformArgs args;
    private final Transform$ companion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        Transform$.MODULE$.main(stringArray);
    }

    public static Transform apply(String[] stringArray) {
        return Transform$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return Transform$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Transform$.MODULE$.commandName();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public void run() {
        ADAMSparkCommand$class.run(this);
    }

    @Override
    public Tuple2<String, String>[] parseEnvVariables(ArrayList<String> envVariables) {
        return SparkCommand$class.parseEnvVariables(this, envVariables);
    }

    @Override
    public SparkContext createSparkContext(SparkArgs args) {
        return SparkCommand$class.createSparkContext(this, args);
    }

    @Override
    public TransformArgs args() {
        return this.args;
    }

    @Override
    public Transform$ companion() {
        return this.companion;
    }

    @Override
    public void run(SparkContext sc, Job job) {
        ParquetLogger$.MODULE$.hadoopLoggerLevel().apply((Object)Level.SEVERE);
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
        String x$2 = this.args().inputPath();
        None$ x$3 = qual$1.adamLoad$default$2();
        Option x$4 = qual$1.adamLoad$default$3();
        RDD adamRecords = qual$1.adamLoad(x$2, (Option)x$3, x$4, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        if (this.args().repartition() != -1) {
            Predef$ predef$ = Predef$.MODULE$;
            this.log().info(new StringOps("Repartitioning reads to to '%d' partitions").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            adamRecords = adamRecords.repartition(this.args().repartition());
        }
        if (this.args().markDuplicates()) {
            this.log().info("Marking duplicates");
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamMarkDuplicates();
        }
        if (this.args().recalibrateBaseQualities()) {
            this.log().info("Recalibrating base qualities");
            ADAMVariationContext qual$2 = ADAMVariationContext$.MODULE$.sparkContextToADAMVariationContext(sc);
            String x$5 = this.args().knownSnpsFile();
            boolean x$6 = qual$2.adamVCFLoad$default$2();
            RDD variants = qual$2.adamVCFLoad(x$5, x$6).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RichADAMVariant apply(ADAMVariantContext x$1) {
                    return x$1.variant();
                }
            }, ClassTag$.MODULE$.apply(RichADAMVariant.class));
            SnpTable knownSnps = SnpTable$.MODULE$.apply(variants);
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamBQSR(sc.broadcast((Object)knownSnps));
        }
        if (this.args().locallyRealign()) {
            this.log().info("Locally realigning indels.");
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamRealignIndels();
        }
        if (this.args().coalesce() != -1) {
            Predef$ predef$ = Predef$.MODULE$;
            this.log().info(new StringOps("Coalescing the number of partitions to '%d'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            adamRecords = adamRecords.coalesce(this.args().coalesce(), true);
        }
        if (this.args().sortReads()) {
            this.log().info("Sorting reads");
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamSortReadsByReferencePosition();
        }
        ADAMContext$.MODULE$.rddToADAMRDD(adamRecords, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class)).adamSave(this.args().outputPath(), this.args().blockSize(), this.args().pageSize(), this.args().compressionCodec(), this.args().disableDictionary());
    }

    public Transform(TransformArgs args) {
        this.args = args;
        SparkCommand$class.$init$(this);
        ADAMSparkCommand$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.companion = Transform$.MODULE$;
    }
}

