/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import java.util.ArrayList;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.cli.ADAMCommand;
import org.bdgenomics.adam.cli.ADAMSparkCommand;
import org.bdgenomics.adam.cli.ADAMSparkCommand$class;
import org.bdgenomics.adam.cli.Fasta2ADAM$;
import org.bdgenomics.adam.cli.Fasta2ADAMArgs;
import org.bdgenomics.adam.cli.SparkArgs;
import org.bdgenomics.adam.cli.SparkCommand$class;
import org.bdgenomics.adam.instrumentation.ADAMMetricsListener;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.formats.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.formats.avro.ADAMRecord;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M<Q!\u0001\u0002\t\u0002-\t!BR1ti\u0006\u0014\u0014\tR!N\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!A\u0003$bgR\f''\u0011#B\u001bN\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\taq#\u0003\u0002\u0019\u0005\t!\u0012\tR!N\u0007>lW.\u00198e\u0007>l\u0007/\u00198j_:DQAG\u0007\u0005\u0002m\ta\u0001P5oSRtD#A\u0006\t\u000fui!\u0019!C\u0001=\u0005Y1m\\7nC:$g*Y7f+\u0005y\u0002C\u0001\u0011$\u001d\t\t\u0012%\u0003\u0002#%\u00051\u0001K]3eK\u001aL!\u0001J\u0013\u0003\rM#(/\u001b8h\u0015\t\u0011#\u0003\u0003\u0004(\u001b\u0001\u0006IaH\u0001\rG>lW.\u00198e\u001d\u0006lW\r\t\u0005\bS5\u0011\r\u0011\"\u0001\u001f\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\t\r-j\u0001\u0015!\u0003 \u0003M\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8!\u0011\u0015iS\u0002\"\u0001/\u0003\u0015\t\u0007\u000f\u001d7z)\ty#\u0007\u0005\u0002\ra%\u0011\u0011G\u0001\u0002\f\u0003\u0012\u000bUjQ8n[\u0006tG\rC\u00034Y\u0001\u0007A'A\u0004d[\u0012d\u0015N\\3\u0011\u0007E)t$\u0003\u00027%\t)\u0011I\u001d:bs\u001a!aB\u0001\u00019'\u00119\u0014(Q$\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00027b]\u001eT\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Aw\t1qJ\u00196fGR\u00042\u0001\u0004\"E\u0013\t\u0019%A\u0001\tB\t\u0006k5\u000b]1sW\u000e{W.\\1oIB\u0011A\"R\u0005\u0003\r\n\u0011aBR1ti\u0006\u0014\u0014\tR!N\u0003J<7\u000f\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006)1\u000f]1sW*\u0011A\nC\u0001\u0007CB\f7\r[3\n\u00059K%a\u0002'pO\u001eLgn\u001a\u0005\t!^\u0012)\u0019!C\t#\u0006!\u0011M]4t+\u0005!\u0005\u0002C*8\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u000b\u0005\u0014xm\u001d\u0011\t\u000bi9D\u0011A+\u0015\u0005Y;\u0006C\u0001\u00078\u0011\u0015\u0001F\u000b1\u0001E\u0011\u001dIvG1A\u0005\u0002i\u000b\u0011bY8na\u0006t\u0017n\u001c8\u0016\u0003ms!\u0001\u0004\u0001\t\ru;\u0004\u0015!\u0003\\\u0003)\u0019w.\u001c9b]&|g\u000e\t\u0005\u0006?^\"\t\u0001Y\u0001\u0004eVtGcA1eSB\u0011\u0011CY\u0005\u0003GJ\u0011A!\u00168ji\")QM\u0018a\u0001M\u0006\u00111o\u0019\t\u0003\u0011\u001eL!\u0001[%\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000b)t\u0006\u0019A6\u0002\u0007)|'\r\u0005\u0002mc6\tQN\u0003\u0002o_\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003a.\u000ba\u0001[1e_>\u0004\u0018B\u0001:n\u0005\rQuN\u0019")
public class Fasta2ADAM
implements ADAMSparkCommand<Fasta2ADAMArgs>,
Logging {
    private final Fasta2ADAMArgs args;
    private final Fasta2ADAM$ companion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        Fasta2ADAM$.MODULE$.main(stringArray);
    }

    public static ADAMCommand apply(String[] stringArray) {
        return Fasta2ADAM$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return Fasta2ADAM$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Fasta2ADAM$.MODULE$.commandName();
    }

    @Override
    public void run() {
        ADAMSparkCommand$class.run(this);
    }

    @Override
    public void printMetrics(long totalTime, Option<ADAMMetricsListener> metricsListener) {
        ADAMSparkCommand$class.printMetrics(this, totalTime, metricsListener);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public Tuple2<String, String>[] parseEnvVariables(ArrayList<String> envVariables) {
        return SparkCommand$class.parseEnvVariables(this, envVariables);
    }

    @Override
    public SparkContext createSparkContext(SparkArgs args, Option<ADAMMetricsListener> metricsListener) {
        return SparkCommand$class.createSparkContext(this, args, metricsListener);
    }

    @Override
    public Fasta2ADAMArgs args() {
        return this.args;
    }

    @Override
    public Fasta2ADAM$ companion() {
        return this.companion;
    }

    @Override
    public void run(SparkContext sc, Job job) {
        RDD rDD;
        this.log().info("Loading FASTA data from disk.");
        RDD adamFasta = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).adamSequenceLoad(this.args().fastaFile(), this.args().fragmentLength());
        if (this.args().verbose()) {
            Predef$.MODULE$.println((Object)"FASTA contains:");
            Predef$.MODULE$.println((Object)ADAMContext$.MODULE$.rddToADAMRDD(adamFasta).adamGetSequenceDictionary());
        }
        String string = this.args().reads();
        if (!(string != null ? !string.equals("") : "" != null)) {
            rDD = adamFasta;
        } else {
            SequenceDictionary readDict = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).adamDictionaryLoad(this.args().reads(), (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
            if (this.args().verbose()) {
                Predef$.MODULE$.println((Object)"Remapping with:");
                Predef$.MODULE$.println((Object)readDict);
            }
            RDD remapFasta = ADAMContext$.MODULE$.rddToADAMRDD(adamFasta).adamRewriteContigIds(readDict);
            if (this.args().verbose()) {
                Predef$.MODULE$.println((Object)"After remapping, have:");
                Predef$.MODULE$.println((Object)ADAMContext$.MODULE$.rddToADAMRDD(remapFasta).adamGetSequenceDictionary());
            }
            rDD = remapFasta;
        }
        RDD remapped = rDD;
        this.log().info("Writing records to disk.");
        ADAMContext$.MODULE$.rddToADAMRDD(remapped, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMNucleotideContigFragment.class)).adamSave(this.args().outputPath(), this.args().blockSize(), this.args().pageSize(), this.args().compressionCodec(), this.args().disableDictionary());
    }

    public Fasta2ADAM(Fasta2ADAMArgs args) {
        this.args = args;
        SparkCommand$class.$init$(this);
        Logging.class.$init$((Logging)this);
        ADAMSparkCommand$class.$init$(this);
        this.companion = Fasta2ADAM$.MODULE$;
    }
}

