/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import org.apache.avro.Schema;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.cli.ADAMCommand;
import org.bdgenomics.adam.cli.ADAMCommandCompanion;
import org.bdgenomics.adam.cli.ADAMSparkCommand;
import org.bdgenomics.adam.cli.ADAMSparkCommand$class;
import org.bdgenomics.adam.cli.CalculateDepth$;
import org.bdgenomics.adam.cli.CalculateDepthArgs;
import org.bdgenomics.adam.models.ReferenceMapping;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.BroadcastRegionJoin$;
import org.bdgenomics.adam.rich.ReferenceMappingContext;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%q!B\u0001\u0003\u0011\u0003Y\u0011AD\"bY\u000e,H.\u0019;f\t\u0016\u0004H\u000f\u001b\u0006\u0003\u0007\u0011\t1a\u00197j\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\tq1)\u00197dk2\fG/\u001a#faRD7cA\u0007\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"\u0001D\f\n\u0005a\u0011!\u0001F!E\u00036\u001bu.\\7b]\u0012\u001cu.\u001c9b]&|g\u000eC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9Q$\u0004b\u0001\n\u0003q\u0012aC2p[6\fg\u000e\u001a(b[\u0016,\u0012a\b\t\u0003A\rr!!E\u0011\n\u0005\t\u0012\u0012A\u0002)sK\u0012,g-\u0003\u0002%K\t11\u000b\u001e:j]\u001eT!A\t\n\t\r\u001dj\u0001\u0015!\u0003 \u00031\u0019w.\\7b]\u0012t\u0015-\\3!\u0011\u001dISB1A\u0005\u0002y\t!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\"11&\u0004Q\u0001\n}\t1cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0002BQ!L\u0007\u0005\u00029\nQ!\u00199qYf$\"a\f\u001a\u0011\u00051\u0001\u0014BA\u0019\u0003\u0005-\tE)Q'D_6l\u0017M\u001c3\t\u000bMb\u0003\u0019\u0001\u001b\u0002\u000f\rlG\rT5oKB\u0019\u0011#N\u0010\n\u0005Y\u0012\"!B!se\u0006Lh\u0001\u0002\b\u0003\u0001a\u001a2aN\u001dB!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u00142kK\u000e$\bc\u0001\u0007C\t&\u00111I\u0001\u0002\u0011\u0003\u0012\u000bUj\u00159be.\u001cu.\\7b]\u0012\u0004\"\u0001D#\n\u0005\u0019\u0013!AE\"bY\u000e,H.\u0019;f\t\u0016\u0004H\u000f[!sOND\u0001\u0002S\u001c\u0003\u0006\u0004%\t\"S\u0001\u0005CJ<7/F\u0001E\u0011!YuG!A!\u0002\u0013!\u0015!B1sON\u0004\u0003\"\u0002\u000e8\t\u0003iEC\u0001(P!\taq\u0007C\u0003I\u0019\u0002\u0007A\tC\u0004Ro\t\u0007I\u0011\u0001*\u0002\u0013\r|W\u000e]1oS>tW#\u0001\f\t\rQ;\u0004\u0015!\u0003\u0017\u0003)\u0019w.\u001c9b]&|g\u000e\t\u0005\u0006-^\"\taV\u0001\u0004eVtGc\u0001-\\KB\u0011\u0011#W\u0005\u00035J\u0011A!\u00168ji\")A,\u0016a\u0001;\u0006\u00111o\u0019\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\fQa\u001d9be.T!A\u0019\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t!wL\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003g+\u0002\u0007q-A\u0002k_\n\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u00135\f\u0007O]3ek\u000e,'B\u00017b\u0003\u0019A\u0017\rZ8pa&\u0011a.\u001b\u0002\u0004\u0015>\u0014\u0007\"\u000298\t\u0013\t\u0018!\u00047pC\u0012\u0004vn]5uS>t7\u000fF\u0003s\u0003\u0007\t)\u0001E\u0002tmbl\u0011\u0001\u001e\u0006\u0003k~\u000b1A\u001d3e\u0013\t9HOA\u0002S\t\u0012\u0003B!E=|?%\u0011!P\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005q|X\"A?\u000b\u0005y$\u0011AB7pI\u0016d7/C\u0002\u0002\u0002u\u0014qBU3gKJ,gnY3SK\u001eLwN\u001c\u0005\u00069>\u0004\r!\u0018\u0005\u0007\u0003\u000fy\u0007\u0019A\u0010\u0002\tA\fG\u000f\u001b")
public class CalculateDepth
implements ADAMSparkCommand<CalculateDepthArgs> {
    private final CalculateDepthArgs args;
    private final ADAMCommandCompanion companion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        CalculateDepth$.MODULE$.main(stringArray);
    }

    public static ADAMCommand apply(String[] stringArray) {
        return CalculateDepth$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return CalculateDepth$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return CalculateDepth$.MODULE$.commandName();
    }

    @Override
    public void run() {
        ADAMSparkCommand$class.run(this);
    }

    @Override
    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return ADAMSparkCommand$class.initializeMetrics(this, sc);
    }

    @Override
    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        ADAMSparkCommand$class.printMetrics(this, totalTime, metricsListener);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public CalculateDepthArgs args() {
        return this.args;
    }

    @Override
    public ADAMCommandCompanion companion() {
        return this.companion;
    }

    @Override
    public void run(SparkContext sc, Job job) {
        Schema proj = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig(), AlignmentRecordField$.MODULE$.start(), AlignmentRecordField$.MODULE$.cigar(), AlignmentRecordField$.MODULE$.readMapped()}));
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
        String x$6 = this.args().adamInputPath();
        Some x$7 = new Some((Object)proj);
        None$ x$8 = qual$1.loadAlignments$default$2();
        RDD adamRDD = qual$1.loadAlignments(x$6, (Option)x$8, (Option)x$7);
        RDD mappedRDD = adamRDD.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AlignmentRecord x$1) {
                return Predef$.MODULE$.Boolean2boolean(x$1.getReadMapped());
            }
        });
        RDD<Tuple2<ReferenceRegion, String>> vcf = this.loadPositions(sc, this.args().vcfInputPath());
        RDD variantPositions = vcf.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReferenceRegion apply(Tuple2<ReferenceRegion, String> x$2) {
                return (ReferenceRegion)x$2._1();
            }
        }, ClassTag$.MODULE$.apply(ReferenceRegion.class));
        Map variantNames = Predef$.MODULE$.refArrayOps((Object[])vcf.collect()).toMap(Predef$.MODULE$.conforms());
        RDD joinedRDD = this.args().cartesian() ? BroadcastRegionJoin$.MODULE$.cartesianFilter(variantPositions, mappedRDD, (ReferenceMapping)ReferenceMappingContext.ReferenceRegionReferenceMapping$.MODULE$, (ReferenceMapping)ReferenceMappingContext.AlignmentRecordReferenceMapping$.MODULE$, ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.apply(AlignmentRecord.class)) : BroadcastRegionJoin$.MODULE$.partitionAndJoin(sc, variantPositions, mappedRDD, (ReferenceMapping)ReferenceMappingContext.ReferenceRegionReferenceMapping$.MODULE$, (ReferenceMapping)ReferenceMappingContext.AlignmentRecordReferenceMapping$.MODULE$, ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
        OrderedRDDFunctions qual$2 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(joinedRDD.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ReferenceRegion, Object> apply(Tuple2<ReferenceRegion, AlignmentRecord> x0$1) {
                Tuple2<ReferenceRegion, AlignmentRecord> tuple2 = x0$1;
                if (tuple2 != null) {
                    ReferenceRegion region = (ReferenceRegion)tuple2._1();
                    Tuple2 tuple22 = new Tuple2((Object)region, (Object)BoxesRunTime.boxToInteger((int)1));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.Int(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$3, int x$4) {
                return this.apply$mcIII$sp(x$3, x$4);
            }

            public int apply$mcIII$sp(int x$3, int x$4) {
                return x$3 + x$4;
            }
        }), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.Int());
        boolean x$9 = qual$2.sortByKey$default$1();
        int x$10 = qual$2.sortByKey$default$2();
        RDD depths = qual$2.sortByKey(x$9, x$10);
        Predef$.MODULE$.println((Object)"location\tname\tdepth");
        Predef$.MODULE$.refArrayOps((Object[])depths.collect()).foreach((Function1)new Serializable(this, variantNames){
            public static final long serialVersionUID = 0L;
            private final Map variantNames$1;

            public final void apply(Tuple2<ReferenceRegion, Object> x0$2) {
                Tuple2<ReferenceRegion, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    ReferenceRegion region = (ReferenceRegion)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%20s\t%15s\t% 5d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("%s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{region.referenceName(), BoxesRunTime.boxToLong((long)region.start())})), this.variantNames$1.apply((Object)region), BoxesRunTime.boxToInteger((int)count)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.variantNames$1 = variantNames$1;
            }
        });
    }

    private RDD<Tuple2<ReferenceRegion, String>> loadPositions(SparkContext sc, String path) {
        return sc.parallelize(Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return !x$5.startsWith("#");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ReferenceRegion, String> apply(String line) {
                String[] array = line.split("\t");
                String chrom = array[0];
                long start = new StringOps(Predef$.MODULE$.augmentString(array[1])).toLong();
                String name = array[2];
                long end = start + (long)array[3].length();
                return new Tuple2((Object)new ReferenceRegion(chrom, start, end), (Object)name);
            }
        }).toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public CalculateDepth(CalculateDepthArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        ADAMSparkCommand$class.$init$(this);
        this.companion = CalculateDepth$.MODULE$;
    }
}

