/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import htsjdk.samtools.ValidationStringency;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromKnowns;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromReads;
import org.bdgenomics.adam.cli.Transform$;
import org.bdgenomics.adam.cli.TransformArgs;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rich.RichVariant;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=q!B\u0001\u0003\u0011\u0003Y\u0011!\u0003+sC:\u001chm\u001c:n\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!!\u0003+sC:\u001chm\u001c:n'\ri\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]YR\"\u0001\r\u000b\u0005\rI\"B\u0001\u000e\u0007\u0003\u0015)H/\u001b7t\u0013\ta\u0002DA\nC\t\u001e\u001bu.\\7b]\u0012\u001cu.\u001c9b]&|g\u000eC\u0003\u001f\u001b\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9\u0011%\u0004b\u0001\n\u0003\u0011\u0013aC2p[6\fg\u000e\u001a(b[\u0016,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\"1A&\u0004Q\u0001\n\r\nAbY8n[\u0006tGMT1nK\u0002BqAL\u0007C\u0002\u0013\u0005!%\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007B\u0002\u0019\u000eA\u0003%1%A\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007\u0005C\u00033\u001b\u0011\u00051'A\u0003baBd\u0017\u0010\u0006\u00025yB\u0011A\"\u000e\u0004\u0005\u001d\t\u0001ag\u0005\u00036oi\u0002\u0005C\u0001\u00139\u0013\tITE\u0001\u0004PE*,7\r\u001e\t\u0004/mj\u0014B\u0001\u001f\u0019\u0005=\u0011EiR*qCJ\\7i\\7nC:$\u0007C\u0001\u0007?\u0013\ty$AA\u0007Ue\u0006t7OZ8s[\u0006\u0013xm\u001d\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bQa\u001d9be.T!!\u0012\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t9%IA\u0004M_\u001e<\u0017N\\4\t\u0011%+$Q1A\u0005\u0012)\u000bA!\u0019:hgV\tQ\b\u0003\u0005Mk\t\u0005\t\u0015!\u0003>\u0003\u0015\t'oZ:!\u0011\u0015qR\u0007\"\u0001O)\t!t\nC\u0003J\u001b\u0002\u0007Q\bC\u0004Rk\t\u0007I\u0011\u0001*\u0002\u0013\r|W\u000e]1oS>tW#A*\u000f\u00051\u0001\u0001BB+6A\u0003%1+\u0001\u0006d_6\u0004\u0018M\\5p]\u0002BQAM\u001b\u0005\u0002]#\"\u0001\u00174\u0011\u0007ecf,D\u0001[\u0015\tY&)A\u0002sI\u0012L!!\u0018.\u0003\u0007I#E\t\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006!\u0011M\u001e:p\u0015\t\u0019g!A\u0004g_Jl\u0017\r^:\n\u0005\u0015\u0004'aD!mS\u001etW.\u001a8u%\u0016\u001cwN\u001d3\t\u000bm3\u0006\u0019\u0001-\t\u000b!,D\u0011A5\u0002\u0007I,h\u000e\u0006\u0002k[B\u0011\u0011c[\u0005\u0003YJ\u0011A!\u00168ji\")an\u001aa\u0001_\u0006\u00111o\u0019\t\u0003\u0003BL!!\u001d\"\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000bM,D\u0011\u0002;\u0002)\r\u0014X-\u0019;f\u0017:|wO\\*oaN$\u0016M\u00197f)\t)8\u0010\u0005\u0002ws6\tqO\u0003\u0002y\t\u00051Qn\u001c3fYNL!A_<\u0003\u0011Ms\u0007\u000fV1cY\u0016DQA\u001c:A\u0002=DQ!`\u0019A\u0002y\fqaY7e\u0019&tW\r\u0005\u0003\u0012\u007f\u0006\r\u0011bAA\u0001%\t)\u0011I\u001d:bsB!\u0011QAA\u0006\u001d\r\t\u0012qA\u0005\u0004\u0003\u0013\u0011\u0012A\u0002)sK\u0012,g-C\u0002+\u0003\u001bQ1!!\u0003\u0013\u0001")
public class Transform
implements BDGSparkCommand<TransformArgs>,
Logging {
    private final TransformArgs args;
    private final Transform$ companion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        Transform$.MODULE$.main(stringArray);
    }

    public static String commandDescription() {
        return Transform$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Transform$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public TransformArgs args() {
        return this.args;
    }

    public Transform$ companion() {
        return this.companion;
    }

    /*
     * WARNING - void declaration
     */
    public RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rdd) {
        void var2_2;
        RDD adamRecords = rdd;
        SparkContext sc = rdd.context();
        if (this.args().repartition() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            RDD qual$1 = adamRecords;
            int x$3 = this.args().repartition();
            Ordering x$4 = qual$1.repartition$default$2(x$3);
            adamRecords = qual$1.repartition(x$3, x$4);
        }
        if (this.args().markDuplicates()) {
            this.log().info("Marking duplicates");
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamMarkDuplicates();
        }
        if (this.args().locallyRealign()) {
            this.log().info("Locally realigning indels.");
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsensusGenerator apply() {
                    return new ConsensusGeneratorFromReads();
                }
            }, (Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;

                public final ConsensusGenerator apply(String x$1) {
                    return new ConsensusGeneratorFromKnowns(x$1, this.sc$1);
                }
                {
                    this.sc$1 = sc$1;
                }
            });
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamRealignIndels(consensusGenerator, false, this.args().maxIndelSize(), this.args().maxConsensusNumber(), this.args().lodThreshold(), this.args().maxTargetSize());
        }
        if (this.args().recalibrateBaseQualities()) {
            this.log().info("Recalibrating base qualities");
            SnpTable knownSnps = this.createKnownSnpsTable(sc);
            ValidationStringency stringency = this.args().strictBQSR() ? ValidationStringency.STRICT : ValidationStringency.LENIENT;
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamBQSR(sc.broadcast((Object)knownSnps, ClassTag$.MODULE$.apply(SnpTable.class)), Option$.MODULE$.apply((Object)this.args().observationsPath()), stringency);
        }
        if (this.args().coalesce() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            RDD qual$2 = adamRecords;
            int x$5 = this.args().coalesce();
            boolean x$6 = true;
            Ordering x$7 = qual$2.coalesce$default$3(x$5, x$6);
            adamRecords = qual$2.coalesce(x$5, x$6, x$7);
        }
        if (this.args().sortReads()) {
            this.log().info("Sorting reads");
            adamRecords = ADAMContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamSortReadsByReferencePosition();
        }
        return var2_2;
    }

    public void run(SparkContext sc) {
        RDD rDD;
        if (this.args().forceLoadBam()) {
            rDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadBam(this.args().inputPath());
        } else if (this.args().forceLoadFastq()) {
            rDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadUnpairedFastq(this.args().inputPath());
        } else if (this.args().forceLoadIFastq()) {
            rDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(this.args().inputPath());
        } else if (this.args().forceLoadParquet()) {
            ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$8 = this.args().inputPath();
            Option x$9 = qual$3.loadParquetAlignments$default$2();
            Option x$10 = qual$3.loadParquetAlignments$default$3();
            rDD = qual$3.loadParquetAlignments(x$8, x$9, x$10);
        } else {
            ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$11 = this.args().inputPath();
            Option x$12 = qual$4.loadAlignments$default$2();
            rDD = qual$4.loadAlignments(x$11, x$12);
        }
        ADAMContext$.MODULE$.rddToADAMRecordRDD(this.apply((RDD<AlignmentRecord>)rDD)).adamSave((ADAMSaveAnyArgs)this.args(), this.args().sortReads());
    }

    private SnpTable createKnownSnpsTable(SparkContext sc) {
        return (SnpTable)Timers$.MODULE$.CreateKnownSnpsTable().time((Function0)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Transform $outer;
            public final SparkContext sc$2;

            public final SnpTable apply() {
                return (SnpTable)Option$.MODULE$.apply((Object)this.$outer.args().knownSnpsFile()).fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SnpTable apply() {
                        return SnpTable$.MODULE$.apply();
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createKnownSnpsTable$1 $outer;

                    public final SnpTable apply(String f) {
                        ADAMContext qual$5 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc$2);
                        String x$13 = f;
                        Option x$14 = qual$5.loadVariants$default$2();
                        Option x$15 = qual$5.loadVariants$default$3();
                        return SnpTable$.MODULE$.apply(qual$5.loadVariants(x$13, x$14, x$15).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final RichVariant apply(Variant x$2) {
                                return new RichVariant(x$2);
                            }
                        }, ClassTag$.MODULE$.apply(RichVariant.class)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sc$2 = sc$2;
            }
        });
    }

    public Transform(TransformArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = Transform$.MODULE$;
    }
}

