/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import org.apache.avro.Schema;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.cli.CalculateDepth$;
import org.bdgenomics.adam.cli.CalculateDepthArgs;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.BroadcastRegionJoin$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.utils.cli.BDGCommand;
import org.bdgenomics.utils.cli.BDGCommandCompanion;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y<Q!\u0001\u0002\t\u0002-\tabQ1mGVd\u0017\r^3EKB$\bN\u0003\u0002\u0004\t\u0005\u00191\r\\5\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u00059\u0019\u0015\r\\2vY\u0006$X\rR3qi\"\u001c2!\u0004\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011qcG\u0007\u00021)\u00111!\u0007\u0006\u00035\u0019\tQ!\u001e;jYNL!\u0001\b\r\u0003'\t#uiQ8n[\u0006tGmQ8na\u0006t\u0017n\u001c8\t\u000byiA\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005Y\u0001bB\u0011\u000e\u0005\u0004%\tAI\u0001\fG>lW.\u00198e\u001d\u0006lW-F\u0001$!\t!sE\u0004\u0002\u0012K%\u0011aEE\u0001\u0007!J,G-\u001a4\n\u0005!J#AB*ue&twM\u0003\u0002'%!11&\u0004Q\u0001\n\r\nAbY8n[\u0006tGMT1nK\u0002Bq!L\u0007C\u0002\u0013\u0005!%\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007BB\u0018\u000eA\u0003%1%A\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007\u0005C\u00032\u001b\u0011\u0005!'A\u0003baBd\u0017\u0010\u0006\u00024mA\u0011q\u0003N\u0005\u0003ka\u0011!B\u0011#H\u0007>lW.\u00198e\u0011\u00159\u0004\u00071\u00019\u0003\u001d\u0019W\u000e\u001a'j]\u0016\u00042!E\u001d$\u0013\tQ$CA\u0003BeJ\f\u0017P\u0002\u0003\u000f\u0005\u0001a4cA\u001e>\u000bB\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005Y\u0006twMC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$AB(cU\u0016\u001cG\u000fE\u0002\u0018\r\"K!a\u0012\r\u0003\u001f\t#ui\u00159be.\u001cu.\\7b]\u0012\u0004\"\u0001D%\n\u0005)\u0013!AE\"bY\u000e,H.\u0019;f\t\u0016\u0004H\u000f[!sOND\u0001\u0002T\u001e\u0003\u0006\u0004%\t\"T\u0001\u0005CJ<7/F\u0001I\u0011!y5H!A!\u0002\u0013A\u0015!B1sON\u0004\u0003\"\u0002\u0010<\t\u0003\tFC\u0001*T!\ta1\bC\u0003M!\u0002\u0007\u0001\nC\u0004Vw\t\u0007I\u0011\u0001,\u0002\u0013\r|W\u000e]1oS>tW#\u0001\f\t\ra[\u0004\u0015!\u0003\u0017\u0003)\u0019w.\u001c9b]&|g\u000e\t\u0005\u00065n\"\taW\u0001\u0004eVtGC\u0001/`!\t\tR,\u0003\u0002_%\t!QK\\5u\u0011\u0015\u0001\u0017\f1\u0001b\u0003\t\u00198\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006)1\u000f]1sW*\u0011a\rC\u0001\u0007CB\f7\r[3\n\u0005!\u001c'\u0001D*qCJ\\7i\u001c8uKb$\b\"\u00026<\t\u0013Y\u0017!\u00047pC\u0012\u0004vn]5uS>t7\u000fF\u0002mwr\u00042!\u001c9s\u001b\u0005q'BA8d\u0003\r\u0011H\rZ\u0005\u0003c:\u00141A\u0015#E!\u0011\t2/^\u0012\n\u0005Q\u0014\"A\u0002+va2,'\u0007\u0005\u0002ws6\tqO\u0003\u0002y\t\u00051Qn\u001c3fYNL!A_<\u0003\u001fI+g-\u001a:f]\u000e,'+Z4j_:DQ\u0001Y5A\u0002\u0005DQ!`5A\u0002\r\nA\u0001]1uQ\u0002")
public class CalculateDepth
implements BDGSparkCommand<CalculateDepthArgs> {
    private final CalculateDepthArgs args;
    private final BDGCommandCompanion companion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        CalculateDepth$.MODULE$.main(stringArray);
    }

    public static BDGCommand apply(String[] stringArray) {
        return CalculateDepth$.MODULE$.apply(stringArray);
    }

    public static String commandDescription() {
        return CalculateDepth$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return CalculateDepth$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public CalculateDepthArgs args() {
        return this.args;
    }

    public BDGCommandCompanion companion() {
        return this.companion;
    }

    public void run(SparkContext sc) {
        Schema proj = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig(), AlignmentRecordField$.MODULE$.start(), AlignmentRecordField$.MODULE$.cigar(), AlignmentRecordField$.MODULE$.readMapped()}));
        RDD adamRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadAlignments(this.args().adamInputPath(), (Option)new Some((Object)proj));
        RDD mappedRDD = adamRDD.filter((Function1)new Serializable(this){

            public final boolean apply(AlignmentRecord x$1) {
                return Predef$.MODULE$.Boolean2boolean(x$1.getReadMapped());
            }
        });
        RDD<Tuple2<ReferenceRegion, String>> vcf = this.loadPositions(sc, this.args().vcfInputPath());
        RDD variantPositions = vcf.map((Function1)new Serializable(this){

            public final ReferenceRegion apply(Tuple2<ReferenceRegion, String> x$2) {
                return (ReferenceRegion)x$2._1();
            }
        }, ClassTag$.MODULE$.apply(ReferenceRegion.class));
        Map variantNames = Predef$.MODULE$.refArrayOps((Object[])vcf.collect()).toMap(Predef$.MODULE$.$conforms());
        RDD joinedRDD = this.args().cartesian() ? BroadcastRegionJoin$.MODULE$.cartesianFilter(variantPositions.keyBy((Function1)new Serializable(this){

            public final ReferenceRegion apply(ReferenceRegion v) {
                return v;
            }
        }), mappedRDD.keyBy((Function1)new Serializable(this){

            public final ReferenceRegion apply(AlignmentRecord x$3) {
                return ReferenceRegion$.MODULE$.apply(x$3);
            }
        }), ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.apply(AlignmentRecord.class)) : BroadcastRegionJoin$.MODULE$.partitionAndJoin(variantPositions.keyBy((Function1)new Serializable(this){

            public final ReferenceRegion apply(ReferenceRegion v) {
                return v;
            }
        }), mappedRDD.keyBy((Function1)new Serializable(this){

            public final ReferenceRegion apply(AlignmentRecord x$4) {
                return ReferenceRegion$.MODULE$.apply(x$4);
            }
        }), ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
        OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(joinedRDD.map((Function1)new Serializable(this){

            public final Tuple2<ReferenceRegion, Object> apply(Tuple2<ReferenceRegion, AlignmentRecord> x0$1) {
                Tuple2<ReferenceRegion, AlignmentRecord> tuple2 = x0$1;
                if (tuple2 != null) {
                    ReferenceRegion region = (ReferenceRegion)tuple2._1();
                    Tuple2 tuple22 = new Tuple2((Object)region, (Object)BoxesRunTime.boxToInteger((int)1));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.Int(), (Ordering)ReferenceRegion$.MODULE$.orderingForPositions()).reduceByKey((Function2)new Serializable(this){

            public final int apply(int x$5, int x$6) {
                return this.apply$mcIII$sp(x$5, x$6);
            }

            public int apply$mcIII$sp(int x$5, int x$6) {
                return x$5 + x$6;
            }
        }), (Ordering)ReferenceRegion$.MODULE$.orderingForPositions(), ClassTag$.MODULE$.apply(ReferenceRegion.class), ClassTag$.MODULE$.Int());
        boolean x$8 = qual$1.sortByKey$default$1();
        int x$9 = qual$1.sortByKey$default$2();
        RDD depths = qual$1.sortByKey(x$8, x$9);
        Predef$.MODULE$.println((Object)"location\tname\tdepth");
        Predef$.MODULE$.refArrayOps((Object[])depths.collect()).foreach((Function1)new Serializable(this, variantNames){
            private final Map variantNames$1;

            public final void apply(Tuple2<ReferenceRegion, Object> x0$2) {
                Tuple2<ReferenceRegion, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    ReferenceRegion region = (ReferenceRegion)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%20s\t%15s\t% 5d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("%s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{region.referenceName(), BoxesRunTime.boxToLong((long)region.start())})), this.variantNames$1.apply((Object)region), BoxesRunTime.boxToInteger((int)count)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.variantNames$1 = variantNames$1;
            }
        });
    }

    private RDD<Tuple2<ReferenceRegion, String>> loadPositions(SparkContext sc, String path) {
        return sc.parallelize(Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec()).getLines().filter((Function1)new Serializable(this){

            public final boolean apply(String x$7) {
                return !x$7.startsWith("#");
            }
        }).map((Function1)new Serializable(this){

            public final Tuple2<ReferenceRegion, String> apply(String line) {
                String[] array = line.split("\t");
                String chrom = array[0];
                long start = new StringOps(Predef$.MODULE$.augmentString(array[1])).toLong();
                String name = array[2];
                long end = start + (long)array[3].length();
                return new Tuple2((Object)new ReferenceRegion(chrom, start, end, ReferenceRegion$.MODULE$.apply$default$4()), (Object)name);
            }
        }).toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public CalculateDepth(CalculateDepthArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = CalculateDepth$.MODULE$;
    }
}

