/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import htsjdk.samtools.ValidationStringency;
import org.apache.parquet.filter2.dsl.Dsl;
import org.apache.parquet.filter2.dsl.Dsl$;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromKnowns;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromReads;
import org.bdgenomics.adam.cli.Transform$;
import org.bdgenomics.adam.cli.TransformArgs;
import org.bdgenomics.adam.instrumentation.Timers$;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Filter$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.AvroReadGroupGenomicRDD;
import org.bdgenomics.adam.rdd.GenomicRDD;
import org.bdgenomics.adam.rdd.read.AlignedReadRDD;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDD;
import org.bdgenomics.adam.rdd.read.MDTagging$;
import org.bdgenomics.adam.rich.RichVariant;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.bdgenomics.utils.misc.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=u!B\u0001\u0003\u0011\u0003Y\u0011!\u0003+sC:\u001chm\u001c:n\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!!\u0003+sC:\u001chm\u001c:n'\ri\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]YR\"\u0001\r\u000b\u0005\rI\"B\u0001\u000e\u0007\u0003\u0015)H/\u001b7t\u0013\ta\u0002DA\nC\t\u001e\u001bu.\\7b]\u0012\u001cu.\u001c9b]&|g\u000eC\u0003\u001f\u001b\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9\u0011%\u0004b\u0001\n\u0003\u0011\u0013aC2p[6\fg\u000e\u001a(b[\u0016,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\"1A&\u0004Q\u0001\n\r\nAbY8n[\u0006tGMT1nK\u0002BqAL\u0007C\u0002\u0013\u0005!%\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007B\u0002\u0019\u000eA\u0003%1%A\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0007\u0005C\u00033\u001b\u0011\u00051'A\u0003baBd\u0017\u0010F\u00025\u0003\u000b\u0003\"\u0001D\u001b\u0007\t9\u0011\u0001AN\n\u0005k]R\u0004\t\u0005\u0002%q%\u0011\u0011(\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007]YT(\u0003\u0002=1\ty!\tR$Ta\u0006\u00148nQ8n[\u0006tG\r\u0005\u0002\r}%\u0011qH\u0001\u0002\u000e)J\fgn\u001d4pe6\f%oZ:\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rK\u0012\u0001B7jg\u000eL!!\u0012\"\u0003\u000f1{wmZ5oO\"Aq)\u000eBC\u0002\u0013E\u0001*\u0001\u0003be\u001e\u001cX#A\u001f\t\u0011)+$\u0011!Q\u0001\nu\nQ!\u0019:hg\u0002BQAH\u001b\u0005\u00021#\"\u0001N'\t\u000b\u001d[\u0005\u0019A\u001f\t\u000f=+$\u0019!C\u0001!\u0006I1m\\7qC:LwN\\\u000b\u0002#:\u0011A\u0002\u0001\u0005\u0007'V\u0002\u000b\u0011B)\u0002\u0015\r|W\u000e]1oS>t\u0007\u0005C\u0004Vk\t\u0007I\u0011\u0001,\u0002\u0015M$(/\u001b8hK:\u001c\u00170F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0005tC6$xn\u001c7t\u0015\u0005a\u0016A\u00025ug*$7.\u0003\u0002_3\n!b+\u00197jI\u0006$\u0018n\u001c8TiJLgnZ3oGfDa\u0001Y\u001b!\u0002\u00139\u0016aC:ue&tw-\u001a8ds\u0002BQAY\u001b\u0005\n\r\f\u0001#\\1zE\u0016\u0014V\r]1si&$\u0018n\u001c8\u0015\u0005\u0011d\u0007CA3k\u001b\u00051'BA4i\u0003\u0011\u0011X-\u00193\u000b\u0005%$\u0011a\u0001:eI&\u00111N\u001a\u0002\u0013\u00032LwM\\7f]R\u0014VmY8sIJ#E\tC\u0003jC\u0002\u0007A\rC\u0003ok\u0011%q.A\u0006nCf\u0014W\rR3ekB,GC\u00013q\u0011\u0015IW\u000e1\u0001e\u0011\u0015\u0011X\u0007\"\u0003t\u00031i\u0017-\u001f2f%\u0016\fG.[4o)\r!G/\u001e\u0005\u0006SF\u0004\r\u0001\u001a\u0005\u0006mF\u0004\ra^\u0001\u0003g2\u0004\"\u0001_@\u000e\u0003eT!A_>\u0002\u000fM$xN]1hK*\u0011A0`\u0001\u0006gB\f'o\u001b\u0006\u0003}\"\ta!\u00199bG\",\u0017bAA\u0001s\na1\u000b^8sC\u001e,G*\u001a<fY\"9\u0011QA\u001b\u0005\n\u0005\u001d\u0011\u0001E7bs\n,'+Z2bY&\u0014'/\u0019;f)\u0015!\u0017\u0011BA\u0006\u0011\u0019I\u00171\u0001a\u0001I\"1a/a\u0001A\u0002]Dq!a\u00046\t\u0013\t\t\"A\u0007nCf\u0014WmQ8bY\u0016\u001c8-\u001a\u000b\u0004I\u0006M\u0001BB5\u0002\u000e\u0001\u0007A\rC\u0004\u0002\u0018U\"I!!\u0007\u0002\u00135\f\u0017PY3T_J$H#\u00023\u0002\u001c\u0005u\u0001BB5\u0002\u0016\u0001\u0007A\r\u0003\u0004w\u0003+\u0001\ra\u001e\u0005\b\u0003C)D\u0011AA\u0012\u0003)i\u0017-\u001f2f\u001b\u0012$\u0016m\u001a\u000b\u0006I\u0006\u0015\u0012q\u0005\u0005\u0007S\u0006}\u0001\u0019\u00013\t\u0011\u0005%\u0012q\u0004a\u0001\u0003W\tQb\u001d;sS:<WM\\2z\u001fB$\b\u0003B\t\u0002.]K1!a\f\u0013\u0005\u0019y\u0005\u000f^5p]\"1!'\u000eC\u0001\u0003g!2\u0001ZA\u001b\u0011\u0019I\u0017\u0011\u0007a\u0001I\"9\u0011\u0011H\u001b\u0005\u0002\u0005m\u0012a\u00044pe\u000e,gj\u001c8QCJ\fX/\u001a;\u0015\u0005\u0005u\u0002cA\t\u0002@%\u0019\u0011\u0011\t\n\u0003\u000f\t{w\u000e\\3b]\"9\u0011QI\u001b\u0005\u0002\u0005\u001d\u0013\u0001D5t\u001d>t\u0007+\u0019:rk\u0016$H\u0003BA\u001f\u0003\u0013B\u0001\"a\u0013\u0002D\u0001\u0007\u0011QJ\u0001\nS:\u0004X\u000f\u001e)bi\"\u0004B!a\u0014\u0002V9\u0019\u0011#!\u0015\n\u0007\u0005M##\u0001\u0004Qe\u0016$WMZ\u0005\u0004U\u0005]#bAA*%!9\u00111L\u001b\u0005\u0002\u0005u\u0013a\u0001:v]R!\u0011qLA3!\r\t\u0012\u0011M\u0005\u0004\u0003G\u0012\"\u0001B+oSRD\u0001\"a\u001a\u0002Z\u0001\u0007\u0011\u0011N\u0001\u0003g\u000e\u0004B!a\u001b\u0002n5\t10C\u0002\u0002pm\u0014Ab\u00159be.\u001cuN\u001c;fqRDq!a\u001d6\t\u0013\t)(\u0001\u000bde\u0016\fG/Z&o_^t7K\u001c9t)\u0006\u0014G.\u001a\u000b\u0005\u0003o\n\u0019\t\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bB\u0001\u0007[>$W\r\\:\n\t\u0005\u0005\u00151\u0010\u0002\t':\u0004H+\u00192mK\"A\u0011qMA9\u0001\u0004\tI\u0007C\u0004\u0002\bF\u0002\r!!#\u0002\u000f\rlG\rT5oKB)\u0011#a#\u0002N%\u0019\u0011Q\u0012\n\u0003\u000b\u0005\u0013(/Y=")
public class Transform
implements BDGSparkCommand<TransformArgs> {
    private final TransformArgs args;
    private final Transform$ companion;
    private final ValidationStringency stringency;
    private transient Logger org$bdgenomics$utils$misc$Logging$$log_;

    public static void main(String[] stringArray) {
        Transform$.MODULE$.main(stringArray);
    }

    public static String commandDescription() {
        return Transform$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Transform$.MODULE$.commandName();
    }

    public void run() {
        BDGSparkCommand.class.run((BDGSparkCommand)this);
    }

    public Option<MetricsListener> initializeMetrics(SparkContext sc) {
        return BDGSparkCommand.class.initializeMetrics((BDGSparkCommand)this, (SparkContext)sc);
    }

    public void printMetrics(long totalTime, Option<MetricsListener> metricsListener) {
        BDGSparkCommand.class.printMetrics((BDGSparkCommand)this, (long)totalTime, metricsListener);
    }

    public Logger org$bdgenomics$utils$misc$Logging$$log_() {
        return this.org$bdgenomics$utils$misc$Logging$$log_;
    }

    public void org$bdgenomics$utils$misc$Logging$$log__$eq(Logger x$1) {
        this.org$bdgenomics$utils$misc$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public TransformArgs args() {
        return this.args;
    }

    public Transform$ companion() {
        return this.companion;
    }

    public ValidationStringency stringency() {
        return this.stringency;
    }

    private AlignmentRecordRDD maybeRepartition(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().repartition() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            alignmentRecordRDD = (AlignmentRecordRDD)((GenomicRDD)rdd).transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$1) {
                    int x$8 = this.$outer.args().repartition();
                    Ordering x$9 = x$1.repartition$default$2(x$8);
                    return x$1.repartition(x$8, x$9);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeDedupe(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().markDuplicates()) {
            this.log().info("Marking duplicates");
            alignmentRecordRDD = rdd.markDuplicates();
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeRealign(AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().locallyRealign()) {
            this.log().info("Locally realigning indels.");
            Object object = this.args().cache() ? ((GenomicRDD)rdd).rdd().persist(sl) : BoxedUnit.UNIT;
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsensusGenerator apply() {
                    return new ConsensusGeneratorFromReads();
                }
            }, (Function1)new Serializable(this, rdd){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordRDD rdd$1;

                public final ConsensusGenerator apply(String x$2) {
                    return new ConsensusGeneratorFromKnowns(x$2, ((GenomicRDD)this.rdd$1).rdd().context());
                }
                {
                    this.rdd$1 = rdd$1;
                }
            });
            AlignmentRecordRDD realignmentRdd = rdd.realignIndels(consensusGenerator, false, this.args().maxIndelSize(), this.args().maxConsensusNumber(), this.args().lodThreshold(), this.args().maxTargetSize());
            Object object2 = this.args().cache() ? ((GenomicRDD)rdd).rdd().unpersist(((GenomicRDD)rdd).rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordRDD = realignmentRdd;
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeRecalibrate(AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().recalibrateBaseQualities()) {
            this.log().info("Recalibrating base qualities");
            Object object = this.args().cache() ? ((GenomicRDD)rdd).rdd().persist(sl) : BoxedUnit.UNIT;
            SnpTable knownSnps = this.createKnownSnpsTable(((GenomicRDD)rdd).rdd().context());
            AlignmentRecordRDD bqsredRdd = rdd.recalibateBaseQualities(((GenomicRDD)rdd).rdd().context().broadcast((Object)knownSnps, ClassTag$.MODULE$.apply(SnpTable.class)), Option$.MODULE$.apply((Object)this.args().observationsPath()), this.stringency());
            Object object2 = this.args().cache() ? ((GenomicRDD)rdd).rdd().unpersist(((GenomicRDD)rdd).rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordRDD = bqsredRdd;
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    private AlignmentRecordRDD maybeCoalesce(AlignmentRecordRDD rdd) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().coalesce() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            alignmentRecordRDD = this.args().coalesce() > Predef$.MODULE$.refArrayOps((Object[])((GenomicRDD)rdd).rdd().partitions()).size() || this.args().forceShuffle() ? (AlignmentRecordRDD)((GenomicRDD)rdd).transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$3) {
                    int x$10 = this.$outer.args().coalesce();
                    boolean x$11 = true;
                    Ordering x$12 = x$3.coalesce$default$3(x$10, x$11);
                    return x$3.coalesce(x$10, x$11, x$12);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }) : (AlignmentRecordRDD)((GenomicRDD)rdd).transform((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> x$4) {
                    int x$13 = this.$outer.args().coalesce();
                    boolean x$14 = false;
                    Ordering x$15 = x$4.coalesce$default$3(x$13, x$14);
                    return x$4.coalesce(x$13, x$14, x$15);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    /*
     * WARNING - void declaration
     */
    private AlignmentRecordRDD maybeSort(AlignmentRecordRDD rdd, StorageLevel sl) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().sortReads()) {
            void var3_3;
            Object object = this.args().cache() ? ((GenomicRDD)rdd).rdd().persist(sl) : BoxedUnit.UNIT;
            this.log().info("Sorting reads");
            AlignmentRecordRDD sortedRdd = this.args().sortLexicographically() ? rdd.sortReadsByReferencePosition() : rdd.sortReadsByReferencePositionAndIndex();
            Object object2 = this.args().cache() ? ((GenomicRDD)rdd).rdd().unpersist(((GenomicRDD)rdd).rdd().unpersist$default$1()) : BoxedUnit.UNIT;
            alignmentRecordRDD = var3_3;
        } else {
            alignmentRecordRDD = rdd;
        }
        return alignmentRecordRDD;
    }

    public AlignmentRecordRDD maybeMdTag(AlignmentRecordRDD rdd, Option<ValidationStringency> stringencyOpt) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().mdTagsReferenceFile() == null) {
            alignmentRecordRDD = rdd;
        } else {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding MDTags to reads based on reference file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args().mdTagsReferenceFile()})));
            alignmentRecordRDD = (AlignmentRecordRDD)((GenomicRDD)rdd).transform((Function1)new Serializable(this, stringencyOpt){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Transform $outer;
                private final Option stringencyOpt$1;

                public final RDD<AlignmentRecord> apply(RDD<AlignmentRecord> r) {
                    return MDTagging$.MODULE$.apply(r, this.$outer.args().mdTagsReferenceFile(), this.$outer.args().mdTagsFragmentSize(), this.$outer.args().mdTagsOverwrite(), (ValidationStringency)this.stringencyOpt$1.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ValidationStringency apply() {
                            return ValidationStringency.STRICT;
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.stringencyOpt$1 = stringencyOpt$1;
                }
            });
        }
        return alignmentRecordRDD;
    }

    public AlignmentRecordRDD apply(AlignmentRecordRDD rdd) {
        SparkContext sc = ((GenomicRDD)rdd).rdd().context();
        StorageLevel sl = StorageLevel$.MODULE$.fromString(this.args().storageLevel());
        Option stringencyOpt = Option$.MODULE$.apply((Object)this.args().stringency()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidationStringency apply(String x$5) {
                return ValidationStringency.valueOf((String)x$5);
            }
        });
        AlignmentRecordRDD initialRdd = this.maybeRepartition(rdd);
        AlignmentRecordRDD maybeDedupedRdd = this.maybeDedupe(initialRdd);
        AlignmentRecordRDD maybeRealignedRdd = this.maybeRealign(maybeDedupedRdd, sl);
        AlignmentRecordRDD maybeRecalibratedRdd = this.maybeRecalibrate(maybeRealignedRdd, sl);
        AlignmentRecordRDD finalPreprocessedRdd = this.maybeCoalesce(maybeRecalibratedRdd);
        AlignmentRecordRDD maybeSortedRdd = this.maybeSort(finalPreprocessedRdd, sl);
        return this.maybeMdTag(maybeSortedRdd, (Option<ValidationStringency>)stringencyOpt);
    }

    public boolean forceNonParquet() {
        return this.args().forceLoadBam() || this.args().forceLoadFastq() || this.args().forceLoadIFastq();
    }

    public boolean isNonParquet(String inputPath) {
        return inputPath.endsWith(".sam") || inputPath.endsWith(".bam") || inputPath.endsWith(".ifq") || inputPath.endsWith(".fq") || inputPath.endsWith(".fastq") || inputPath.endsWith(".fa") || inputPath.endsWith(".fasta");
    }

    public void run(SparkContext sc) {
        AlignmentRecordRDD alignmentRecordRDD;
        if (this.args().useAlignedReadPredicate() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().limitProjection() && this.forceNonParquet()) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet force load flag was passed.");
        }
        if (this.args().useAlignedReadPredicate() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-aligned_read_predicate only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().limitProjection() && this.isNonParquet(this.args().inputPath())) {
            throw new IllegalArgumentException("-limit_projection only applies to Parquet files, but a non-Parquet input path was specified.");
        }
        if (this.args().forceLoadBam()) {
            ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$16 = this.args().inputPath();
            ValidationStringency x$17 = qual$1.loadBam$default$2();
            alignmentRecordRDD = qual$1.loadBam(x$16, x$17);
        } else if (this.args().forceLoadFastq()) {
            alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadFastq(this.args().inputPath(), Option$.MODULE$.apply((Object)this.args().pairedFastqFile()), Option$.MODULE$.apply((Object)this.args().fastqRecordGroup()), this.stringency());
        } else if (this.args().forceLoadIFastq()) {
            alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadInterleavedFastq(this.args().inputPath());
        } else if (this.args().forceLoadParquet() || this.args().useAlignedReadPredicate() || this.args().limitProjection()) {
            None$ pred = this.args().useAlignedReadPredicate() ? new Some((Object)Dsl$.MODULE$.enrichEqNotEq((Dsl.Column)new Dsl.BooleanColumn("readMapped")).$eq$eq$eq((Comparable)Predef$.MODULE$.boolean2Boolean(true))) : None$.MODULE$;
            None$ proj = this.args().limitProjection() ? new Some((Object)Filter$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.attributes(), AlignmentRecordField$.MODULE$.origQual()}))) : None$.MODULE$;
            alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(sc).loadParquetAlignments(this.args().inputPath(), (Option)pred, (Option)proj);
        } else {
            ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
            String x$18 = this.args().inputPath();
            Option x$19 = Option$.MODULE$.apply((Object)this.args().pairedFastqFile());
            Option x$20 = Option$.MODULE$.apply((Object)this.args().fastqRecordGroup());
            ValidationStringency x$21 = this.stringency();
            Option x$22 = qual$2.loadAlignments$default$2();
            alignmentRecordRDD = qual$2.loadAlignments(x$18, x$22, x$19, x$20, x$21);
        }
        AlignmentRecordRDD aRdd = alignmentRecordRDD;
        RDD rdd = ((GenomicRDD)aRdd).rdd();
        SequenceDictionary sd = ((GenomicRDD)aRdd).sequences();
        RecordGroupDictionary rgd = ((AvroReadGroupGenomicRDD)aRdd).recordGroups();
        Option concatOpt = Option$.MODULE$.apply((Object)this.args().concatFilename()).map((Function1)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Transform $outer;
            private final SparkContext sc$2;

            public final AlignmentRecordRDD apply(String concatFilename) {
                AlignmentRecordRDD alignmentRecordRDD;
                if (this.$outer.args().forceLoadBam()) {
                    ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2);
                    String x$23 = concatFilename;
                    ValidationStringency x$24 = qual$3.loadBam$default$2();
                    alignmentRecordRDD = qual$3.loadBam(x$23, x$24);
                } else if (this.$outer.args().forceLoadIFastq()) {
                    alignmentRecordRDD = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2).loadInterleavedFastq(concatFilename);
                } else if (this.$outer.args().forceLoadParquet()) {
                    ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2);
                    String x$25 = concatFilename;
                    Option x$26 = qual$4.loadParquetAlignments$default$2();
                    Option x$27 = qual$4.loadParquetAlignments$default$3();
                    alignmentRecordRDD = qual$4.loadParquetAlignments(x$25, x$26, x$27);
                } else {
                    ADAMContext qual$5 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc$2);
                    String x$28 = concatFilename;
                    Option x$29 = Option$.MODULE$.apply((Object)this.$outer.args().fastqRecordGroup());
                    Option x$30 = qual$5.loadAlignments$default$2();
                    Option x$31 = qual$5.loadAlignments$default$3();
                    ValidationStringency x$32 = qual$5.loadAlignments$default$5();
                    alignmentRecordRDD = qual$5.loadAlignments(x$28, x$30, x$31, x$29, x$32);
                }
                return alignmentRecordRDD;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sc$2 = sc$2;
            }
        });
        Tuple3 tuple3 = (Tuple3)concatOpt.fold((Function0)new Serializable(this, rdd, sd, rgd){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$2;
            private final SequenceDictionary sd$1;
            private final RecordGroupDictionary rgd$1;

            public final Tuple3<RDD<AlignmentRecord>, SequenceDictionary, RecordGroupDictionary> apply() {
                return new Tuple3((Object)this.rdd$2, (Object)this.sd$1, (Object)this.rgd$1);
            }
            {
                this.rdd$2 = rdd$2;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
            }
        }, (Function1)new Serializable(this, rdd, sd, rgd){
            public static final long serialVersionUID = 0L;
            private final RDD rdd$2;
            private final SequenceDictionary sd$1;
            private final RecordGroupDictionary rgd$1;

            public final Tuple3<RDD<AlignmentRecord>, SequenceDictionary, RecordGroupDictionary> apply(AlignmentRecordRDD t) {
                return new Tuple3((Object)this.rdd$2.$plus$plus(((GenomicRDD)t).rdd()), (Object)this.sd$1.$plus$plus(((GenomicRDD)t).sequences()), (Object)this.rgd$1.$plus$plus(((AvroReadGroupGenomicRDD)t).recordGroups()));
            }
            {
                this.rdd$2 = rdd$2;
                this.sd$1 = sd$1;
                this.rgd$1 = rgd$1;
            }
        });
        if (tuple3 != null) {
            Tuple3 tuple32;
            RDD mergedRdd = (RDD)tuple3._1();
            SequenceDictionary mergedSd = (SequenceDictionary)tuple3._2();
            RecordGroupDictionary mergedRgd = (RecordGroupDictionary)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)mergedRdd, (Object)mergedSd, (Object)mergedRgd);
            RDD mergedRdd2 = (RDD)tuple33._1();
            SequenceDictionary mergedSd2 = (SequenceDictionary)tuple33._2();
            RecordGroupDictionary mergedRgd2 = (RecordGroupDictionary)tuple33._3();
            AlignedReadRDD newRdd = new AlignedReadRDD(mergedRdd2, mergedSd2, mergedRgd2);
            AlignmentRecordRDD outputRdd = this.apply((AlignmentRecordRDD)newRdd);
            SequenceDictionary sdFinal = this.args().sortReads() ? (this.args().sortLexicographically() ? mergedSd2.stripIndices().sorted() : mergedSd2) : mergedSd2;
            outputRdd.save((ADAMSaveAnyArgs)this.args(), this.args().sortReads() || this.args().sortLexicographically());
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private SnpTable createKnownSnpsTable(SparkContext sc) {
        return (SnpTable)Timers$.MODULE$.CreateKnownSnpsTable().time((Function0)new Serializable(this, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Transform $outer;
            public final SparkContext sc$1;

            public final SnpTable apply() {
                return (SnpTable)Option$.MODULE$.apply((Object)this.$outer.args().knownSnpsFile()).fold((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SnpTable apply() {
                        return SnpTable$.MODULE$.apply();
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createKnownSnpsTable$1 $outer;

                    public final SnpTable apply(String f) {
                        ADAMContext qual$6 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc$1);
                        String x$33 = f;
                        Option x$34 = qual$6.loadVariants$default$2();
                        return SnpTable$.MODULE$.apply(qual$6.loadVariants(x$33, x$34).rdd().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final RichVariant apply(Variant x$7) {
                                return new RichVariant(x$7);
                            }
                        }, ClassTag$.MODULE$.apply(RichVariant.class)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sc$1 = sc$1;
            }
        });
    }

    public Transform(TransformArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        BDGSparkCommand.class.$init$((BDGSparkCommand)this);
        this.companion = Transform$.MODULE$;
        this.stringency = ValidationStringency.valueOf((String)args.stringency());
    }
}

